/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.core.impl;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.impl.FileHandler;
import com.vertica.dsi.core.impl.StreamHandler;
import com.vertica.dsi.core.interfaces.ILogHandler;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.LogLevel;
import com.vertica.support.SettingReader;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.support.exceptions.ExceptionUtilities;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DSILogger
implements ILogger {
    public static final String LOG_PRINT_WRITER_KEY = "LogPrintWriter";
    private static final String LOG_FILE_EXTENSION = ".log";
    private volatile LogLevel m_level = LogLevel.OFF;
    private volatile LogLevel m_showStackTrace = LogLevel.TRACE;
    private String m_fileName;
    private volatile Locale m_locale;
    private String m_package = "";
    private ILogHandler m_logHandler;
    private volatile boolean m_logStackOnEntrance = false;

    public DSILogger(String fileName) {
        this.prepareSettings(fileName);
        this.setLocale(ExceptionUtilities.createLocale(SettingReader.readSetting("DriverLocale")));
    }

    public DSILogger(String fileName, LogLevel showStackTrace) {
        this.prepareSettings(fileName);
        this.setShowStackTraceLevel(showStackTrace);
        this.setLocale(ExceptionUtilities.createLocale(SettingReader.readSetting("DriverLocale")));
    }

    public DSILogger(String in_fileName, LogLevel in_logLevel, String in_path, String in_package) {
        this.prepareSettings(in_fileName, in_logLevel, in_path, in_package);
        this.m_locale = ExceptionUtilities.createLocale(SettingReader.readSetting("DriverLocale"));
    }

    public void enableEntranceStackLogging() {
        this.m_logStackOnEntrance = true;
    }

    public synchronized String getFileName() {
        int separator;
        if (null != this.m_fileName && -1 != (separator = this.m_fileName.lastIndexOf(File.separator))) {
            return this.m_fileName.substring(separator + 1);
        }
        return this.m_fileName;
    }

    @Override
    public synchronized Locale getLocale() {
        return this.m_locale;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.m_level;
    }

    public LogLevel getShowStackTraceLevel() {
        return this.m_showStackTrace;
    }

    @Override
    public boolean isEnabled() {
        return this.m_level != LogLevel.OFF;
    }

    @Override
    public void logDebug(String packageName, String className, String methodName, ErrorException error) {
        this.logDebug(packageName, className, methodName, this.getExceptionMessage(error));
    }

    @Override
    public void logDebug(String packageName, String className, String methodName, String message) {
        String formattedLine = this.formatLogLine(LogLevel.DEBUG, packageName, className, methodName, message);
        if (null != formattedLine) {
            this.writeLogLine(formattedLine, LogLevel.DEBUG, false);
        }
    }

    @Override
    public void logError(String packageName, String className, String methodName, ErrorException error) {
        this.logError(packageName, className, methodName, this.getExceptionMessage(error));
    }

    @Override
    public void logError(String packageName, String className, String methodName, String message) {
        String formattedLine = this.formatLogLine(LogLevel.ERROR, packageName, className, methodName, message);
        if (null != formattedLine) {
            this.writeLogLine(formattedLine, LogLevel.ERROR, false);
        }
    }

    @Override
    public void logFatal(String packageName, String className, String methodName, String message) {
        String formattedLine = this.formatLogLine(LogLevel.FATAL, packageName, className, methodName, message);
        if (null != formattedLine) {
            this.writeLogLine(formattedLine, LogLevel.FATAL, false);
        }
    }

    @Override
    public void logFunctionEntrance(String packageName, String className, String methodName) {
        String formattedLine = this.formatLogLine(LogLevel.TRACE, packageName, className, methodName, "+++++ enter +++++");
        if (null != formattedLine) {
            this.writeLogLine(formattedLine, LogLevel.TRACE, true);
        }
    }

    @Override
    public void logInfo(String packageName, String className, String methodName, String message) {
        String formattedLine = this.formatLogLine(LogLevel.INFO, packageName, className, methodName, message);
        if (null != formattedLine) {
            this.writeLogLine(formattedLine, LogLevel.INFO, false);
        }
    }

    @Override
    public void logTrace(String packageName, String className, String methodName, String message) {
        String formattedLine = this.formatLogLine(LogLevel.TRACE, packageName, className, methodName, message);
        if (null != formattedLine) {
            this.writeLogLine(formattedLine, LogLevel.TRACE, false);
        }
    }

    @Override
    public void logWarning(String packageName, String className, String methodName, String message) {
        String formattedLine = this.formatLogLine(LogLevel.WARNING, packageName, className, methodName, message);
        if (null != formattedLine) {
            this.writeLogLine(formattedLine, LogLevel.WARNING, false);
        }
    }

    public synchronized void prepareSettings(String in_fileName, LogLevel in_logLevel, String in_path, String in_package) {
        this.m_fileName = this.resolveDirectory(in_path);
        if (this.m_fileName == null) {
            if (this.isEnabled()) {
                this.m_logHandler = new StreamHandler();
            }
            return;
        }
        if (!in_fileName.contains(".")) {
            in_fileName = in_fileName + LOG_FILE_EXTENSION;
        }
        this.m_fileName = this.m_fileName + in_fileName;
        this.m_package = in_package;
        this.setLogLevel(in_logLevel);
    }

    public synchronized void prepareSettings(String fileName) {
        this.prepareSettings(fileName, this.readLogLevel(), this.readLogPath(), this.readNamespace());
    }

    private String readNamespace() {
        String pkg = SettingReader.readSetting("LogNamespace");
        return pkg == null ? "" : pkg;
    }

    private String readLogPath() {
        return SettingReader.readSetting("LogPath");
    }

    private LogLevel readLogLevel() {
        return LogLevel.getLogLevel(SettingReader.readSetting("LogLevel"));
    }

    @Override
    public synchronized void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    @Override
    public synchronized void setLogLevel(LogLevel logLevel) {
        this.m_level = logLevel;
        if (LogLevel.OFF != logLevel && null == this.m_logHandler) {
            this.initializeFileHandler();
        }
    }

    public synchronized void setShowStackTraceLevel(LogLevel logLevel) {
        this.m_showStackTrace = logLevel;
    }

    public synchronized void setLogPackage(String logPackage) {
        if (logPackage == null) {
            throw null;
        }
        this.m_package = logPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatLogLine(LogLevel logLevel, String packageName, String className, String methodName, String message) {
        DSILogger dSILogger = this;
        synchronized (dSILogger) {
            if (null == this.m_logHandler) {
                return null;
            }
        }
        String formattedLine = null;
        if (this.isInLevel(logLevel) && this.isInPackage(packageName)) {
            StringBuffer lineBuffer = new StringBuffer();
            SimpleDateFormat dateFormat = null;
            dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss.SSS");
            dateFormat.format(new Date(), lineBuffer, new FieldPosition(0));
            lineBuffer.append(" ");
            switch (logLevel) {
                case FATAL: {
                    lineBuffer.append("FATAL");
                    break;
                }
                case ERROR: {
                    lineBuffer.append("ERROR");
                    break;
                }
                case WARNING: {
                    lineBuffer.append("WARN ");
                    break;
                }
                case INFO: {
                    lineBuffer.append("INFO ");
                    break;
                }
                case DEBUG: {
                    lineBuffer.append("DEBUG");
                    break;
                }
                case TRACE: {
                    lineBuffer.append("TRACE");
                    break;
                }
                default: {
                    lineBuffer.append("LEVEL");
                }
            }
            lineBuffer.append(" ");
            lineBuffer.append(Thread.currentThread().getId()).append(" ");
            lineBuffer.append(packageName);
            lineBuffer.append(".");
            lineBuffer.append(className);
            lineBuffer.append(".");
            lineBuffer.append(methodName);
            lineBuffer.append(": ");
            lineBuffer.append(message);
            formattedLine = lineBuffer.toString();
        }
        return formattedLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExceptionMessage(ErrorException error) {
        DSILogger dSILogger = this;
        synchronized (dSILogger) {
            error.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), this.m_locale);
        }
        StringWriter sw = new StringWriter();
        error.printStackTrace(new PrintWriter(sw));
        return error.getMessage() + "\n" + sw.toString();
    }

    private void initializeFileHandler() {
        try {
            this.m_logHandler = new FileHandler(this.m_fileName);
        }
        catch (Exception e) {
            this.m_logHandler = new StreamHandler();
            ErrorException ex = DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DEFAULT_LOGGING.name(), e.getLocalizedMessage(), ExceptionType.DEFAULT);
            ex.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            System.out.println(ex.getMessage());
        }
    }

    private boolean isInLevel(LogLevel level) {
        return level.ordinal() <= this.m_level.ordinal();
    }

    private boolean showTrace(LogLevel level, boolean isEntranceLog) {
        if (LogLevel.OFF == this.m_showStackTrace || isEntranceLog && !this.m_logStackOnEntrance) {
            return false;
        }
        return level.ordinal() >= this.m_showStackTrace.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInPackage(String packageName) {
        if (null == packageName) {
            return false;
        }
        DSILogger dSILogger = this;
        synchronized (dSILogger) {
            return packageName.startsWith(this.m_package);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String resolveDirectory(String dirPath) {
        String newPath = "";
        try {
            File directory;
            if (null != dirPath && !(newPath = (directory = new File(dirPath)).getCanonicalPath()).endsWith(File.separator)) {
                newPath = newPath + File.separator;
            }
        }
        catch (Exception e) {
            DSILogger dSILogger = this;
            synchronized (dSILogger) {
                ErrorException ex = DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DEFAULT_LOGGING.name(), e.getLocalizedMessage(), ExceptionType.DEFAULT);
                ex.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                System.out.println(ex.getMessage());
                return null;
            }
        }
        return newPath;
    }

    private synchronized void writeLogLine(String formattedLine, LogLevel level, boolean isEntranceLog) {
        try {
            this.m_logHandler.writeLog(formattedLine);
            String stackTrace = this.logStackTrace(level, isEntranceLog);
            if (null != stackTrace) {
                this.m_logHandler.writeLog(stackTrace);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String logStackTrace(LogLevel level, boolean isEntranceLog) {
        if (!this.showTrace(level, isEntranceLog)) {
            return null;
        }
        Throwable throwable = new Throwable();
        StackTraceElement[] stackElements = throwable.getStackTrace();
        StringBuffer stackTrace = new StringBuffer();
        for (int i = 2; i < stackElements.length; ++i) {
            stackTrace.append("   at ");
            stackTrace.append(stackElements[i].toString());
            stackTrace.append("\n");
        }
        return stackTrace.toString();
    }
}

