/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.deserializer.impl;

import com.vertica.deserializer.Deserializer;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.jdbc.VerticaYearMonthInterval;
import com.vertica.util.ClientErrorException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class IntervalYMDeserializerImpl
implements Deserializer {
    private static final int ASCII_OFFSET = 48;
    private int m_sqlType;
    private int m_formatcode;

    public IntervalYMDeserializerImpl(int n, int n2) {
        this.m_formatcode = n2;
        this.m_sqlType = n;
    }

    @Override
    public boolean deserialize(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException, ClientErrorException {
        VerticaYearMonthInterval verticaYearMonthInterval = IntervalYMDeserializerImpl.parseIntervalYM(this.m_sqlType, byArray, this.m_formatcode);
        dataWrapper.setInterval(verticaYearMonthInterval);
        return false;
    }

    public static VerticaYearMonthInterval parseIntervalYM(int n, byte[] byArray, int n2) throws ClientErrorException {
        boolean bl = false;
        if (n2 == 1) {
            long l = ByteBuffer.wrap(byArray).getLong();
            if (l < 0L) {
                bl = true;
                l = -l;
            }
            switch (n) {
                case 101: {
                    return new VerticaYearMonthInterval(n, (int)(l / 12L), 0, bl);
                }
                case 102: {
                    return new VerticaYearMonthInterval(n, 0, (int)l, bl);
                }
                case 107: {
                    return new VerticaYearMonthInterval(n, (int)(l / 12L), (int)(l % 12L), bl);
                }
            }
            throw new ClientErrorException("Unexpected SQL type [" + n + "]");
        }
        int n3 = 0;
        if (byArray[n3] == 45) {
            ++n3;
            bl = true;
        }
        int n4 = 0;
        while (n3 < byArray.length && byArray[n3] != 45) {
            if (!Character.isDigit(byArray[n3])) {
                throw new ClientErrorException(byArray[n3] + " should be a digit, but is not");
            }
            n4 = n4 * 10 + (byArray[n3++] - 48);
        }
        if (n3 == byArray.length) {
            return n == 101 ? new VerticaYearMonthInterval(n, n4, 0, bl) : new VerticaYearMonthInterval(n, 0, n4, bl);
        }
        if (n != 107) {
            throw new ClientErrorException("Unexpected SQL type [" + n + "]");
        }
        if (byArray[n3] != 45) {
            throw new ClientErrorException("Illegal character [" + byArray[n3] + "]");
        }
        ++n3;
        int n5 = 0;
        while (n3 < byArray.length) {
            if (!Character.isDigit(byArray[n3])) {
                throw new ClientErrorException(byArray[n3] + " should be a digit, but is not");
            }
            n5 = n5 * 10 + (byArray[n3++] - 48);
        }
        return new VerticaYearMonthInterval(n, n4, n5, bl);
    }
}

