/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.deserializer.impl;

import com.vertica.deserializer.MultiFormatDeserializer;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.util.ClientErrorException;
import com.vertica.util.TimeStampParser;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TimeZone;

public class DateDeserializerImpl
implements MultiFormatDeserializer {
    private static final long SECONDS_PER_DAY = 86400L;

    @Override
    public boolean deserializeBinary(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException, ClientErrorException {
        DateDeserializerImpl.deserializeDate(dataWrapper, byArray, 1);
        return false;
    }

    @Override
    public boolean deserializeText(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException, ClientErrorException {
        DateDeserializerImpl.deserializeDate(dataWrapper, byArray, 0);
        return false;
    }

    public static Date deserializeDate(DataWrapper dataWrapper, byte[] byArray, int n) throws UnsupportedEncodingException {
        if (n == 1) {
            Comparable<Calendar> comparable;
            long l = ByteBuffer.wrap(byArray).getLong();
            long l2 = DateDeserializerImpl.toJavaSecs((l -= 2440588L) * 86400L) * 1000L;
            TimeZone timeZone = TimeZone.getDefault();
            String string = timeZone.getID();
            if (string.startsWith("GMT") || string.startsWith("UTC")) {
                l2 -= (long)timeZone.getRawOffset();
            } else {
                comparable = new GregorianCalendar();
                ((Calendar)comparable).setTimeZone(TimeZone.getTimeZone("UTC"));
                ((Calendar)comparable).setTimeInMillis(l2);
                int n2 = ((Calendar)comparable).get(0);
                int n3 = ((Calendar)comparable).get(1);
                int n4 = ((Calendar)comparable).get(2);
                int n5 = ((Calendar)comparable).get(5);
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.set(0, n2);
                calendar.set(n3, n4, n5, 0, 0, 0);
                l2 = calendar.getTimeInMillis();
            }
            comparable = new Date(l2);
            if (dataWrapper != null) {
                dataWrapper.setDate((Date)comparable);
            }
            return comparable;
        }
        TimeStampParser timeStampParser = new TimeStampParser(byArray);
        Calendar calendar = timeStampParser.getCalendar(10);
        Date date = new Date(calendar.getTimeInMillis());
        if (dataWrapper != null) {
            dataWrapper.setDate(date);
        }
        return date;
    }

    public static long toJavaSecs(long l) {
        if (l < -12219292800L && (l += 864000L) < -14825808000L) {
            int n = (int)((l + 14825808000L) / 3155760000L);
            --n;
            n -= n / 4;
            l += (long)n * 86400L;
        }
        return l;
    }
}

