/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core;

import com.vertica.core.VEnvironment;
import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.dsi.core.impl.DSIMessageSource;
import com.vertica.dsi.core.interfaces.IEnvironment;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.jdbc4.JDBC4ExceptionConverter;
import com.vertica.support.ILogger;
import com.vertica.support.LogLevel;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionBuilder;
import com.vertica.util.ClientErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.Properties;

public class VDriver
extends DSIDriver {
    private static final String LOG_NAME = "Vertica_driver.log";
    private static final Properties s_buildProps;
    public static final int V_COMPONENT_ID = 101;
    protected static final LogLevel DRIVER_LOG_LEVEL;
    private DSILogger m_log;
    public static final DSIMessageSource s_msgSrc;
    public static ExceptionBuilder s_vExceptionBuilder;
    public static final String SERVER_PRODUCT_NAME;
    public static final String DRIVER_VERSION;

    public VDriver() throws ErrorException {
        this.m_msgSrc.registerMessages("com.vertica.localization.messages", 101, "VJDBC");
        this.m_msgSrc.setVendorName("Vertica");
        this.setDefaultProperties();
    }

    @Override
    public IEnvironment createEnvironment() throws ErrorException {
        return new VEnvironment(this);
    }

    @Override
    public ILogger getDriverLog() {
        if (this.m_log == null) {
            this.m_log = new DSILogger(LOG_NAME);
        }
        return this.m_log;
    }

    private void setDefaultProperties() throws ErrorException {
        try {
            this.setProperty(17, new Variant(3, 0L));
            this.setProperty(21, new Variant(3, 0L));
            this.setProperty(1000, new Variant(5, (short)0));
            this.setProperty(1, new Variant(3, 0L));
            this.setProperty(2, new Variant(3, 0L));
            this.setProperty(5, new Variant(0, DRIVER_VERSION));
            this.setProperty(6, new Variant(2, Character.valueOf('\u0000')));
            this.setProperty(11, new Variant(3, 1L));
            this.setProperty(13, new Variant(3, 1L));
            this.setProperty(4, new Variant(0, "3.52"));
            this.setProperty(16, new Variant(0, "1995"));
            this.setProperty(12, new Variant(5, (short)0));
            this.setProperty(22, new Variant(3, 0L));
            this.setProperty(1005, new Variant(5, (short)0));
            this.setProperty(1004, new Variant(5, (short)1));
            this.setProperty(1003, new Variant(5, (short)0));
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new ClientErrorException(incorrectTypeException.toString());
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new ClientErrorException(numericOverflowException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block18: {
            DRIVER_LOG_LEVEL = LogLevel.OFF;
            s_msgSrc = new DSIMessageSource(true, true);
            s_vExceptionBuilder = new ExceptionBuilder(101);
            boolean bl = false;
            Properties properties = new Properties();
            InputStream inputStream = VDriver.class.getResourceAsStream("driver.properties");
            try {
                if (inputStream != null) {
                    properties.load(inputStream);
                } else {
                    bl = true;
                }
                s_msgSrc.registerMessages("com.vertica.localization.messages", 101, "VJDBC");
                s_msgSrc.setVendorName("Vertica");
            }
            catch (MissingResourceException missingResourceException) {
                System.err.println(missingResourceException.getLocalizedMessage());
                bl = true;
            }
            catch (IOException iOException) {
                System.err.println(iOException.getLocalizedMessage());
                bl = true;
            }
            finally {
                s_buildProps = properties;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException.getLocalizedMessage());
                        bl = true;
                    }
                }
                if (!bl) break block18;
                throw new RuntimeException("Error loading driver properties.");
            }
        }
        ExceptionConverter.setInstance(new JDBC4ExceptionConverter());
        SERVER_PRODUCT_NAME = s_buildProps.getProperty("server.product.name");
        DRIVER_VERSION = s_buildProps.getProperty("driver.version");
    }
}

