/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.json.JsonValue;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDatabaseException;
import oracle.jdbc.SwitchableBugFix;
import oracle.jdbc.clio.annotations.Format;
import oracle.jdbc.diagnostics.Parameter;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BINARY_DOUBLEBinder;
import oracle.jdbc.driver.BINARY_DOUBLENullBinder;
import oracle.jdbc.driver.BINARY_FLOATBinder;
import oracle.jdbc.driver.BINARY_FLOATNullBinder;
import oracle.jdbc.driver.BfileBinder;
import oracle.jdbc.driver.BfileNullBinder;
import oracle.jdbc.driver.BigDecimalBinder;
import oracle.jdbc.driver.BinaryDoubleBinder;
import oracle.jdbc.driver.BinaryDoubleNullBinder;
import oracle.jdbc.driver.BinaryFloatBinder;
import oracle.jdbc.driver.BinaryFloatNullBinder;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.BlobBinder;
import oracle.jdbc.driver.BlobNullBinder;
import oracle.jdbc.driver.BooleanBinder;
import oracle.jdbc.driver.BooleanBinder21c;
import oracle.jdbc.driver.BooleanNullBinder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ByteBinder;
import oracle.jdbc.driver.ByteCopyingBinder;
import oracle.jdbc.driver.ClobBinder;
import oracle.jdbc.driver.ClobNullBinder;
import oracle.jdbc.driver.CopiedByteBinder;
import oracle.jdbc.driver.CopiedCharBinder;
import oracle.jdbc.driver.CopiedDataBinder;
import oracle.jdbc.driver.CopiedNullBinder;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateNullBinder;
import oracle.jdbc.driver.DatumBinder;
import oracle.jdbc.driver.DefaultJsonProvider;
import oracle.jdbc.driver.DoubleBinder;
import oracle.jdbc.driver.FixedCHARBinder;
import oracle.jdbc.driver.FixedCHARCopyingBinder;
import oracle.jdbc.driver.FixedCHARNullBinder;
import oracle.jdbc.driver.FloatBinder;
import oracle.jdbc.driver.IntBinder;
import oracle.jdbc.driver.IntervalDSBinder;
import oracle.jdbc.driver.IntervalDSNullBinder;
import oracle.jdbc.driver.IntervalYMBinder;
import oracle.jdbc.driver.IntervalYMNullBinder;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.JsonBinder;
import oracle.jdbc.driver.JsonNullBinder;
import oracle.jdbc.driver.LittleEndianRowidBinder;
import oracle.jdbc.driver.LittleEndianSetCHARBinder;
import oracle.jdbc.driver.LogicalTransactionId;
import oracle.jdbc.driver.LongBinder;
import oracle.jdbc.driver.NamedTypeBinder;
import oracle.jdbc.driver.NamedTypeNullBinder;
import oracle.jdbc.driver.OracleBfile;
import oracle.jdbc.driver.OracleBlob;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClob;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleDateBinder;
import oracle.jdbc.driver.OracleNumberBinder;
import oracle.jdbc.driver.OracleParameterMetaData;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.OracleTimestampBinder;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.PlsqlRawBinder;
import oracle.jdbc.driver.RawBinder;
import oracle.jdbc.driver.RawNullBinder;
import oracle.jdbc.driver.RefCursorBinder;
import oracle.jdbc.driver.RefCursorNullBinder;
import oracle.jdbc.driver.RefTypeBinder;
import oracle.jdbc.driver.RefTypeNullBinder;
import oracle.jdbc.driver.RowidBinder;
import oracle.jdbc.driver.RowidNullBinder;
import oracle.jdbc.driver.SetCHARBinder;
import oracle.jdbc.driver.SetCHARNullBinder;
import oracle.jdbc.driver.ShortBinder;
import oracle.jdbc.driver.StringBinder;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.TSLTZBinder;
import oracle.jdbc.driver.TSLTZNullBinder;
import oracle.jdbc.driver.TSTZBinder;
import oracle.jdbc.driver.TSTZNullBinder;
import oracle.jdbc.driver.TimeBinder;
import oracle.jdbc.driver.TimestampBinder;
import oracle.jdbc.driver.TimestampNullBinder;
import oracle.jdbc.driver.TypeBinder;
import oracle.jdbc.driver.TypeCopyingBinder;
import oracle.jdbc.driver.VarcharBinder;
import oracle.jdbc.driver.VarcharCopyingBinder;
import oracle.jdbc.driver.VarcharNullBinder;
import oracle.jdbc.driver.VarnumNullBinder;
import oracle.jdbc.driver.VectorBinder;
import oracle.jdbc.driver.VectorDatumBinder;
import oracle.jdbc.driver.VectorNullBinder;
import oracle.jdbc.driver.json.binary.OsonConstants;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.ObjectData;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.jdbc.internal.OracleRef;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.internal.TTCData;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy._Proxy_;
import oracle.jdbc.spi.OsonConverter;
import oracle.sql.ANYDATA;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.BOOLEAN;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;
import oracle.sql.VECTOR;
import oracle.sql.json.OracleJsonDatum;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonValue;

abstract class OraclePreparedStatement
extends OracleStatement
implements oracle.jdbc.internal.OraclePreparedStatement {
    private static final String CLASS_NAME = OraclePreparedStatement.class.getName();
    int numberOfBindRowsAllocated;
    static Binder theStaticDBACopyingBinder = OraclePreparedStatementReadOnly.theStaticDBACopyingBinder;
    static Binder theStaticLongStreamBinder = OraclePreparedStatementReadOnly.theStaticLongStreamBinder;
    Binder theLongStreamBinder = theStaticLongStreamBinder;
    static Binder theStaticLongStreamForStringBinder = OraclePreparedStatementReadOnly.theStaticLongStreamForStringBinder;
    Binder theLongStreamForStringBinder = theStaticLongStreamForStringBinder;
    static Binder theStaticLongStreamForStringCopyingBinder = OraclePreparedStatementReadOnly.theStaticLongStreamForStringCopyingBinder;
    static Binder theStaticLongRawStreamBinder = OraclePreparedStatementReadOnly.theStaticLongRawStreamBinder;
    Binder theLongRawStreamBinder = theStaticLongRawStreamBinder;
    static Binder theStaticLongRawStreamForBytesBinder = OraclePreparedStatementReadOnly.theStaticLongRawStreamForBytesBinder;
    Binder theLongRawStreamForBytesBinder = theStaticLongRawStreamForBytesBinder;
    static Binder theStaticLongRawStreamForBytesCopyingBinder = OraclePreparedStatementReadOnly.theStaticLongRawStreamForBytesCopyingBinder;
    static Binder theStaticPlsqlIbtCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtCopyingBinder;
    static Binder theStaticPlsqlIbtBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtBinder;
    static Binder theStaticPlsqlIbtNullBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtNullBinder;
    Binder thePlsqlIbtBinder = theStaticPlsqlIbtBinder;
    Binder thePlsqlNullBinder = theStaticPlsqlIbtNullBinder;
    static Binder theStaticOutBinder = OraclePreparedStatementReadOnly.theStaticOutBinder;
    Binder theOutBinder = theStaticOutBinder;
    static Binder theStaticReturnParamBinder = OraclePreparedStatementReadOnly.theStaticReturnParamBinder;
    Binder theReturnParamBinder = theStaticReturnParamBinder;
    public static final int TypeBinder_BYTELEN = 24;
    char[] digits = new char[20];
    Binder[][] binders;
    CLOB[] lastBoundClobs;
    BLOB[] lastBoundBlobs;
    PlsqlIbtBindInfo[][] parameterPlsqlIbt;
    Binder[] currentRowBinders;
    int[] currentRowByteLens;
    int[] currentRowCharLens;
    int[] currentRowDataLengths;
    long[] currentRowDataOffsets;
    Accessor[] currentRowBindAccessors;
    short[] currentRowFormOfUse;
    boolean[] currentRowFormOfUseSet;
    boolean currentRowNeedToPrepareBinds = true;
    int[] currentBatchByteLens;
    int[] currentBatchCharLens;
    Accessor[] currentBatchBindAccessors;
    short[] currentBatchFormOfUse;
    boolean currentBatchNeedToPrepareBinds;
    long currentBatchAccumulatedBindsSize;
    private BatchFIFONode batchFIFOFront;
    private BatchFIFONode batchFIFOBack;
    private int batchQueueCounter = 0;
    int cachedBindByteSize = 0;
    int cachedBindCharSize = 0;
    int cachedBindIndicatorSize = 0;
    int totalBindByteLength;
    int totalBindCharLength;
    int totalBindIndicatorLength;
    static final int BIND_METADATA_NUMBER_OF_BIND_POSITIONS_OFFSET = 0;
    static final int BIND_METADATA_BIND_BUFFER_CAPACITY_OFFSET_HI = 1;
    static final int BIND_METADATA_BIND_BUFFER_CAPACITY_OFFSET_LO = 2;
    static final int BIND_METADATA_NUMBER_OF_BOUND_ROWS_OFFSET_HI = 3;
    static final int BIND_METADATA_NUMBER_OF_BOUND_ROWS_OFFSET_LO = 4;
    static final int BIND_METADATA_PER_POSITION_DATA_OFFSET = 5;
    static final int BIND_METADATA_TYPE_OFFSET = 0;
    static final int BIND_METADATA_BYTE_PITCH_OFFSET = 1;
    static final int BIND_METADATA_CHAR_PITCH_OFFSET = 2;
    static final int BIND_METADATA_VALUE_DATA_OFFSET_HI = 3;
    static final int BIND_METADATA_VALUE_DATA_OFFSET_LO = 4;
    static final int BIND_METADATA_NULL_INDICATORS_OFFSET_HI = 5;
    static final int BIND_METADATA_NULL_INDICATORS_OFFSET_LO = 6;
    static final int BIND_METADATA_VALUE_LENGTHS_OFFSET_HI = 7;
    static final int BIND_METADATA_VALUE_LENGTHS_OFFSET_LO = 8;
    static final int BIND_METADATA_FORM_OF_USE_OFFSET = 9;
    static final int BIND_METADATA_PER_POSITION_SIZE = 10;
    static final int PLSQL_BOOLEAN_DB_MAJOR_VERSION_SUPPORT = 12;
    static final int PLSQL_BOOLEAN_DB_MINOR_VERSION_SUPPORT = 1;
    static final int SETLOB_NO_LENGTH = -1;
    int bindBufferCapacity;
    int numberOfBoundRows;
    int indicatorsOffset;
    int valueLengthsOffset;
    boolean preparedAllBinds;
    boolean preparedByteBinds;
    boolean preparedCharBinds;
    Binder[] lastBinders;
    byte[] lastBoundBytes;
    int lastBoundByteOffset;
    char[] lastBoundChars;
    int lastBoundCharOffset;
    int[] lastBoundByteOffsets;
    int[] lastBoundCharOffsets;
    int[] lastBoundByteLens;
    int[] lastBoundCharLens;
    short[] lastBoundInds;
    short[] lastBoundLens;
    boolean lastBoundNeeded = false;
    InputStream[] lastBoundStream;
    int[] lastBoundDataLengths;
    long[] lastBoundDataOffsets;
    private static final int STREAM_MAX_BYTES_SQL = Integer.MAX_VALUE;
    int maxRawBytesSql;
    int maxRawBytesPlsql;
    int maxVcsCharsSql;
    int maxVcsNCharsSql;
    int maxVcsBytesPlsql;
    private int maxCharSize = 0;
    private int maxNCharSize = 0;
    private int charMaxCharsSql = 0;
    private int charMaxNCharsSql = 0;
    protected int maxVcsCharsPlsql = 0;
    private int maxVcsNCharsPlsql = 0;
    int maxIbtVarcharElementLength = 0;
    private int maxStreamCharsSql = 0;
    private int maxStreamNCharsSql = 0;
    protected boolean isServerCharSetFixedWidth = false;
    private boolean isServerNCharSetFixedWidth = false;
    int minVcsBindSize;
    long prematureBatchCount;
    boolean checkBindTypes = true;
    boolean scrollRsetTypeSolved;
    private static final double MIN_NUMBER = 1.0E-130;
    private static final double MAX_NUMBER = 1.0E126;
    short defaultFormOfUse = 1;
    private oracle.jdbc.internal.OracleParameterMetaData parameterMetadata;
    private static final boolean MAP_TIME_TO_TIMESTAMP = !SwitchableBugFix.isDisabled(SwitchableBugFix.BugNumber.BUG_36125634);
    int[] indicesOfNotNullLastBinds = null;
    int SetBigStringTryClob = 0;
    boolean batchUpdate = false;

    protected OraclePreparedStatement(PhysicalConnection connection, String sql, OracleResultSet.ResultSetType resultSetType, AutoKeyInfo autoKeyInfo) throws SQLException {
        super(connection, resultSetType);
        this.autoKeyInfo = autoKeyInfo;
        this.cacheState = 1;
        this.statementType = 1;
        this.needToParse = true;
        this.processEscapes = connection.processEscapes;
        try {
            this.sqlObject.initialize(sql);
            this.sqlKind = this.sqlObject.getSqlKind();
            this.clearParameters = true;
            this.scrollRsetTypeSolved = false;
            this.prematureBatchCount = 0L;
            this.initializeBinds();
        }
        catch (Exception | OutOfMemoryError e) {
            connection.removeStatement(this);
            throw e;
        }
        this.minVcsBindSize = connection.minVcsBindSize;
        this.maxRawBytesSql = connection.maxRawBytesSql;
        this.maxRawBytesPlsql = connection.maxRawBytesPlsql;
        this.maxVcsCharsSql = connection.maxVcsCharsSql;
        this.maxVcsNCharsSql = connection.maxVcsNCharsSql;
        this.maxVcsBytesPlsql = connection.maxVcsBytesPlsql;
        this.maxIbtVarcharElementLength = connection.maxIbtVarcharElementLength;
        this.maxCharSize = connection.conversion.sMaxCharSize;
        this.maxNCharSize = connection.conversion.maxNCharSize;
        this.maxVcsCharsPlsql = this.maxVcsBytesPlsql / this.maxCharSize;
        this.maxVcsNCharsPlsql = this.maxVcsBytesPlsql / this.maxNCharSize;
        this.maxStreamCharsSql = Integer.MAX_VALUE / this.maxCharSize;
        this.maxStreamNCharsSql = this.maxRawBytesSql / this.maxNCharSize;
        this.isServerCharSetFixedWidth = connection.conversion.isServerCharSetFixedWidth;
        this.isServerNCharSetFixedWidth = connection.conversion.isServerNCharSetFixedWidth;
        this.queryCacheState = connection.isResultSetCacheEnabled ? OracleStatement.QueryCacheState.UNKNOWN : OracleStatement.QueryCacheState.UNCACHEABLE;
    }

    @Override
    void createDMSSensors() throws SQLException {
        if (DMSFactory.DMSConsole.getSensorWeight() > DMSFactory.DMSConole_NORMAL) {
            String nounName = "STMT-" + OracleStatement.GLOBAL_STATEMENT_NUMBER++;
            DMSFactory dmsInstance = DMSFactory.getInstance();
            DMSFactory.DMSNoun dmsParent = dmsInstance.get(nounName);
            if (dmsParent == null) {
                dmsParent = dmsInstance.createNoun(this.connection.dmsParent, nounName, "JDBC_Statement");
                this.dmsSqlText = dmsInstance.createState(dmsParent, "SQLText", "", "current SQL text", this.connection.dmsUpdateSqlText() ? this.sqlObject.toString() : null);
                this.dmsExecute = dmsInstance.createPhaseEvent(dmsParent, "Execute", "the time required for all executions of this statement");
                this.dmsExecute.deriveMetric(DMSFactory.PhaseEventIntf_all);
                this.dmsFetch = dmsInstance.createPhaseEvent(dmsParent, "Fetch", "the time required for all fetches by this statement");
                this.dmsFetch.deriveMetric(DMSFactory.PhaseEventIntf_all);
            } else {
                this.dmsSqlText = (DMSFactory.DMSState)dmsParent.getSensor("SQLText");
                this.dmsExecute = (DMSFactory.DMSPhase)dmsParent.getSensor("Execute");
                this.dmsFetch = (DMSFactory.DMSPhase)dmsParent.getSensor("Fetch");
            }
        } else {
            super.createDMSSensors();
        }
    }

    protected void reallocBinds(int new_number_of_bind_rows_allocated) throws SQLException {
        this.allocBinds(new_number_of_bind_rows_allocated);
    }

    protected int getAllocBindsRowCount() {
        return this.numberOfBindRowsAllocated;
    }

    protected final void allocBinds(int new_number_of_bind_rows_allocated) throws SQLException {
        boolean growing = new_number_of_bind_rows_allocated > this.numberOfBindRowsAllocated;
        this.initializeIndicatorSubRange();
        int preambleSize = this.bindIndicatorSubRange + 5 + this.numberOfBindPositions * 10;
        int dataSizeTerm = new_number_of_bind_rows_allocated * this.numberOfBindPositions;
        this.bindDataOffsets = new long[dataSizeTerm];
        this.bindDataLengths = new int[dataSizeTerm];
        int indicatorSize = preambleSize + 2 * dataSizeTerm;
        if (indicatorSize > this.totalBindIndicatorLength) {
            short[] oldBindIndicators = this.bindIndicators;
            int oldBindIndicatorOffset = this.bindIndicatorOffset;
            this.bindIndicatorOffset = 0;
            this.bindIndicators = new short[indicatorSize];
            this.totalBindIndicatorLength = indicatorSize;
            if (oldBindIndicators != null && growing) {
                System.arraycopy(oldBindIndicators, oldBindIndicatorOffset, this.bindIndicators, this.bindIndicatorOffset, preambleSize);
            }
        }
        this.bindIndicatorSubRange += this.bindIndicatorOffset;
        this.bindIndicators[this.bindIndicatorSubRange + 0] = (short)this.numberOfBindPositions;
        this.indicatorsOffset = this.bindIndicatorOffset + preambleSize;
        this.valueLengthsOffset = this.indicatorsOffset + dataSizeTerm;
        int indoffset = this.indicatorsOffset;
        int lenoffset = this.valueLengthsOffset;
        int metadata_offset = this.bindIndicatorSubRange + 5;
        for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
            this.bindIndicators[metadata_offset + 5] = (short)(indoffset >> 16);
            this.bindIndicators[metadata_offset + 6] = (short)(indoffset & 0xFFFF);
            this.bindIndicators[metadata_offset + 7] = (short)(lenoffset >> 16);
            this.bindIndicators[metadata_offset + 8] = (short)(lenoffset & 0xFFFF);
            indoffset += new_number_of_bind_rows_allocated;
            lenoffset += new_number_of_bind_rows_allocated;
            metadata_offset += 10;
        }
    }

    void initializeBinds() throws SQLException {
        this.numberOfBindPositions = this.sqlObject.getParameterCount();
        this.numReturnParams = this.sqlObject.getReturnParameterCount();
        if (this.numberOfBindPositions == 0) {
            this.currentRowNeedToPrepareBinds = false;
            return;
        }
        this.numberOfBindRowsAllocated = 1;
        this.binders = new Binder[1][this.numberOfBindPositions];
        this.currentRowBinders = this.binders[0];
        this.currentRowByteLens = new int[this.numberOfBindPositions];
        this.currentBatchByteLens = new int[this.numberOfBindPositions];
        this.currentRowCharLens = new int[this.numberOfBindPositions];
        this.currentBatchCharLens = new int[this.numberOfBindPositions];
        this.currentRowDataOffsets = new long[this.numberOfBindPositions];
        this.currentRowDataLengths = new int[this.numberOfBindPositions];
        this.currentRowFormOfUse = new short[this.numberOfBindPositions];
        this.currentRowFormOfUseSet = new boolean[this.numberOfBindPositions];
        this.currentBatchFormOfUse = new short[this.numberOfBindPositions];
        this.lastBoundClobs = new CLOB[this.numberOfBindPositions];
        this.lastBoundBlobs = new BLOB[this.numberOfBindPositions];
        if (this.connection.defaultnchar) {
            this.defaultFormOfUse = (short)2;
        }
        for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
            this.currentRowFormOfUse[bindPos] = this.defaultFormOfUse;
            this.currentRowFormOfUseSet[bindPos] = false;
            this.currentBatchFormOfUse[bindPos] = this.defaultFormOfUse;
        }
        this.lastBinders = new Binder[this.numberOfBindPositions];
        this.lastBoundCharLens = new int[this.numberOfBindPositions];
        this.lastBoundByteOffsets = new int[this.numberOfBindPositions];
        this.lastBoundCharOffsets = new int[this.numberOfBindPositions];
        this.lastBoundByteLens = new int[this.numberOfBindPositions];
        this.lastBoundInds = new short[this.numberOfBindPositions];
        this.lastBoundLens = new short[this.numberOfBindPositions];
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initializeBinds", "numberOfBindPositions={0}. ", (String)null, (Throwable)null, (Object)this.numberOfBindPositions);
        this.lastBoundDataLengths = new int[this.numberOfBindPositions];
        this.lastBoundDataOffsets = new long[this.numberOfBindPositions];
        this.allocBinds(1);
    }

    void growBinds(int new_number_of_bind_rows_allocated) throws SQLException {
        int i;
        Binder[][] oldBinders = this.binders;
        this.binders = new Binder[new_number_of_bind_rows_allocated][];
        if (oldBinders != null) {
            System.arraycopy(oldBinders, 0, this.binders, 0, this.numberOfBindRowsAllocated);
        }
        for (int bindPos = this.numberOfBindRowsAllocated; bindPos < new_number_of_bind_rows_allocated; ++bindPos) {
            this.binders[bindPos] = new Binder[this.numberOfBindPositions];
        }
        this.reallocBinds(new_number_of_bind_rows_allocated);
        if (this.parameterStream != null) {
            InputStream[][] oldParameterStream = this.parameterStream;
            this.parameterStream = new InputStream[new_number_of_bind_rows_allocated][];
            System.arraycopy(oldParameterStream, 0, this.parameterStream, 0, this.numberOfBindRowsAllocated);
            for (i = this.numberOfBindRowsAllocated; i < new_number_of_bind_rows_allocated; ++i) {
                this.parameterStream[i] = new InputStream[this.numberOfBindPositions];
            }
        }
        if (this.userStream != null) {
            Object[][] oldUserStream = this.userStream;
            this.userStream = new Object[new_number_of_bind_rows_allocated][];
            System.arraycopy(oldUserStream, 0, this.userStream, 0, this.numberOfBindRowsAllocated);
            for (i = this.numberOfBindRowsAllocated; i < new_number_of_bind_rows_allocated; ++i) {
                this.userStream[i] = new Object[this.numberOfBindPositions];
            }
        }
        if (this.parameterPlsqlIbt != null) {
            PlsqlIbtBindInfo[][] oldParameterPlsqlIbt = this.parameterPlsqlIbt;
            this.parameterPlsqlIbt = new PlsqlIbtBindInfo[new_number_of_bind_rows_allocated][];
            System.arraycopy(oldParameterPlsqlIbt, 0, this.parameterPlsqlIbt, 0, this.numberOfBindRowsAllocated);
            for (i = this.numberOfBindRowsAllocated; i < new_number_of_bind_rows_allocated; ++i) {
                this.parameterPlsqlIbt[i] = new PlsqlIbtBindInfo[this.numberOfBindPositions];
            }
        }
        this.numberOfBindRowsAllocated = new_number_of_bind_rows_allocated;
        this.currentRowNeedToPrepareBinds = true;
    }

    String dumpBindData(String label) {
        return this.dumpBindData(label, 1000);
    }

    String dumpBindData(String label, int maxLength) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(label);
        long offset = 0L;
        int length = (int)this.bindData.length();
        if (length != 0 && this.bindData != null && this.bindData.length() != 0L) {
            length = Math.min(length, maxLength);
            byte[] dest = new byte[length];
            int destOffset = 0;
            if (offset >= 0L && offset + (long)length <= this.bindData.length() && destOffset >= 0 && destOffset + length <= dest.length) {
                pw.println("offset: " + offset + " length: " + length + " bindData.length(): " + this.bindData.length());
                this.bindData.get(offset, dest, destOffset, length);
                for (int k = 0; k < length; ++k) {
                    pw.println("index: " + k + " value: " + Integer.toHexString(dest[k] & 0xFF));
                }
            }
        }
        pw.println();
        pw.flush();
        return sw.toString();
    }

    void compressLastBoundData() throws SQLException {
        this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "compressLastBoundData", "{0}. ", null, null, () -> new Object[]{this.secure(this.dumpBindData("Before"))});
        if (this.bindData.length() == 0L) {
            return;
        }
        long lastOffset = -1L;
        ArrayList<Pair> binds = new ArrayList<Pair>();
        for (int i = 0; i < this.lastBoundDataLengths.length; ++i) {
            if (this.lastBoundDataLengths[i] <= 0) continue;
            binds.add(new Pair(i, this.lastBoundDataOffsets[i]));
        }
        Collections.sort(binds);
        this.bindData.setPosition(0L);
        for (Pair p : binds) {
            int indexOfLeastOffset = p.getIndex();
            long leastOffset = this.lastBoundDataOffsets[indexOfLeastOffset];
            assert (lastOffset < leastOffset) : "lastOffset: " + lastOffset + "\tleastOffset: " + leastOffset + "\tindexOfLeastOffet: " + indexOfLeastOffset;
            lastOffset = leastOffset;
            this.copyLeftOneLastBound(indexOfLeastOffset);
        }
        this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "compressLastBoundData", "{0}. ", null, null, () -> new Object[]{this.secure(this.dumpBindData("After"))});
    }

    void copyLeftOneLastBound(int bindPosition) throws SQLException {
        long oldoffset = this.lastBoundDataOffsets[bindPosition];
        this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "copyLeftOneLastBound", "{0}. ", null, null, () -> new Object[]{this.secure(this.dumpBindData("Before"))});
        long fromPos = this.lastBoundDataOffsets[bindPosition];
        long moveToPosition = this.bindData.getPosition();
        int lengthToMove = this.lastBoundDataLengths[bindPosition];
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "copyLeftOneLastBound", "bindPosition={0}, moved from={1}, to={2}, length={3}. ", (String)null, (Throwable)null, (Object)bindPosition, (Object)fromPos, (Object)moveToPosition, (Object)lengthToMove);
        byte[] tmp = this.connection.getMethodTempByteBuffer(lengthToMove);
        this.bindData.get(fromPos, tmp, 0, lengthToMove);
        this.bindData.put(moveToPosition, tmp, 0, lengthToMove);
        this.bindData.setPosition(moveToPosition + (long)lengthToMove);
        this.lastBoundDataOffsets[bindPosition] = moveToPosition;
        this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "copyLeftOneLastBound", "{0}. ", null, null, () -> new Object[]{this.secure(this.dumpBindData("After"))});
    }

    byte[] getDatumVal(Binder binder) {
        byte[] datum = null;
        if (binder instanceof TypeBinder) {
            datum = ((TypeBinder)binder).paramVal;
        } else if (binder instanceof TypeCopyingBinder) {
            datum = ((TypeCopyingBinder)binder).paramVal;
        } else if (binder instanceof DatumBinder) {
            datum = ((DatumBinder)binder).paramVal;
        }
        return datum;
    }

    void setDatumVal(Binder binder, byte[] val) {
        if (binder instanceof TypeBinder) {
            ((TypeBinder)binder).paramVal = val;
        } else if (binder instanceof TypeCopyingBinder) {
            ((TypeCopyingBinder)binder).paramVal = val;
        } else if (binder instanceof DatumBinder) {
            ((DatumBinder)binder).paramVal = val;
        }
    }

    OracleTypeADT getOtype(Binder binder) {
        OracleTypeADT otype = null;
        if (binder instanceof TypeBinder) {
            otype = ((TypeBinder)binder).paramOtype;
        } else if (binder instanceof TypeCopyingBinder) {
            otype = ((TypeCopyingBinder)binder).paramOtype;
        }
        return otype;
    }

    short getScale(Binder binder) {
        return binder.scale;
    }

    String getStringBinderVal(int bindRow, int bindPos) {
        String strVal = null;
        if (this.binders != null && this.binders[bindRow] != null && this.binders[bindRow][bindPos] != null) {
            Binder binder = this.binders[bindRow][bindPos];
            if (binder instanceof VarcharBinder) {
                strVal = ((VarcharBinder)binder).paramVal;
            } else if (binder instanceof VarcharCopyingBinder) {
                strVal = ((VarcharCopyingBinder)binder).paramVal;
            } else if (binder instanceof FixedCHARBinder) {
                strVal = ((FixedCHARBinder)binder).paramVal;
            } else if (binder instanceof FixedCHARCopyingBinder) {
                strVal = ((FixedCHARCopyingBinder)binder).paramVal;
            }
        }
        return strVal;
    }

    short getBinderType(int bindRow, int bindPos) {
        short type = 0;
        if (this.binders != null && this.binders[bindRow] != null && this.binders[bindRow][bindPos] != null) {
            type = this.binders[bindRow][bindPos].type;
        } else if (this.lastBinders != null && this.lastBinders[bindPos] != null) {
            type = this.lastBinders[bindPos].type;
        }
        return type;
    }

    short isStringBinder(int bindRow, int bindPos) {
        short stringBinder = 0;
        Binder binder = null;
        if (this.binders != null && this.binders[bindRow] != null && this.binders[bindRow][bindPos] != null) {
            binder = this.binders[bindRow][bindPos];
        } else if (this.lastBinders != null && this.lastBinders[bindPos] != null) {
            binder = this.lastBinders[bindPos];
        }
        if (binder != null && (binder instanceof VarcharBinder || binder instanceof VarcharCopyingBinder || binder instanceof FixedCHARBinder || binder instanceof FixedCHARCopyingBinder)) {
            stringBinder = 1;
        }
        return stringBinder;
    }

    short isDatumBinder(int bindRow, int bindPos) {
        short datumBinder = 0;
        Binder binder = null;
        if (this.binders != null && this.binders[bindRow] != null && this.binders[bindRow][bindPos] != null) {
            binder = this.binders[bindRow][bindPos];
        } else if (this.lastBinders != null && this.lastBinders[bindPos] != null) {
            binder = this.lastBinders[bindPos];
        }
        if (binder != null && (binder instanceof TypeBinder || binder instanceof TypeCopyingBinder || binder instanceof DatumBinder)) {
            datumBinder = 1;
        }
        return datumBinder;
    }

    void setStringBinderVal(int bindRow, int bindPos, String strVal) {
        if (this.binders != null && this.binders[bindRow] != null && this.binders[bindRow][bindPos] != null) {
            Binder binder = this.binders[bindRow][bindPos];
            if (binder instanceof VarcharBinder) {
                ((VarcharBinder)binder).paramVal = strVal;
            } else if (binder instanceof VarcharCopyingBinder) {
                ((VarcharCopyingBinder)binder).paramVal = strVal;
            } else if (binder instanceof FixedCHARBinder) {
                ((FixedCHARBinder)binder).paramVal = strVal;
            } else if (binder instanceof FixedCHARCopyingBinder) {
                ((FixedCHARCopyingBinder)binder).paramVal = strVal;
            }
        }
    }

    byte[] getDatumBinderVal(int bindRow, int bindPos) {
        byte[] datum = null;
        if (this.binders != null && this.binders[bindRow] != null && this.binders[bindRow][bindPos] != null) {
            Binder binder = this.binders[bindRow][bindPos];
            datum = this.getDatumVal(binder);
        }
        return datum;
    }

    void setDatumBinderVal(int bindRow, int bindPos, byte[] val) {
        if (this.binders != null && this.binders[bindRow] != null && this.binders[bindRow][bindPos] != null) {
            Binder binder = this.binders[bindRow][bindPos];
            this.setDatumVal(binder, val);
        }
    }

    OracleTypeADT getDatumBinderOtype(int bindRow, int bindPos) {
        OracleTypeADT otype = null;
        if (this.binders != null && this.binders[bindRow] != null && this.binders[bindRow][bindPos] != null) {
            Binder binder = this.binders[bindRow][bindPos];
            otype = this.getOtype(binder);
        }
        return otype;
    }

    void processCompletedBindRow(int number_of_rows_in_batch, boolean batchForPlsql) throws SQLException {
        int nextRank;
        int datalen;
        int bindPos;
        int bindPos2;
        Binder[] prevBinders;
        if (this.numberOfBindPositions == 0) {
            return;
        }
        boolean bindTypeChange = false;
        boolean nullBinderFound = false;
        boolean bindTypeConflict = false;
        boolean isFirstRowInBatch = this.currentRank == this.firstRowInBatch;
        short inOutBinderTypeConflict = 0;
        int inOutAccessorTypeConflict = 0;
        Binder[] binderArray = this.currentRank == 0 ? (this.lastBinders[0] == null ? null : this.lastBinders) : (prevBinders = this.binders[this.currentRank - 1]);
        if (this.currentRowBindAccessors == null) {
            Binder binder;
            boolean requireAutoKeyRegistration;
            boolean bl = requireAutoKeyRegistration = this.autoKeyInfo != null && this.clearParameters;
            if (prevBinders == null) {
                for (bindPos2 = 0; bindPos2 < this.numberOfBindPositions; ++bindPos2) {
                    if (this.currentRowBinders[bindPos2] != null) continue;
                    if (requireAutoKeyRegistration) {
                        this.setAutoKeyBinders();
                        requireAutoKeyRegistration = false;
                        if (this.currentRowBinders[bindPos2] != null) continue;
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 41, String.valueOf(bindPos2 + 1)).fillInStackTrace();
                }
            } else if (this.checkBindTypes) {
                for (bindPos2 = 0; bindPos2 < this.numberOfBindPositions; ++bindPos2) {
                    if (this.currentRowBinders[bindPos2] == null && requireAutoKeyRegistration) {
                        this.setAutoKeyBinders();
                        requireAutoKeyRegistration = false;
                    }
                    if ((binder = this.currentRowBinders[bindPos2]) == null) {
                        if (this.clearParameters) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 41, (Object)(bindPos2 + 1)).fillInStackTrace();
                        }
                        this.currentRowBinders[bindPos2] = prevBinders[bindPos2].copyingBinder();
                        if (this.currentRowBinders[bindPos2].type != prevBinders[bindPos2].type) {
                            bindTypeChange = true;
                        }
                        if (this.currentRank == 0) {
                            this.currentRowBinders[bindPos2].lastBoundValueCleanup(this, bindPos2);
                        }
                        this.currentRowByteLens[bindPos2] = -1;
                        this.currentRowCharLens[bindPos2] = -1;
                        this.currentRowDataLengths[bindPos2] = -1;
                        nullBinderFound = true;
                    } else {
                        short type = binder.type;
                        if ((type == 109 || type == 111) && prevBinders[bindPos2] != null && !this.getOtype(binder).isInHierarchyOf(this.getOtype(prevBinders[bindPos2])) || prevBinders[bindPos2] != null && (type != prevBinders[bindPos2].type || type == 9 && binder.bytelen == 0 != (prevBinders[bindPos2].bytelen == 0))) {
                            bindTypeChange = true;
                        }
                    }
                    if (this.currentBatchFormOfUse[bindPos2] == this.currentRowFormOfUse[bindPos2]) continue;
                    bindTypeChange = true;
                }
            } else {
                for (bindPos2 = 0; bindPos2 < this.numberOfBindPositions; ++bindPos2) {
                    binder = this.currentRowBinders[bindPos2];
                    if (binder != null) continue;
                    if (this.clearParameters) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 41, (Object)(bindPos2 + 1)).fillInStackTrace();
                    }
                    this.currentRowBinders[bindPos2] = prevBinders[bindPos2].copyingBinder();
                    if (this.currentRowBinders[bindPos2].type != prevBinders[bindPos2].type) {
                        bindTypeChange = true;
                    }
                    if (this.currentRank == 0) {
                        this.currentRowBinders[bindPos2].lastBoundValueCleanup(this, bindPos2);
                    }
                    this.currentRowByteLens[bindPos2] = -1;
                    this.currentRowCharLens[bindPos2] = -1;
                    this.currentRowDataLengths[bindPos2] = -1;
                    nullBinderFound = true;
                }
            }
            if (nullBinderFound && (isFirstRowInBatch || this.batchUpdate)) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "processCompletedBindRow", "lastBoundNeeded=true (point 1). ", null, null);
                this.lastBoundNeeded = true;
            }
        } else {
            Accessor accessor;
            Binder binder;
            if (prevBinders == null) {
                for (bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                    binder = this.currentRowBinders[bindPos];
                    accessor = this.currentRowBindAccessors[bindPos];
                    if (binder == null) {
                        if (accessor == null) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 41, (Object)(bindPos + 1)).fillInStackTrace();
                        }
                        this.currentRowBinders[bindPos] = this.theOutBinder;
                        continue;
                    }
                    if (accessor == null || this.isDefineTypeCompatibleWithBindType(accessor.defineType, binder.type)) continue;
                    bindTypeConflict = true;
                    inOutBinderTypeConflict = binder.type;
                    inOutAccessorTypeConflict = accessor.defineType;
                }
            } else if (this.checkBindTypes) {
                for (bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                    binder = this.currentRowBinders[bindPos];
                    accessor = this.currentRowBindAccessors[bindPos];
                    if (binder == null) {
                        if (accessor != null) {
                            this.currentRowBinders[bindPos] = binder = this.theOutBinder;
                            if (prevBinders[bindPos] != this.theOutBinder) {
                                bindTypeChange = true;
                            }
                        } else {
                            if (this.clearParameters && prevBinders[bindPos] != this.theOutBinder) {
                                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 41, (Object)(bindPos + 1)).fillInStackTrace();
                            }
                            this.currentRowBinders[bindPos] = binder = prevBinders[bindPos];
                            this.currentRowByteLens[bindPos] = -1;
                            this.currentRowCharLens[bindPos] = -1;
                            this.currentRowDataLengths[bindPos] = -1;
                            if (binder != this.theOutBinder) {
                                nullBinderFound = true;
                            }
                        }
                    } else {
                        short type = binder.type;
                        if ((type == 109 || type == 111) && prevBinders[bindPos] != null && !this.getOtype(binder).isInHierarchyOf(this.getOtype(prevBinders[bindPos])) || prevBinders[bindPos] != null && (type != prevBinders[bindPos].type || type == 9 && binder.bytelen == 0 != (prevBinders[bindPos].bytelen == 0))) {
                            bindTypeChange = true;
                        }
                    }
                    if (this.currentBatchFormOfUse[bindPos] != this.currentRowFormOfUse[bindPos]) {
                        bindTypeChange = true;
                    }
                    Accessor lastAccessor = null;
                    if (this.currentBatchBindAccessors != null) {
                        lastAccessor = this.currentBatchBindAccessors[bindPos];
                    }
                    if (accessor == null) {
                        this.currentRowBindAccessors[bindPos] = accessor = lastAccessor;
                    } else if (lastAccessor != null && accessor.defineType != lastAccessor.defineType) {
                        bindTypeChange = true;
                    }
                    if (accessor == null || binder == this.theOutBinder || accessor.defineType == binder.type || this.connection.permitTimestampDateMismatch && binder.type == 180 && accessor.defineType == 12 || binder.type == 252 && accessor.defineType == 6) continue;
                    bindTypeConflict = true;
                    inOutBinderTypeConflict = binder.type;
                    inOutAccessorTypeConflict = accessor.defineType;
                }
            } else {
                for (bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                    binder = this.currentRowBinders[bindPos];
                    if (binder == null) {
                        if (this.clearParameters && prevBinders[bindPos] != this.theOutBinder) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 41, (Object)(bindPos + 1)).fillInStackTrace();
                        }
                        this.currentRowBinders[bindPos] = binder = prevBinders[bindPos];
                        this.currentRowByteLens[bindPos] = -1;
                        this.currentRowCharLens[bindPos] = -1;
                        this.currentRowDataLengths[bindPos] = -1;
                        if (binder != this.theOutBinder) {
                            nullBinderFound = true;
                        }
                    }
                    if (this.currentRowBindAccessors[bindPos] != null) continue;
                    this.currentRowBindAccessors[bindPos] = this.currentBatchBindAccessors[bindPos];
                }
            }
            if (nullBinderFound && isFirstRowInBatch) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "processCompletedBindRow", "lastBoundNeeded=true (point 2). ", null, null);
                this.lastBoundNeeded = true;
            }
        }
        if (bindTypeChange) {
            if (!isFirstRowInBatch) {
                this.enqueueCurrentBatch(false);
            }
            this.onBindTypeChange();
            this.currentRowNeedToPrepareBinds = true;
            this.needToPrepareDefineBuffer = true;
        } else if (batchForPlsql) {
            this.enqueueCurrentBatch(false);
            this.needToParse = false;
            this.currentBatchNeedToPrepareBinds = false;
        }
        if (this.connection.maxBatchMemory != 0L && this.currentBatchAccumulatedBindsSize > this.connection.maxBatchMemory && this.currentRank > this.firstRowInBatch) {
            this.enqueueCurrentBatch(false);
            this.needToParse = false;
        }
        for (bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
            int bytelen;
            int charlen = this.currentRowCharLens[bindPos];
            if (charlen == -1 && this.currentRank == this.firstRowInBatch) {
                charlen = this.lastBoundCharLens[bindPos];
            }
            if ((bytelen = this.currentRowByteLens[bindPos]) == -1 && this.currentRank == this.firstRowInBatch) {
                bytelen = this.lastBoundByteLens[bindPos];
            }
            if ((datalen = this.currentRowDataLengths[bindPos]) == -1 && this.currentRank == this.firstRowInBatch) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "processCompletedBindRow", "(point 1) lastBoundDataLengths[bindPos]={0}. ", (String)null, (Throwable)null, (Object)this.lastBoundDataLengths[bindPos]);
                datalen = this.lastBoundDataLengths[bindPos];
            }
            this.currentBatchAccumulatedBindsSize += (long)(charlen + bytelen + datalen);
        }
        if (bindTypeConflict) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, null, null, " (input type=" + inOutBinderTypeConflict + " output type=" + inOutAccessorTypeConflict + ")").fillInStackTrace();
        }
        for (bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
            int charlen;
            int bytelen = this.currentRowByteLens[bindPos];
            if (bytelen == -1 && this.currentRank == this.firstRowInBatch) {
                bytelen = this.lastBoundByteLens[bindPos];
            }
            if (this.currentBatchByteLens[bindPos] < bytelen) {
                this.currentBatchByteLens[bindPos] = bytelen;
            }
            if ((charlen = this.currentRowCharLens[bindPos]) == -1 && this.currentRank == this.firstRowInBatch) {
                charlen = this.lastBoundCharLens[bindPos];
            }
            if (this.currentBatchCharLens[bindPos] < charlen) {
                this.currentBatchCharLens[bindPos] = charlen;
            }
            if ((datalen = this.currentRowDataLengths[bindPos]) == -1 && this.currentRank == this.firstRowInBatch) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "processCompletedBindRow", "(point 2) lastBoundDataLengths[bindPos]={0}. ", (String)null, (Throwable)null, (Object)this.lastBoundDataLengths[bindPos]);
                datalen = this.lastBoundDataLengths[bindPos];
            }
            this.currentRowByteLens[bindPos] = 0;
            this.currentRowCharLens[bindPos] = 0;
            this.currentRowDataLengths[bindPos] = 0;
            this.currentBatchFormOfUse[bindPos] = this.currentRowFormOfUse[bindPos];
        }
        if (this.currentRowNeedToPrepareBinds) {
            this.currentBatchNeedToPrepareBinds = true;
        }
        if (this.currentRowBindAccessors != null) {
            Accessor[] tmp = this.currentBatchBindAccessors;
            this.currentBatchBindAccessors = this.currentRowBindAccessors;
            if (tmp == null) {
                tmp = new Accessor[this.numberOfBindPositions];
            } else {
                for (bindPos2 = 0; bindPos2 < this.numberOfBindPositions; ++bindPos2) {
                    tmp[bindPos2] = null;
                }
            }
            this.currentRowBindAccessors = tmp;
        }
        if ((nextRank = this.currentRank + 1) < number_of_rows_in_batch) {
            if (nextRank >= this.numberOfBindRowsAllocated) {
                int new_number_of_bind_rows_allocated = this.numberOfBindRowsAllocated << 1;
                if (new_number_of_bind_rows_allocated <= nextRank) {
                    new_number_of_bind_rows_allocated = nextRank + 1;
                }
                this.growBinds(new_number_of_bind_rows_allocated);
                this.currentBatchNeedToPrepareBinds = true;
                if (this.batchFIFOFront != null) {
                    this.batchFIFOFront.current_batch_need_to_prepare_binds = true;
                }
            }
            this.currentRowBinders = this.binders[nextRank];
        }
        this.currentRowNeedToPrepareBinds = false;
        this.clearParameters = false;
    }

    private void setAutoKeyBinders() {
        if (this.autoKeyInfo == null) {
            return;
        }
        int parameterCount = this.autoKeyInfo.returnParameterCount();
        for (int i = 0; i < parameterCount; ++i) {
            this.currentRowBinders[i + (this.numberOfBindPositions - parameterCount)] = this.theReturnParamBinder;
        }
    }

    private boolean isDefineTypeCompatibleWithBindType(int defineType, int bindType) {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "isDefineTypeCompatibleWithBindType", "defineType={0}, bindType={1}. ", (String)null, (Throwable)null, (Object)defineType, (Object)bindType);
        boolean retValue = false;
        if (defineType == bindType) {
            retValue = true;
        } else if (this.connection.permitTimestampDateMismatch && bindType == 180 && defineType == 12) {
            retValue = true;
        } else if (bindType == 252 && defineType == 6) {
            retValue = true;
        } else if (bindType == 96 && defineType == 9) {
            retValue = true;
        }
        return retValue;
    }

    void processPlsqlIndexTabBinds(int cur_row_to_be_bound) throws SQLException {
        int num_plsql_index_tab_binds = 0;
        int total_elements = 0;
        int bytes = 0;
        int chars = 0;
        Binder[] curRowBinders = this.binders[cur_row_to_be_bound];
        PlsqlIbtBindInfo[] inBindInfos = this.parameterPlsqlIbt == null ? null : this.parameterPlsqlIbt[cur_row_to_be_bound];
        for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
            PlsqlIbtBindInfo outBindInfo;
            Binder binder = curRowBinders[bindPos];
            Accessor accessor = this.currentBatchBindAccessors == null ? null : this.currentBatchBindAccessors[bindPos];
            PlsqlIbtBindInfo useBindInfo = outBindInfo = accessor == null ? null : accessor.plsqlIndexTableBindInfo();
            if (binder.type == 998) {
                useBindInfo = inBindInfos[bindPos];
                if (outBindInfo != null) {
                    if (useBindInfo.element_internal_type != outBindInfo.element_internal_type) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12).fillInStackTrace();
                    }
                    if (useBindInfo.maxLen < outBindInfo.maxLen) {
                        useBindInfo.maxLen = outBindInfo.maxLen;
                    }
                    if (useBindInfo.elemMaxLen < outBindInfo.elemMaxLen) {
                        useBindInfo.elemMaxLen = outBindInfo.elemMaxLen;
                    }
                    if (useBindInfo.ibtByteLength > 0) {
                        useBindInfo.ibtByteLength = useBindInfo.elemMaxLen * useBindInfo.maxLen;
                    } else {
                        useBindInfo.ibtCharLength = useBindInfo.elemMaxLen * useBindInfo.maxLen;
                    }
                }
            }
            if (useBindInfo == null) continue;
            ++num_plsql_index_tab_binds;
            bytes += useBindInfo.ibtByteLength;
            chars += useBindInfo.ibtCharLength;
            total_elements += useBindInfo.maxLen;
        }
        if (num_plsql_index_tab_binds == 0) {
            return;
        }
        this.ibtBindIndicatorSize = 6 + num_plsql_index_tab_binds * 8 + total_elements * 2;
        if (this.ibtBindIndicators == null || this.ibtBindIndicators.length < this.ibtBindIndicatorSize) {
            this.ibtBindIndicators = new short[this.ibtBindIndicatorSize];
        }
        this.ibtBindIndicatorOffset = 0;
        if (bytes > 0 && (this.ibtBindBytes == null || this.ibtBindBytes.length < bytes)) {
            this.ibtBindBytes = new byte[bytes];
        }
        this.ibtBindByteOffset = 0;
        if (chars > 0 && (this.ibtBindChars == null || this.ibtBindChars.length < chars)) {
            this.ibtBindChars = new char[chars];
        }
        this.ibtBindCharOffset = 0;
        int byteOffset = this.ibtBindByteOffset;
        int charOffset = this.ibtBindCharOffset;
        int indOffset = this.ibtBindIndicatorOffset;
        int offset = indOffset + 6 + num_plsql_index_tab_binds * 8;
        this.ibtBindIndicators[indOffset++] = (short)(num_plsql_index_tab_binds >> 16);
        this.ibtBindIndicators[indOffset++] = (short)(num_plsql_index_tab_binds & 0xFFFF);
        this.ibtBindIndicators[indOffset++] = (short)(bytes >> 16);
        this.ibtBindIndicators[indOffset++] = (short)(bytes & 0xFFFF);
        this.ibtBindIndicators[indOffset++] = (short)(chars >> 16);
        this.ibtBindIndicators[indOffset++] = (short)(chars & 0xFFFF);
        for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
            int byteOrCharOffset;
            PlsqlIbtBindInfo outBindInfo;
            Binder binder = curRowBinders[bindPos];
            Accessor accessor = this.currentBatchBindAccessors == null ? null : this.currentBatchBindAccessors[bindPos];
            PlsqlIbtBindInfo useBindInfo = outBindInfo = accessor == null ? null : accessor.plsqlIndexTableBindInfo();
            if (binder.type == 998) {
                useBindInfo = inBindInfos[bindPos];
            }
            if (useBindInfo == null) continue;
            int maxlen = useBindInfo.maxLen;
            this.ibtBindIndicators[indOffset++] = (short)useBindInfo.element_internal_type;
            this.ibtBindIndicators[indOffset++] = (short)useBindInfo.elemMaxLen;
            this.ibtBindIndicators[indOffset++] = (short)(maxlen >> 16);
            this.ibtBindIndicators[indOffset++] = (short)(maxlen & 0xFFFF);
            this.ibtBindIndicators[indOffset++] = (short)(useBindInfo.curLen >> 16);
            this.ibtBindIndicators[indOffset++] = (short)(useBindInfo.curLen & 0xFFFF);
            if (useBindInfo.ibtByteLength > 0) {
                byteOrCharOffset = byteOffset;
                byteOffset += useBindInfo.ibtByteLength;
            } else {
                byteOrCharOffset = charOffset;
                charOffset += useBindInfo.ibtCharLength;
            }
            this.ibtBindIndicators[indOffset++] = (short)(byteOrCharOffset >> 16);
            this.ibtBindIndicators[indOffset++] = (short)(byteOrCharOffset & 0xFFFF);
            useBindInfo.ibtValueIndex = byteOrCharOffset;
            useBindInfo.ibtIndicatorIndex = offset;
            useBindInfo.ibtLengthIndex = offset + maxlen;
            if (outBindInfo != null) {
                if (outBindInfo != useBindInfo) {
                    outBindInfo.ibtIndicatorIndex = useBindInfo.ibtIndicatorIndex;
                    outBindInfo.ibtLengthIndex = useBindInfo.ibtLengthIndex;
                    outBindInfo.ibtValueIndex = byteOrCharOffset;
                }
                this.initializePlsqlIndexByTableAccessor(accessor, indOffset);
            }
            offset += 2 * maxlen;
        }
    }

    void initializePlsqlIndexByTableAccessor(Accessor accessor, int indOffset) {
    }

    void initializeBindSubRanges(int number_of_rows_to_be_bound, int number_of_rows_to_be_set_up) {
        this.bindByteSubRange = 0;
        this.bindCharSubRange = 0;
    }

    int calculateIndicatorSubRangeSize() {
        return 0;
    }

    short getInoutIndicator(int bindPosition) {
        return 0;
    }

    @Override
    void initializeIndicatorSubRange() {
        this.bindIndicatorSubRange = this.calculateIndicatorSubRangeSize();
    }

    void prepareBindPreambles(int number_of_rows_to_be_bound, int number_of_rows_to_be_set_up) {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "prepareBindPreambles", "do nothing. ", null, null);
    }

    protected void configureBindData() throws SQLException {
    }

    void setupBindBuffers(int first_row_to_be_bound, int number_of_rows_to_be_bound) throws SQLException {
        assert (this.bindUseDBA) : "bindUseDBA is false for T4C driver.";
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "setupBindBuffers", "first_row_to_be_bound={0}, number_of_rows_to_be_bound={1}, lastBoundNeeded={2}. ", (String)null, (Throwable)null, (Object)first_row_to_be_bound, (Object)number_of_rows_to_be_bound, (Object)this.lastBoundNeeded);
        if (this.lastBoundNeeded) {
            this.compressLastBoundData();
        } else {
            if (this.lastBoundDataLengths != null) {
                for (int i = 0; i < this.lastBoundDataLengths.length; ++i) {
                    this.lastBoundDataLengths[i] = 0;
                    this.lastBoundDataOffsets[i] = -1L;
                }
            }
            this.bindData.reset();
        }
        if (this.bindIndicators == null) {
            this.reallocBinds(number_of_rows_to_be_bound);
        }
        try {
            if (this.numberOfBindPositions == 0) {
                if (number_of_rows_to_be_bound != 0) {
                    this.setNumberOfBoundRows(number_of_rows_to_be_bound);
                }
                return;
            }
            this.currentBatchNeedToPrepareBinds = false;
            this.setNumberOfBoundRows(number_of_rows_to_be_bound);
            int number_of_rows_to_be_set_up = this.numberOfBoundRows;
            this.setupOutBindAccessors();
            int per_position_metadata_offset = this.bindIndicatorSubRange + 5;
            this.setupBindMetaData(first_row_to_be_bound, per_position_metadata_offset);
            this.initializeBindSubRanges(this.numberOfBoundRows, number_of_rows_to_be_set_up);
            if (this.hasIbtBind) {
                this.processPlsqlIndexTabBinds(first_row_to_be_bound);
            }
            if (this.numReturnParams > 0) {
                this.requireDmlReturningRegistration();
                this.processDmlReturningBind();
            }
            this.localCheckSum = this.checkSum;
            this.doBindValueConversion(first_row_to_be_bound);
            this.checkSum = this.localCheckSum;
            this.localCheckSum = 0L;
        }
        catch (NullPointerException e) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, null, (Throwable)e).fillInStackTrace();
        }
    }

    @Override
    protected void convertBindRow(int index) throws SQLException {
        int bindersOffset = this.firstRowInBatch + index;
        if (this.binders == null || this.binders[bindersOffset][0] == null) {
            return;
        }
        this.compactCopiedBindData(bindersOffset);
        this.doBindValueConversion(bindersOffset, 1);
    }

    private void compactCopiedBindData(int bindersOffset) throws SQLException {
        if (!this.bindUseDBA) {
            return;
        }
        if (bindersOffset == 0) {
            return;
        }
        Binder[] binderRow = this.binders[bindersOffset];
        class BindCopy
        implements Comparable<BindCopy> {
            final int bindPosition;
            final long offset;

            BindCopy(int bindPosition, long offset) {
                this.bindPosition = bindPosition;
                this.offset = offset;
            }

            @Override
            public int compareTo(BindCopy binderCopy) {
                return Long.compare(this.offset, binderCopy.offset);
            }
        }
        TreeSet<BindCopy> bindCopies = null;
        for (int i = 0; i < binderRow.length; ++i) {
            if (!binderRow[i].isCopying()) continue;
            if (bindCopies == null) {
                bindCopies = new TreeSet<BindCopy>();
            }
            bindCopies.add(new BindCopy(i, this.lastBoundDataOffsets[i]));
        }
        this.bindData.setPosition(0L);
        if (bindCopies == null) {
            return;
        }
        long copyOffset = ((BindCopy)bindCopies.first()).offset;
        int copyLength = 0;
        for (BindCopy bindCopy : bindCopies) {
            long newOffset;
            this.bindDataOffsets[bindCopy.bindPosition] = newOffset = this.bindData.getPosition() + (long)copyLength;
            this.lastBoundDataOffsets[bindCopy.bindPosition] = newOffset;
            if (bindCopy.offset == copyOffset + (long)copyLength) {
                copyLength += this.lastBoundDataLengths[bindCopy.bindPosition];
                continue;
            }
            this.bindData.copyLeft(copyOffset, copyLength);
            copyOffset = bindCopy.offset;
            copyLength = this.lastBoundDataLengths[bindCopy.bindPosition];
        }
        this.bindData.copyLeft(copyOffset, copyLength);
    }

    private void setNumberOfBoundRows(int number_of_rows_to_be_bound) {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "setNumberOfBoundRows", "number_of_rows_to_be_bound={0}. ", (String)null, (Throwable)null, (Object)number_of_rows_to_be_bound);
        this.numberOfBoundRows = number_of_rows_to_be_bound;
        this.bindIndicators[this.bindIndicatorSubRange + 3] = (short)((this.numberOfBoundRows & 0xFFFF0000) >> 16);
        this.bindIndicators[this.bindIndicatorSubRange + 4] = (short)(this.numberOfBoundRows & 0xFFFF);
    }

    private void setupOutBindAccessors() throws SQLException {
        if (this.currentBatchBindAccessors != null) {
            if (this.outBindAccessors == null) {
                this.outBindAccessors = new Accessor[this.numberOfBindPositions];
            }
            for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                Accessor accessor;
                this.outBindAccessors[bindPos] = accessor = this.currentBatchBindAccessors[bindPos];
                if (accessor == null) continue;
                int bytelen = accessor.byteLength;
                int charlen = accessor.charLength;
                if (this.currentBatchByteLens[bindPos] < bytelen) {
                    this.currentBatchByteLens[bindPos] = bytelen;
                }
                if (charlen != 0 && this.currentBatchCharLens[bindPos] >= charlen) continue;
                this.currentBatchCharLens[bindPos] = charlen;
            }
        }
    }

    private int setupBindMetaData(int first_row_to_be_bound, int metadata_offset) throws SQLException {
        Binder[] firstRankBinders = this.binders[first_row_to_be_bound];
        for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
            short type;
            Binder binder = firstRankBinders[bindPos];
            int bytelen = this.currentBatchByteLens[bindPos];
            int charlen = this.currentBatchCharLens[bindPos];
            if (binder == this.theOutBinder) {
                if (this.currentBatchBindAccessors != null) {
                    Accessor accessor = this.currentBatchBindAccessors[bindPos];
                    type = (short)accessor.defineType;
                } else {
                    type = binder.type;
                }
            } else {
                type = binder.type;
            }
            this.bindIndicators[metadata_offset + 0] = type;
            this.bindIndicators[metadata_offset + 1] = (short)bytelen;
            this.bindIndicators[metadata_offset + 2] = (short)charlen;
            this.bindIndicators[metadata_offset + 9] = this.currentBatchFormOfUse[bindPos];
            metadata_offset += 10;
        }
        return metadata_offset;
    }

    protected final void requireDmlReturningRegistration() throws SQLException {
        if (this.numReturnParams == 0 || this.autoKeyInfo != null) {
            return;
        }
        if (this.accessors == null || this.accessors.length < this.numReturnParams) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 173).fillInStackTrace();
        }
    }

    protected void doBindValueConversion(int bindersOffset) throws SQLException {
        this.doBindValueConversion(bindersOffset, this.numberOfBoundRows);
    }

    protected final void doBindValueConversion(int bindersOffset, int rowCount) throws SQLException {
        int indoffset = this.indicatorsOffset;
        int lenoffset = this.valueLengthsOffset;
        int lastrow_in_buffers = rowCount - 1;
        int lastrow_in_binders = lastrow_in_buffers + bindersOffset;
        Binder[] lastRowBinders = this.binders[lastrow_in_binders];
        boolean clearPriorBindValues = !this.sqlKind.isPlsqlOrCall() || this.currentRowBindAccessors == null;
        int indicatorRowCount = this.getAllocBindsRowCount();
        for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
            short formOfUse = this.currentBatchFormOfUse[bindPos];
            this.lastBinders[bindPos] = lastRowBinders[bindPos];
            this.lastBoundByteLens[bindPos] = this.currentBatchByteLens[bindPos];
            for (int rowInBuffers = 0; rowInBuffers < rowCount; ++rowInBuffers) {
                int rowInBinders = bindersOffset + rowInBuffers;
                int bindDataIndex = rowInBuffers * this.numberOfBindPositions + bindPos;
                if (this.isLoggable(Level.FINEST)) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doBindValueConversion", "rowInBinders={0}, bindPos={1}, binders[rowInBinders][bindPos]={2}. ", (String)null, (Throwable)null, (Object)rowInBinders, (Object)bindPos, (Object)this.binders[rowInBinders][bindPos].getClass().getName());
                }
                this.localCheckSum = this.binders[rowInBinders][bindPos].bind(this, bindPos, rowInBinders - this.firstRowInBatch, rowInBinders, this.bindBytes, this.bindChars, this.bindIndicators, 0, 0, 0, 0, lenoffset + rowInBuffers, indoffset + rowInBuffers, clearPriorBindValues, this.localCheckSum, this.bindData, this.bindDataOffsets, this.bindDataLengths, bindDataIndex, this.bindUseDBA, formOfUse);
                this.binders[rowInBinders][bindPos] = null;
                if (this.userStream == null) continue;
                this.userStream[rowInBinders][bindPos] = null;
            }
            if (this.bindChecksumListener != null) {
                boolean contFlag = this.bindChecksumListener.shouldContinue(this.checkSum);
                this.bindChecksumListener = null;
                if (!contFlag) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 290).fillInStackTrace();
                }
            }
            this.lastBoundInds[bindPos] = this.bindIndicators[indoffset + lastrow_in_buffers];
            this.lastBoundLens[bindPos] = this.bindIndicators[lenoffset + lastrow_in_buffers];
            this.lastBoundByteLens[bindPos] = 0;
            this.lastBoundCharLens[bindPos] = 0;
            indoffset += indicatorRowCount;
            lenoffset += indicatorRowCount;
        }
        int nextBindersOffset = bindersOffset + rowCount;
        if (nextBindersOffset == this.numberOfBoundRows) {
            this.setLastBoundVals(nextBindersOffset - 1);
        }
    }

    private void setLastBoundVals(int lastBindersOffset) {
        this.lastBoundBytes = this.bindBytes;
        this.lastBoundByteOffset = this.bindByteOffset;
        this.lastBoundChars = this.bindChars;
        this.lastBoundCharOffset = this.bindCharOffset;
        if (this.parameterStream != null) {
            this.lastBoundStream = this.parameterStream[lastBindersOffset];
        }
        int[] tmpByteLens = this.currentBatchByteLens;
        this.currentBatchByteLens = this.lastBoundByteLens;
        this.lastBoundByteLens = tmpByteLens;
        int[] tmpCharLens = this.currentBatchCharLens;
        this.currentBatchCharLens = this.lastBoundCharLens;
        this.lastBoundCharLens = tmpCharLens;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "setLastBoundVals", "lastBoundNeeded=false (point 4). ", null, null);
        this.lastBoundNeeded = false;
    }

    void onBindTypeChange() {
    }

    @Override
    void releaseBuffers() {
        this.releaseBuffers(true);
    }

    private void releaseBuffers(boolean cache) {
        super.releaseBuffers();
        this.parameterStream = null;
        if (cache) {
            this.connection.cacheBuffer(this.bindBytes);
        }
        this.bindBytes = null;
        this.totalBindByteLength = 0;
        if (cache) {
            this.connection.cacheBuffer(this.bindChars);
        }
        this.bindChars = null;
        this.totalBindCharLength = 0;
        this.bindIndicators = null;
        this.totalBindIndicatorLength = 0;
        this.bindBufferCapacity = 0;
        this.numberOfBindRowsAllocated = 1;
        this.lastBoundStream = null;
        this.userStream = null;
        try {
            this.clearParametersCritical();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void enterImplicitCache() throws SQLException {
        this.alwaysOnClose();
        if (!this.connection.isClosed()) {
            this.cleanAllTempLobs();
        }
        if (this.connection.clearStatementMetaData) {
            this.lastBoundBytes = null;
            this.lastBoundChars = null;
        }
        this.cacheState = 2;
        this.creationState = 1;
        this.currentResultSet = null;
        this.lastIndex = 0;
        this.queryTimeout = 0;
        this.rowPrefetchChanged = false;
        this.currentRank = 0;
        this.currentBatchAccumulatedBindsSize = 0L;
        this.validRows = 0L;
        this.maxRows = 0L;
        this.maxFieldSize = 0;
        this.gotLastBatch = false;
        this.clearParameters = true;
        this.defaultTimeZone = null;
        this.defaultCalendar = null;
        this.checkSum = 0L;
        this.checkSumComputationFailure = false;
        this.setContinueOnErrorSet(null);
        if (this.sqlKind.isOTHER()) {
            this.needToParse = true;
            this.needToPrepareDefineBuffer = true;
            this.columnsDefinedByUser = false;
        }
        this.releaseBuffers();
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
        if (this.accessors != null) {
            int len = this.accessors.length;
            for (int i = 0; i < len; ++i) {
                if (this.accessors[i] == null) continue;
                this.accessors[i].rowSpaceIndicator = null;
                if (!this.columnsDefinedByUser) continue;
                this.accessors[i].externalType = 0;
            }
        }
        this.fixedString = this.connection.getDefaultFixedString();
        this.defaultRowPrefetch = this.rowPrefetch;
        this.rowPrefetchInLastFetch = -1;
        if (this.connection.clearStatementMetaData) {
            this.needToParse = true;
            this.needToPrepareDefineBuffer = true;
            this.columnsDefinedByUser = false;
            if (this.userRsetType == OracleResultSet.ResultSetType.UNKNOWN) {
                this.userRsetType = DEFAULT_RESULT_SET_TYPE;
                this.realRsetType = OracleResultSet.ResultSetType.FORWARD_READ_ONLY;
            }
            this.currentRowNeedToPrepareBinds = true;
        }
    }

    @Override
    public void enterExplicitCache() throws SQLException {
        this.cacheState = 2;
        this.creationState = 2;
        this.defaultTimeZone = null;
        this.alwaysOnClose();
    }

    @Override
    public void exitImplicitCacheToActive() throws SQLException {
        this.cacheState = 1;
        this.closed = false;
        if (this.rowPrefetch != this.connection.getDefaultRowPrefetch() && this.streamList == null) {
            this.defaultRowPrefetch = this.rowPrefetch = this.connection.getDefaultRowPrefetch();
            this.rowPrefetchChanged = true;
        }
        this.processEscapes = this.connection.processEscapes;
        if (this.accessors != null) {
            this.doInitializationAfterDefineBufferRestore();
        }
        if (this.cachedBindCharSize != 0 || this.cachedBindByteSize != 0) {
            if (this.cachedBindByteSize > 0) {
                this.bindBytes = this.connection.getByteBuffer(this.cachedBindByteSize);
            }
            if (this.cachedBindCharSize > 0) {
                this.bindChars = this.connection.getCharBuffer(this.cachedBindCharSize);
            }
            this.doLocalInitialization();
        }
    }

    void doLocalInitialization() {
    }

    void doInitializationAfterDefineBufferRestore() {
    }

    @Override
    public void exitExplicitCacheToActive() throws SQLException {
        this.cacheState = 1;
        this.closed = false;
    }

    @Override
    public void exitImplicitCacheToClose() throws SQLException {
        this.cacheState = 0;
        this.closed = false;
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.hardClose();
        }
    }

    @Override
    public void exitExplicitCacheToClose() throws SQLException {
        this.cacheState = 0;
        this.closed = false;
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.hardClose();
        }
    }

    @Override
    public void closeWithKey(String key) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.closeOrCache(key);
        }
    }

    @Override
    protected boolean isQueryResultCached() throws SQLException {
        assert (this.sqlKind.isSELECT()) : "sqlKind.isSELECT() == false";
        switch (this.queryCacheState) {
            case UNKNOWN: {
                return false;
            }
            case CACHEABLE: {
                this.getCachedQueryResult();
                return this.cachedQueryResult != null && this.cachedQueryResult.isValid();
            }
            case UNCACHEABLE: {
                return false;
            }
        }
        return false;
    }

    @Override
    protected void cacheQueryResultIfAppropriate() throws SQLException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "cacheQueryResultIfAppropriate", "queryCacheState={0}. ", (String)null, null, (Object)this.queryCacheState);
        switch (this.queryCacheState) {
            case UNKNOWN: {
                if (this.getCompileKey() == null) {
                    this.queryCacheState = OracleStatement.QueryCacheState.UNCACHEABLE;
                    return;
                }
                this.queryCacheState = OracleStatement.QueryCacheState.CACHEABLE;
            }
            case CACHEABLE: {
                if (this.cachedQueryResult == null || this.cachedQueryResult.isInvalid()) {
                    this.getCachedQueryResult();
                }
                if (this.cachedQueryResult == null || this.cachedQueryResult.isFetching()) break;
                this.useCachedQueryResult();
                break;
            }
        }
    }

    void getCachedQueryResult() throws SQLException {
        this.cachedQueryResult = this.connection.getResultSetCacheInternal().getResultSetCacheEntry(this);
        if (this.cachedQueryResult != null) {
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getCachedQueryResult", "Fetched ResultSetCacheEntry from cache for sql={0}. ", (String)null, null, (Object)this.sqlObject.getOriginalSql());
        }
    }

    long executeInternal() throws SQLException {
        this.prepareForExecuteInternal();
        this.initializeAutoKeyInfo();
        if (this.numberOfBindPositions != 0) {
            this.processCompletedBindRow(1, false);
            this.setupBindBuffers(0, 1);
            this.currentRowBinders = this.binders[0];
        }
        try {
            if (!this.isResultSetRegular() && !this.scrollRsetTypeSolved) {
                long l = this.doScrollPstmtExecuteUpdate() + this.prematureBatchCount;
                return l;
            }
            if (this.currentRowNeedToPrepareBinds) {
                this.runtimeKey = null;
            }
            this.doExecuteWithTimeout();
        }
        finally {
            this.resetBindersToNull(0);
        }
        this.handleExecuteInternalCompletion();
        return this.validRows;
    }

    final void executeInternalAsync(BiConsumer<Long, Throwable> callback) throws SQLException {
        if (!this.isResultSetRegular() && !this.scrollRsetTypeSolved) {
            throw new SQLFeatureNotSupportedException("Scrollable result sets are not supported with async execution");
        }
        this.prepareForExecuteInternal();
        Consumer<Throwable> executeCallback = error -> {
            Long result = null;
            try {
                this.resetBindersToNull(0);
                if (error == null) {
                    this.handleExecuteInternalCompletion();
                    result = this.validRows;
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            finally {
                callback.accept(result, (Throwable)error);
            }
        };
        this.initializeAutoKeyInfoAsync(error -> {
            try {
                if (error == null) {
                    if (this.numberOfBindPositions != 0) {
                        this.processCompletedBindRow(1, false);
                        this.currentRowBinders = this.binders[0];
                    }
                    if (this.currentRowNeedToPrepareBinds) {
                        this.runtimeKey = null;
                    }
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            finally {
                if (error == null) {
                    this.doExecuteWithTimeoutAsync(executeCallback);
                } else {
                    callback.accept((Long)null, (Throwable)error);
                }
            }
        });
    }

    private boolean isResultSetRegular() {
        return this.userRsetType == DEFAULT_RESULT_SET_TYPE;
    }

    private void prepareForExecuteInternal() throws SQLException {
        if (this.connection.isDRCPEnabled()) {
            this.prepareForExecuteWithDRCP();
        }
        this.noMoreUpdateCounts = false;
        this.checkSum = 0L;
        this.checkSumComputationFailure = false;
        this.ensureOpen();
        if (this.currentRank > 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 81, "batch must be either executed or cleared").fillInStackTrace();
        }
        this.prepareForNewResults(true, false, true);
        if (this.isCloseOnCompletion) {
            this.ensureOpen();
        }
    }

    private void handleExecuteInternalCompletion() throws SQLException {
        boolean incrementRowCount;
        boolean bl = incrementRowCount = this.prematureBatchCount != 0L && this.validRows > 0L;
        if (!this.isResultSetRegular()) {
            this.currentResultSet = this.createResultSet();
            if (!this.connection.accumulateBatchResult) {
                incrementRowCount = false;
            }
        }
        if (incrementRowCount) {
            this.validRows += this.prematureBatchCount;
            this.prematureBatchCount = 0L;
        }
        if (this.sqlKind.isOTHER()) {
            this.needToParse = true;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet oracleResultSet;
            this.beginCurrentSql(this.getOriginalSql());
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeQuery", "", null, null);
            try {
                this.prepareForExecuteQuery();
                this.executeInternal();
                this.handleExecuteQueryCompletion();
                oracleResultSet = this.currentResultSet;
            }
            catch (Throwable throwable) {
                this.endCurrentSql();
                throw throwable;
            }
            this.endCurrentSql();
            return oracleResultSet;
        }
        catch (SQLException e) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeQuery", null, null, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public final Flow.Publisher<oracle.jdbc.OracleResultSet> executeQueryAsyncOracle() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.requireOpenStatement();
            if (!this.sqlKind.isSELECT()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 128).fillInStackTrace();
            }
            this.prepareForExecuteQuery();
            this.wrapper.beginAsyncExecution();
            try {
                CompletableFuture executeFuture = new CompletableFuture();
                this.executeInternalAsync((updateCount, error) -> {
                    try {
                        if (error == null) {
                            this.handleExecuteQueryCompletion();
                        }
                    }
                    catch (Throwable throwable) {
                        error = CompletionStageUtil.suppress(throwable, error);
                    }
                    finally {
                        Throwable finalError = error;
                        OracleResultSet finalResultSet = this.currentResultSet;
                        if (this.wrapper != null) {
                            this.wrapper.endAsyncExecution();
                        }
                        this.connection.getAsyncExecutor().execute(() -> {
                            if (finalError == null) {
                                executeFuture.complete(finalResultSet);
                            } else {
                                executeFuture.completeExceptionally(finalError);
                            }
                        });
                    }
                });
                Flow.Publisher<oracle.jdbc.OracleResultSet> publisher = CompletionStageUtil.newSingleItemPublisher(executeFuture, this.connection.getJoinPhaser());
                return publisher;
            }
            catch (RuntimeException | SQLException exception) {
                if (this.wrapper != null) {
                    this.wrapper.endAsyncExecution();
                }
                throw exception;
            }
        }
    }

    private void prepareForExecuteQuery() throws SQLException {
        this.awaitResultSetPublishing();
        this.executeDoneForDefines = true;
        this.executionType = 1;
    }

    private void handleExecuteQueryCompletion() throws SQLException {
        if (this.currentResultSet == null) {
            if (this.validRows < 1L && this.validRows != -2L) {
                this.isAllFetched = true;
            }
            this.currentResultSet = this.createResultSet();
        } else {
            this.computeOffsetOfFirstUserColumn();
            this.computeNumberOfUserColumns();
        }
    }

    @Override
    public final int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    @Override
    public final int executeUpdateAndSuspend() throws SQLException {
        this.connection.postCallSuspend();
        return this.executeUpdate();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        try {
            long l = this.doExecuteLargeUpdate();
            if (lock != null) {
                lock.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeLargeUpdate", null, null, e, new Object[0]);
                throw e;
            }
        }
    }

    protected long doExecuteLargeUpdate() throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        this.beginCurrentSql(this.getOriginalSql());
        this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeLargeUpdate", "", null, null);
        try {
            this.awaitResultSetPublishing();
            this.executionType = (byte)2;
            long l = this.executeInternal();
            return l;
        }
        finally {
            this.endCurrentSql();
        }
    }

    @Override
    public Flow.Publisher<Long> executeUpdateAsyncOracle() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.requireOpenStatement();
            if (this.sqlKind.isSELECT()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 129).fillInStackTrace();
            }
            this.awaitResultSetPublishing();
            this.executionType = (byte)2;
            this.wrapper.beginAsyncExecution();
            try {
                CompletableFuture executeFuture = new CompletableFuture();
                this.executeInternalAsync((updateCount, error) -> {
                    if (this.wrapper != null) {
                        this.wrapper.endAsyncExecution();
                    }
                    this.connection.getAsyncExecutor().execute(() -> {
                        if (error == null) {
                            executeFuture.complete(updateCount);
                        } else {
                            executeFuture.completeExceptionally((Throwable)error);
                        }
                    });
                });
                Flow.Publisher<Long> publisher = CompletionStageUtil.newSingleItemPublisher(executeFuture, this.connection.getJoinPhaser());
                return publisher;
            }
            catch (RuntimeException | SQLException exception) {
                if (this.wrapper != null) {
                    this.wrapper.endAsyncExecution();
                }
                throw exception;
            }
        }
    }

    @Override
    public boolean execute() throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        try {
            boolean bl = this.doExecute();
            if (lock != null) {
                lock.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "execute", null, null, e, new Object[0]);
                throw e;
            }
        }
    }

    protected boolean doExecute() throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        this.beginCurrentSql(this.getOriginalSql());
        this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "execute", null, null, null);
        try {
            this.prepareForExecute();
            this.executeInternal();
            boolean bl = this.sqlKind.isSELECT();
            return bl;
        }
        finally {
            this.endCurrentSql();
        }
    }

    @Override
    public Flow.Publisher<Boolean> executeAsyncOracle() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.requireOpenStatement();
            CompletableFuture executeFuture = new CompletableFuture();
            this.executeAsyncOracleInternal((updateCount, error) -> this.connection.getAsyncExecutor().execute(() -> {
                if (error == null) {
                    executeFuture.complete(updateCount);
                } else {
                    executeFuture.completeExceptionally((Throwable)error);
                }
            }));
            Flow.Publisher<Boolean> publisher = CompletionStageUtil.newSingleItemPublisher(executeFuture, this.connection.getJoinPhaser());
            return publisher;
        }
    }

    void executeAsyncOracleInternal(BiConsumer<Boolean, Throwable> callback) throws SQLException {
        this.prepareForExecute();
        this.wrapper.beginAsyncExecution();
        try {
            this.executeInternalAsync((updateCount, error) -> {
                if (this.wrapper != null) {
                    this.wrapper.endAsyncExecution();
                }
                if (error == null) {
                    callback.accept(this.sqlKind.isSELECT(), null);
                } else {
                    callback.accept((Boolean)null, (Throwable)error);
                }
            });
        }
        catch (RuntimeException | SQLException exception) {
            if (this.wrapper != null) {
                this.wrapper.endAsyncExecution();
            }
            throw exception;
        }
    }

    private void prepareForExecute() throws SQLException {
        this.awaitResultSetPublishing();
        this.executeDoneForDefines = true;
        this.executionType = (byte)3;
    }

    void slideDownCurrentRow(int fromRow) {
        Object[] tmp;
        if (this.binders != null) {
            this.binders[fromRow] = this.binders[0];
            this.binders[0] = this.currentRowBinders;
        }
        if (this.parameterStream != null) {
            tmp = this.parameterStream[0];
            this.parameterStream[0] = this.parameterStream[fromRow];
            this.parameterStream[fromRow] = tmp;
        }
        if (this.userStream != null) {
            tmp = this.userStream[0];
            this.userStream[0] = this.userStream[fromRow];
            this.userStream[fromRow] = tmp;
        }
    }

    @Override
    public int sendBatch() throws SQLException {
        return 0;
    }

    @Override
    public void defineParameterTypeBytes(int param_index, int type, int max_size) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (max_size < 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 53).fillInStackTrace();
            }
            int index = param_index - 1;
            if (index < 0 || param_index > this.numberOfBindPositions) {
                throw (SQLException)DatabaseError.createSqlException(3).fillInStackTrace();
            }
            if (this.parameterMaxLength == null) {
                this.parameterMaxLength = new int[this.numberOfBindPositions];
            }
            this.parameterMaxLength[index] = max_size;
        }
    }

    @Override
    public void defineParameterTypeChars(int param_index, int type, int max_size) throws SQLException {
        int nlsratio = this.connection.getNlsRatio();
        if (type == 1 || type == 12) {
            this.defineParameterTypeBytes(param_index, type, max_size * nlsratio);
        } else {
            this.defineParameterTypeBytes(param_index, type, max_size);
        }
    }

    @Override
    public void defineParameterType(int param_index, int type, int max_size) throws SQLException {
        this.defineParameterTypeBytes(param_index, type, max_size);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.sqlKind.isSELECT()) {
                ResultSetMetaData resultSetMetaData = this.getResultSetMetaData();
                return resultSetMetaData;
            }
            ResultSetMetaData resultSetMetaData = null;
            return resultSetMetaData;
        }
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String sqlName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setNullInternal(paramIndex, sqlType, sqlName);
        }
    }

    void setNullInternal(int paramIndex, int sqlType, String sqlName) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setNullInternal(int, int, String)", (String)null, "index={0}, sqlType={1}, sqlName={2}. ", null, (Object)paramIndex, (Object)sqlType, (Object)sqlName);
        if (sqlType != 2002 && sqlType != 2008 && sqlType != 2003 && sqlType != 2007 && sqlType != 2009 && sqlType != 2006) {
            this.setNullInternal(paramIndex, sqlType);
            return;
        }
        this.connection.assertLockHeldByCurrentThread();
        this.setNullCritical(index, sqlType, sqlName);
    }

    void setNullInternal(int paramIndex, int sqlType) throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        this.setNullCritical(paramIndex, sqlType);
    }

    void setNullCritical(int index, int sqlType, String sqlName) throws SQLException {
        OracleTypeADT otype = null;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setNullCritical(int, int, String)", (String)null, "index={0}, sqlType={1}, sqlName={2}. ", null, (Object)index, (Object)sqlType, (Object)sqlName);
        switch (sqlType) {
            case 2002: 
            case 2006: 
            case 2008: {
                TypeDescriptor desc = StructDescriptor.createDescriptor(sqlName, (Connection)this.connection);
                otype = ((StructDescriptor)desc).getOracleTypeADT();
                break;
            }
            case 2003: {
                TypeDescriptor desc = ArrayDescriptor.createDescriptor(sqlName, (Connection)this.connection);
                otype = ((ArrayDescriptor)desc).getOracleTypeCOLLECTION();
                break;
            }
            case 2007: 
            case 2009: {
                TypeDescriptor desc = OpaqueDescriptor.createDescriptor(sqlName, (Connection)this.connection);
                otype = (OracleTypeADT)desc.getPickler();
                break;
            }
        }
        if (otype != null) {
            otype.getTOID();
        }
        TypeBinder binder = sqlType == 2006 ? new RefTypeNullBinder(otype) : new NamedTypeNullBinder(otype);
        this.currentRowBinders[index] = binder;
        this.currentRowByteLens[index] = binder.bytelen;
        this.currentRowCharLens[index] = 0;
    }

    @Override
    public void setNullAtName(String paramName, int sqlType, String sqlName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setNullInternal(i + 1, sqlType, sqlName);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setNull(int paramIndex, int sqlType) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setNullCritical(paramIndex, sqlType);
        }
    }

    void setNullCritical(int paramIndex, int sqlType) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setNullCritical(int, int)", (String)null, "index={0}, sqlType={1}. ", null, (Object)paramIndex, (Object)sqlType);
        Binder binder = null;
        int dbtype = this.getInternalType(sqlType);
        boolean isBytes = true;
        switch (dbtype) {
            case 252: {
                if (this.connection.databaseMetaData.getDatabaseMajorVersion() < 12 || this.connection.databaseMetaData.getDatabaseMajorVersion() == 12 && this.connection.databaseMetaData.getDatabaseMinorVersion() < 1) {
                    throw (SQLException)DatabaseError.createSqlException(299).fillInStackTrace();
                }
                binder = new BooleanNullBinder();
                break;
            }
            case 6: {
                binder = new VarnumNullBinder();
                break;
            }
            case 1: 
            case 8: 
            case 96: 
            case 995: {
                binder = new VarcharNullBinder();
                isBytes = false;
                break;
            }
            case 999: {
                binder = new FixedCHARNullBinder();
                isBytes = false;
                break;
            }
            case 12: {
                binder = new DateNullBinder();
                break;
            }
            case 180: {
                binder = new TimestampNullBinder();
                break;
            }
            case 181: {
                binder = new TSTZNullBinder();
                break;
            }
            case 231: {
                binder = new TSLTZNullBinder();
                break;
            }
            case 104: {
                binder = this.getRowidNullBinder(index);
                break;
            }
            case 183: {
                binder = new IntervalDSNullBinder();
                break;
            }
            case 182: {
                binder = new IntervalYMNullBinder();
                break;
            }
            case 23: 
            case 24: {
                binder = new RawNullBinder();
                break;
            }
            case 100: {
                binder = new BinaryFloatNullBinder();
                break;
            }
            case 101: {
                binder = new BinaryDoubleNullBinder();
                break;
            }
            case 113: {
                binder = new BlobNullBinder();
                break;
            }
            case 119: {
                binder = new JsonNullBinder();
                break;
            }
            case 112: {
                binder = new ClobNullBinder();
                break;
            }
            case 114: {
                binder = new BfileNullBinder();
                break;
            }
            case 109: 
            case 111: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "Use setNull(int parameterIndex, int sqlType, String typeName) for user-defined types and REF types").fillInStackTrace();
            }
            case 102: {
                binder = new RefCursorNullBinder();
                break;
            }
            case 127: {
                binder = new VectorNullBinder();
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "sqlType=" + sqlType).fillInStackTrace();
            }
        }
        this.currentRowBinders[index] = binder;
        if (isBytes) {
            this.currentRowByteLens[index] = binder.bytelen;
            this.currentRowCharLens[index] = 0;
        } else {
            this.currentRowByteLens[index] = 0;
            this.currentRowCharLens[index] = this.sqlKind.isPlsqlOrCall() ? this.connection.minVcsBindSize : 1;
        }
    }

    Binder getRowidNullBinder(int index) throws SQLException {
        return this.createRowidNullBinder();
    }

    @Override
    public void setNullAtName(String paramName, int sqlType) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setNull(i + 1, sqlType);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setBoolean(int paramIndex, boolean x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setBooleanInternal(paramIndex, x);
        }
    }

    protected Binder createBooleanBinder(boolean x) throws SQLException {
        return new BooleanBinder21c(x ? 1 : 0);
    }

    void setBooleanInternal(int paramIndex, boolean x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = this.createBooleanBinder(x);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setBooleanInternal", (String)null, "index={0}, value={1}. ", null, (Object)paramIndex, (Object)x);
    }

    public void setPlsqlBoolean(int paramIndex, boolean x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setPlsqlBooleanInternal(paramIndex, x);
        }
    }

    void setPlsqlBooleanInternal(int paramIndex, boolean x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = new BooleanBinder(x ? 1 : 0);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setPlsqlBooleanInternal", (String)null, "index={0}, value={1}. ", null, (Object)paramIndex, (Object)x);
    }

    @Override
    public void setByte(int paramIndex, byte x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setByteInternal(paramIndex, x);
        }
    }

    void setByteInternal(int paramIndex, byte x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = new ByteBinder(x);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setByteInternal", (String)null, "bind index={0}, value={1}. ", null, (Object)paramIndex, (Object)x);
    }

    @Override
    public void setShort(int paramIndex, short x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setShortInternal(paramIndex, x);
        }
    }

    void setShortInternal(int paramIndex, short x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = new ShortBinder(x);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setShortInternal", (String)null, "index={0}, value={1}. ", null, (Object)paramIndex, (Object)x);
    }

    @Override
    public void setInt(int paramIndex, int x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setIntInternal(paramIndex, x);
        }
    }

    void setIntInternal(int paramIndex, int x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = new IntBinder(x);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setIntInternal", (String)null, "index={0}, value={1}. ", null, (Object)paramIndex, (Object)x);
    }

    void setRefCursorInternal(int paramIndex, int x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = new RefCursorBinder(x);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setRefCursorInternal", (String)null, "index={0}, value={1}. ", null, (Object)paramIndex, (Object)x);
    }

    @Override
    public void setLong(int paramIndex, long x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setLongInternal(paramIndex, x);
        }
    }

    void setLongInternal(int paramIndex, long x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = new LongBinder(x);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setLongInternal", (String)null, "bind index={0}, value={1}. ", null, (Object)paramIndex, (Object)x);
    }

    @Override
    public void setFloat(int paramIndex, float x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setFloatInternal(paramIndex, x);
        }
    }

    void setFloatInternal(int paramIndex, float x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (!this.connection.setFloatAndDoubleUseBinary && Float.isNaN(x)) {
            throw new IllegalArgumentException("NaN");
        }
        this.currentRowBinders[index] = this.connection.setFloatAndDoubleUseBinary ? new BinaryFloatBinder(x) : new FloatBinder(x);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setFloatInternal", (String)null, "bind index={0}, value={1}. ", null, (Object)paramIndex, (Object)Float.valueOf(x));
    }

    @Override
    public void setBinaryFloat(int paramIndex, float x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setBinaryFloatInternal(paramIndex, x);
        }
    }

    void setBinaryFloatInternal(int paramIndex, float x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = new BinaryFloatBinder(x);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setBinaryFloatInternal", (String)null, "index={0}, value={1}. ", null, (Object)paramIndex, (Object)Float.valueOf(x));
    }

    @Override
    public void setBinaryFloat(int paramIndex, BINARY_FLOAT bf) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setBinaryFloatInternal(paramIndex, bf);
        }
    }

    void setBinaryFloatInternal(int paramIndex, BINARY_FLOAT bf) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = bf == null ? new BINARY_FLOATNullBinder() : new BINARY_FLOATBinder(bf.getBytes());
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
    }

    @Override
    public void setBinaryDouble(int paramIndex, double x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setBinaryDoubleInternal(paramIndex, x);
        }
    }

    void setBinaryDoubleInternal(int paramIndex, double x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = new BinaryDoubleBinder(x);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setBinaryDoubleInternal", (String)null, "bind index={0}, value={1}. ", null, (Object)paramIndex, (Object)x);
    }

    @Override
    public void setBinaryDouble(int paramIndex, BINARY_DOUBLE bd) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setBinaryDoubleInternal(paramIndex, bd);
        }
    }

    void setBinaryDoubleInternal(int paramIndex, BINARY_DOUBLE bd) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = bd == null ? new BINARY_DOUBLENullBinder() : new BINARY_DOUBLEBinder(bd.getBytes());
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
    }

    @Override
    public void setDouble(int paramIndex, double x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setDoubleInternal(paramIndex, x);
        }
    }

    void setDoubleInternal(int paramIndex, double x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (!this.connection.setFloatAndDoubleUseBinary) {
            if (Double.isNaN(x)) {
                throw new IllegalArgumentException("NaN");
            }
            double dVal = Math.abs(x);
            if (dVal != 0.0 && dVal < 1.0E-130) {
                throw new IllegalArgumentException("Underflow");
            }
            if (dVal >= 1.0E126) {
                throw new IllegalArgumentException("Overflow");
            }
        }
        this.currentRowBinders[index] = this.connection.setFloatAndDoubleUseBinary ? new BinaryDoubleBinder(x) : new DoubleBinder(x);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setDoubleInternal", (String)null, "index={0}, value={1}. ", null, (Object)paramIndex, (Object)x);
    }

    @Override
    public void setBigDecimal(int paramIndex, BigDecimal x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setBigDecimalInternal(paramIndex, x);
        }
    }

    void setBigDecimalInternal(int paramIndex, BigDecimal x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = x == null ? new VarnumNullBinder() : new BigDecimalBinder(x);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setBigDecimalInternal", (String)null, "index={0}, value={1}. ", null, (Object)paramIndex, (Object)x);
    }

    @Override
    public void setString(int paramIndex, String x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setFormOfUseInternal(paramIndex, this.defaultFormOfUse);
            if (this.connection.mapStringParameterToCHAR) {
                this.setFixedCHARInternal(paramIndex, x);
            } else {
                this.setStringInternal(paramIndex, x);
            }
        }
    }

    void setStringInternal(int paramIndex, String x) throws SQLException {
        int stringLength;
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setStringInternal", (String)null, "index={0}, value={1}. ", null, (Object)paramIndex, (Object)x);
        int n = stringLength = x != null ? x.length() : 0;
        if (stringLength == 0) {
            this.setNullInternal(paramIndex, 12);
        } else if (this.currentRowFormOfUse[paramIndex - 1] == 1) {
            if (this.sqlKind.isPlsqlOrCall()) {
                if (stringLength > this.maxVcsBytesPlsql || stringLength > this.maxVcsCharsPlsql && this.isServerCharSetFixedWidth) {
                    this.setStringForClobCritical(paramIndex, x);
                } else if (stringLength > this.maxVcsCharsPlsql) {
                    int bytes_length = this.connection.conversion.encodedByteLength(x, false);
                    if (bytes_length > this.maxVcsBytesPlsql) {
                        this.setStringForClobCritical(paramIndex, x);
                    } else {
                        this.basicBindString(paramIndex, x);
                    }
                } else {
                    this.basicBindString(paramIndex, x);
                }
            } else if (stringLength <= this.maxVcsCharsSql) {
                this.basicBindString(paramIndex, x);
            } else if (stringLength <= this.maxStreamCharsSql) {
                this.basicBindCharacterStream(paramIndex, new StringReader(x), stringLength, true);
            } else {
                this.setStringForClobCritical(paramIndex, x);
            }
        } else if (this.sqlKind.isPlsqlOrCall()) {
            if (stringLength > this.maxVcsBytesPlsql || stringLength > this.maxVcsNCharsPlsql && this.isServerNCharSetFixedWidth) {
                this.setStringForClobCritical(paramIndex, x);
            } else if (stringLength > this.maxVcsNCharsPlsql) {
                int bytes_length = this.connection.conversion.encodedByteLength(x, true);
                if (bytes_length > this.maxVcsBytesPlsql) {
                    this.setStringForClobCritical(paramIndex, x);
                } else {
                    this.basicBindString(paramIndex, x);
                }
            } else {
                this.basicBindString(paramIndex, x);
            }
        } else if (stringLength <= this.maxVcsCharsSql) {
            this.basicBindString(paramIndex, x);
        } else {
            this.setStringForClobCritical(paramIndex, x);
        }
    }

    void basicBindNullString(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int index = paramIndex - 1;
            this.currentRowBinders[index] = new VarcharNullBinder();
            this.currentRowCharLens[index] = this.sqlKind.isPlsqlOrCall() ? this.minVcsBindSize : 1;
            this.currentRowByteLens[index] = 0;
        }
    }

    protected Binder createStringBinder(String x) {
        return new StringBinder(x);
    }

    void basicBindString(int paramIndex, String x) throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        int index = paramIndex - 1;
        this.currentRowBinders[index] = this.createStringBinder(x);
        int stringLength = x.length();
        if (this.sqlKind.isPlsqlOrCall()) {
            int min_size = this.maxFieldSize > 0 && this.maxFieldSize < this.connection.minVcsBindSize ? this.maxFieldSize : this.connection.minVcsBindSize;
            int cur_len = stringLength + 1;
            this.currentRowCharLens[index] = cur_len < min_size ? min_size : cur_len;
        } else {
            this.currentRowCharLens[index] = stringLength + 1;
        }
        this.currentRowByteLens[index] = 0;
    }

    @Override
    public void setStringForClob(int paramIndex, String x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (x == null) {
                this.setNullCritical(paramIndex, 1);
                return;
            }
            int stringLength = x.length();
            if (stringLength == 0) {
                this.setNullCritical(paramIndex, 1);
                return;
            }
            if (this.sqlKind.isPlsqlOrCall()) {
                if (stringLength <= this.maxVcsCharsPlsql) {
                    this.setStringInternal(paramIndex, x);
                } else {
                    this.setStringForClobCritical(paramIndex, x);
                }
            } else if (stringLength <= this.maxVcsCharsSql) {
                this.setStringInternal(paramIndex, x);
            } else {
                this.setStringForClobCritical(paramIndex, x);
            }
        }
    }

    void setStringForClobCritical(int paramIndex, String x) throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        CLOB tclob = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[paramIndex - 1]);
        tclob.setString(1L, x);
        this.addToTempLobsToFree(tclob);
        this.lastBoundClobs[paramIndex - 1] = tclob;
        this.setCLOBInternal(paramIndex, tclob);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setReaderContentsForClobCritical(int paramIndex, Reader reader, long length, boolean isLengthSpecified) throws SQLException {
        int retChar;
        long lengthRemaining;
        char[] charbuf;
        int bufferSize;
        OracleClobWriter writer;
        CLOB tclob;
        Monitor.CloseableLock lock;
        block15: {
            long l;
            block14: {
                lock = this.connection.acquireCloseableLock();
                try {
                    reader = this.isReaderEmpty(reader);
                    if (reader == null) {
                        if (isLengthSpecified) {
                            throw new SQLException(length + " char of CLOB data cannot be read");
                        }
                        this.setCLOBInternal(paramIndex, null);
                        return;
                    }
                    tclob = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[paramIndex - 1]);
                    writer = (OracleClobWriter)tclob.setCharacterStream(1L);
                    bufferSize = tclob.getBufferSize();
                    charbuf = new char[bufferSize];
                    lengthRemaining = 0L;
                    retChar = 0;
                    if (!isLengthSpecified) break block14;
                }
                catch (IOException x) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), x).fillInStackTrace();
                }
                l = length;
                break block15;
            }
            l = Long.MAX_VALUE;
        }
        try {
            for (lengthRemaining = v410038; lengthRemaining > 0L; lengthRemaining -= (long)retChar) {
                retChar = lengthRemaining >= (long)bufferSize ? reader.read(charbuf) : reader.read(charbuf, 0, (int)lengthRemaining);
                if (retChar == -1) {
                    if (!isLengthSpecified) break;
                    throw new SQLException(lengthRemaining + " char of CLOB data cannot be read");
                }
                writer.write(charbuf, 0, retChar);
            }
            writer.flush();
        }
        catch (IOException x) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), x).fillInStackTrace();
        }
        this.addToTempLobsToFree(tclob);
        this.lastBoundClobs[paramIndex - 1] = tclob;
        this.setCLOBInternal(paramIndex, tclob);
        return;
        finally {
            if (lock != null) {
                lock.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setAsciiStreamContentsForClobCritical(int paramIndex, InputStream inputStream, long length, boolean isLengthSpecified) throws SQLException {
        int retByte;
        char[] charbuf;
        byte[] bytebuf;
        int bufferSize;
        OracleClobWriter writer;
        CLOB tclob;
        Monitor.CloseableLock lock;
        block15: {
            long l;
            block14: {
                lock = this.connection.acquireCloseableLock();
                try {
                    inputStream = this.isInputStreamEmpty(inputStream);
                    if (inputStream == null) {
                        if (isLengthSpecified) {
                            throw new SQLException(length + " byte of CLOB data cannot be read");
                        }
                        this.setCLOBInternal(paramIndex, null);
                        return;
                    }
                    tclob = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[paramIndex - 1]);
                    writer = (OracleClobWriter)tclob.setCharacterStream(1L);
                    bufferSize = tclob.getBufferSize();
                    bytebuf = new byte[bufferSize];
                    charbuf = new char[bufferSize];
                    retByte = 0;
                    if (!isLengthSpecified) break block14;
                }
                catch (IOException x) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), x).fillInStackTrace();
                }
                l = length;
                break block15;
            }
            l = Long.MAX_VALUE;
        }
        try {
            for (long lengthRemaining = v410534; lengthRemaining > 0L; lengthRemaining -= (long)retByte) {
                retByte = lengthRemaining >= (long)bufferSize ? inputStream.read(bytebuf) : inputStream.read(bytebuf, 0, (int)lengthRemaining);
                if (retByte == -1) {
                    if (!isLengthSpecified) break;
                    throw new SQLException(lengthRemaining + " byte of CLOB data cannot be read");
                }
                DBConversion.asciiBytesToJavaChars(bytebuf, retByte, charbuf);
                writer.write(charbuf, 0, retByte);
            }
            writer.flush();
        }
        catch (IOException x) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), x).fillInStackTrace();
        }
        this.addToTempLobsToFree(tclob);
        this.lastBoundClobs[paramIndex - 1] = tclob;
        this.setCLOBInternal(paramIndex, tclob);
        return;
        finally {
            if (lock != null) {
                lock.close();
            }
        }
    }

    @Override
    public void setStringForClobAtName(String paramName, String x) throws SQLException {
        if (paramName == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setStringForClob(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
        }
    }

    @Override
    public void setFixedCHAR(int paramIndex, String x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setFixedCHARInternal(paramIndex, x);
        }
    }

    protected Binder createFixedCHARBinder(String x) {
        return new FixedCHARBinder(x);
    }

    void setFixedCHARInternal(int paramIndex, String x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        int stringLength = 0;
        if (x != null) {
            stringLength = x.length();
        }
        if (stringLength > 32766) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 157).fillInStackTrace();
        }
        if (x == null) {
            this.currentRowBinders[index] = new FixedCHARNullBinder();
            this.currentRowCharLens[index] = 1;
        } else {
            this.currentRowBinders[index] = this.createFixedCHARBinder(x);
            this.currentRowCharLens[index] = stringLength + 1;
        }
        this.currentRowByteLens[index] = 0;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setFixedCHARInternal", (String)null, "index={0}, value={1}. ", null, (Object)paramIndex, (Object)x);
    }

    @Override
    @Deprecated
    public void setCursor(int paramIndex, ResultSet rs) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setCursorInternal(paramIndex, rs);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setCursorInternal(int paramIndex, ResultSet rs) throws SQLException {
        if (rs == null) {
            this.setNullInternal(paramIndex, -10);
            return;
        } else {
            if (!(rs instanceof OracleResultSet)) throw (SQLException)DatabaseError.createSqlException(18).fillInStackTrace();
            PhysicalConnection rsConn = ((OracleResultSet)rs).connection;
            PhysicalConnection sConn = this.connection;
            if ((rsConn != null || sConn != null) && rsConn != sConn && !rsConn.equals(sConn)) throw (SQLException)DatabaseError.createSqlException(18).fillInStackTrace();
            this.setRefCursorInternal(paramIndex, ((OracleResultSet)rs).getCursorId());
        }
    }

    @Override
    public void setROWID(int paramIndex, ROWID rowid) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setROWIDInternal(paramIndex, rowid);
        }
    }

    protected Binder createRowidBinder(byte[] rowidBytes) throws SQLException {
        return this.connection.useLittleEndianSetCHARBinder() ? new LittleEndianRowidBinder(rowidBytes) : new RowidBinder(rowidBytes);
    }

    protected Binder createURowidBinder(byte[] rowidBytes) throws SQLException {
        return this.createRowidBinder(rowidBytes);
    }

    protected Binder createRowidNullBinder() throws SQLException {
        return new RowidNullBinder();
    }

    protected Binder createURowidNullBinder() throws SQLException {
        return this.createRowidNullBinder();
    }

    void setROWIDInternal(int paramIndex, ROWID rowid) throws SQLException {
        if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK) {
            if (rowid == null) {
                this.setNull(paramIndex, 12);
            } else {
                this.setStringInternal(paramIndex, rowid.stringValue());
            }
            return;
        }
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (rowid == null || rowid.shareBytes() == null) {
            this.currentRowBinders[index] = this.createRowidNullBinder();
            this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        } else {
            byte[] rowidBytes = rowid.getBytes();
            this.currentRowBinders[index] = T4CRowidAccessor.isUROWID(rowid.shareBytes(), 0) ? this.createURowidBinder(rowidBytes) : this.createRowidBinder(rowidBytes);
            this.currentRowByteLens[index] = rowidBytes.length + 2;
        }
        this.currentRowCharLens[index] = 0;
    }

    @Override
    public void setArray(int paramIndex, java.sql.Array arr) throws SQLException {
        this.setARRAYInternal(paramIndex, (ARRAY)arr);
    }

    void setArrayInternal(int paramIndex, java.sql.Array arr) throws SQLException {
        this.setARRAYInternal(paramIndex, (ARRAY)arr);
    }

    @Override
    public void setARRAY(int paramIndex, ARRAY arr) throws SQLException {
        this.setARRAYInternal(paramIndex, arr);
    }

    void setARRAYInternal(int paramIndex, ARRAY arr) throws SQLException {
        PhysicalConnection c2;
        PhysicalConnection c1;
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (arr == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        PhysicalConnection phys = (PhysicalConnection)arr.getPhysicalConnection();
        if (phys == null || this.connection == phys) {
            try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                this.setArrayCritical(index, arr);
                this.currentRowCharLens[index] = 0;
            }
        }
        this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "setARRAYInternal", "ARRAY created by one OracleConnection was used by a different OracleConnection. ", null, null);
        if (this.connection.hashCode() < phys.hashCode()) {
            c1 = this.connection;
            c2 = phys;
        } else {
            c1 = phys;
            c2 = this.connection;
        }
        try (Monitor.CloseableLock lock1 = c1.acquireCloseableLock();
             Monitor.CloseableLock lock2 = c2.acquireCloseableLock();){
            this.setArrayCritical(index, arr);
            this.currentRowCharLens[index] = 0;
        }
    }

    void setArrayCritical(int index, ARRAY arr) throws SQLException {
        ArrayDescriptor desc = arr.getDescriptor();
        if (desc == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 61).fillInStackTrace();
        }
        OracleTypeCOLLECTION otype = desc.getOracleTypeCOLLECTION();
        otype.getTOID();
        this.currentRowBinders[index] = new NamedTypeBinder(arr.toBytes(), otype);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
    }

    @Override
    public void setOPAQUE(int paramIndex, OPAQUE opaque) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setOPAQUEInternal(paramIndex, opaque);
        }
    }

    void setOPAQUEInternal(int paramIndex, OPAQUE opaque) throws SQLException {
        PhysicalConnection c2;
        PhysicalConnection c1;
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (opaque == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        PhysicalConnection phys = (PhysicalConnection)opaque.getPhysicalConnection();
        if (phys == null || this.connection == phys) {
            try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                this.setOPAQUECritical(index, opaque);
                this.currentRowCharLens[index] = 0;
            }
        }
        this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "setOPAQUEInternal", "OPAQUE created by one OracleConnection was used by a different OracleConnection. ", null, null);
        if (this.connection.hashCode() < phys.hashCode()) {
            c1 = this.connection;
            c2 = phys;
        } else {
            c1 = phys;
            c2 = this.connection;
        }
        try (Monitor.CloseableLock lock1 = c1.acquireCloseableLock();
             Monitor.CloseableLock lock2 = c2.acquireCloseableLock();){
            this.setOPAQUECritical(index, opaque);
            this.currentRowCharLens[index] = 0;
        }
    }

    void setOPAQUECritical(int index, OPAQUE opaque) throws SQLException {
        OpaqueDescriptor desc = opaque.getDescriptor();
        if (desc == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 61).fillInStackTrace();
        }
        OracleTypeADT otype = (OracleTypeADT)desc.getPickler();
        otype.getTOID();
        this.currentRowBinders[index] = new NamedTypeBinder(opaque.toBytes(), otype);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
    }

    void setSQLXMLInternal(int index, SQLXML sqlxml) throws SQLException {
        if (sqlxml == null) {
            this.setNull(index, 0);
        } else {
            this.setOPAQUEInternal(index, (OPAQUE)((Object)sqlxml));
        }
    }

    @Override
    public void setStructDescriptor(int paramIndex, StructDescriptor desc) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setStructDescriptorInternal(paramIndex, desc);
        }
    }

    void setStructDescriptorInternal(int paramIndex, StructDescriptor desc) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (desc == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setStructDescriptorCritical(index, desc);
            this.currentRowCharLens[index] = 0;
        }
    }

    void setStructDescriptorCritical(int index, StructDescriptor desc) throws SQLException {
        OracleTypeADT otype = desc.getOracleTypeADT();
        otype.getTOID();
        this.currentRowBinders[index] = new NamedTypeBinder(null, otype);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
    }

    @Override
    public void setStructDescriptorAtName(String paramName, StructDescriptor desc) throws SQLException {
        if (paramName == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setStructDescriptorInternal(i + 1, desc);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    void setPreBindsCompelete() throws SQLException {
    }

    @Override
    public void setSTRUCT(int paramIndex, STRUCT struct) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setSTRUCTInternal(paramIndex, struct);
        }
    }

    void setSTRUCTInternal(int paramIndex, STRUCT struct) throws SQLException {
        PhysicalConnection c2;
        PhysicalConnection c1;
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (struct == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        PhysicalConnection phys = (PhysicalConnection)struct.getPhysicalConnection();
        if (phys == null || this.connection == phys) {
            try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                this.setSTRUCTCritical(index, struct);
                this.currentRowCharLens[index] = 0;
            }
        }
        this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "setSTRUCTInternal", "STRUCT created by one OracleConnection was used by a different OracleConnection. ", null, null);
        if (this.connection.hashCode() < phys.hashCode()) {
            c1 = this.connection;
            c2 = phys;
        } else {
            c1 = phys;
            c2 = this.connection;
        }
        try (Monitor.CloseableLock lock1 = c1.acquireCloseableLock();
             Monitor.CloseableLock lock2 = c2.acquireCloseableLock();){
            this.setSTRUCTCritical(index, struct);
            this.currentRowCharLens[index] = 0;
        }
    }

    void setSTRUCTCritical(int index, STRUCT struct) throws SQLException {
        StructDescriptor desc = struct.getDescriptor();
        if (desc == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 61).fillInStackTrace();
        }
        OracleTypeADT otype = desc.getOracleTypeADT();
        otype.getTOID();
        this.currentRowBinders[index] = new NamedTypeBinder(struct.toBytes(), otype);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "setSTRUCTCritical", "parameterDatum[{0}][{1}]={2}. ", (String)null, (Throwable)null, (Object)this.currentRank, (Object)index, this.secure(Parameter.arg(Format.Style.BYTE_ARRAY, struct.toBytes(), new long[0])));
    }

    @Override
    public void setRAW(int paramIndex, RAW raw) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setRAWInternal(paramIndex, raw);
        }
    }

    void setRAWInternal(int paramIndex, RAW raw) throws SQLException {
        boolean invokeBindBytes = false;
        this.connection.assertLockHeldByCurrentThread();
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (raw == null) {
            this.currentRowBinders[index] = new RawNullBinder();
            this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
            this.currentRowCharLens[index] = 0;
        } else {
            invokeBindBytes = true;
        }
        if (invokeBindBytes) {
            this.setBytesInternal(paramIndex, raw.getBytes());
        }
    }

    @Override
    public void setCHAR(int paramIndex, CHAR ch) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setCHARInternal(paramIndex, ch);
        }
    }

    void setCHARInternal(int paramIndex, CHAR ch) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (ch == null || ch.getLength() == 0L) {
            this.currentRowBinders[index] = new SetCHARNullBinder();
            this.currentRowCharLens[index] = 1;
        } else {
            byte[] b;
            short formOfUse = this.currentRowFormOfUse[index];
            short char_cs_id = (short)ch.oracleId();
            CharacterSet targetCS = this.getCharacterSetForBind(index, formOfUse);
            if (targetCS != null && targetCS.getOracleId() != char_cs_id) {
                byte[] cb = ch.shareBytes();
                b = targetCS.convert(ch.getCharacterSet(), cb, 0, cb.length);
            } else {
                b = ch.getBytes();
            }
            SetCHARBinder charBinder = this.connection.useLittleEndianSetCHARBinder() ? new LittleEndianSetCHARBinder(b) : new SetCHARBinder(b);
            this.currentRowBinders[index] = charBinder;
            this.adjustCharLensForSetCHAR(index, b);
        }
        if (this.sqlKind.isPlsqlOrCall() && this.currentRowCharLens[index] < this.minVcsBindSize) {
            this.currentRowCharLens[index] = this.minVcsBindSize;
        }
    }

    void adjustCharLensForSetCHAR(int index, byte[] b) {
        this.currentRowCharLens[index] = (b.length + 1 >> 1) + 1;
        this.currentRowByteLens[index] = 0;
    }

    @Override
    public void setDATE(int paramIndex, DATE date) throws SQLException {
        this.setDATEInternal(paramIndex, date);
    }

    void setDATEInternal(int paramIndex, DATE date) throws SQLException {
        int index = paramIndex - 1;
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (index < 0 || paramIndex > this.numberOfBindPositions) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.currentRowBinders[index] = date == null ? new DateNullBinder() : new OracleDateBinder(date.getBytes());
            this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
            this.currentRowCharLens[index] = 0;
        }
    }

    @Override
    public void setNUMBER(int paramIndex, NUMBER num) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setNUMBERInternal(paramIndex, num);
        }
    }

    void setNUMBERInternal(int paramIndex, NUMBER num) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = num == null ? new VarnumNullBinder() : new OracleNumberBinder(num.getBytes());
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
    }

    @Override
    public void setBLOB(int paramIndex, BLOB lob) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setBLOBInternal(paramIndex, lob);
        }
    }

    void setBLOBInternal(int paramIndex, oracle.jdbc.internal.OracleBlob lob) throws SQLException {
        int index = paramIndex - 1;
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            byte[] locator;
            if (index < 0 || paramIndex > this.numberOfBindPositions) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.currentRowBinders[index] = lob == null ? new BlobNullBinder() : (PhysicalConnection.isQuasiLocator(locator = lob.getBytes()) ? new BlobBinder(locator, ByteBuffer.wrap((byte[])lob.getPrefetchData().share())) : new BlobBinder(locator));
            this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
            this.currentRowCharLens[index] = 0;
        }
    }

    void setJsonInternal(int paramIndex, Object obj) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = obj == null ? new JsonNullBinder() : new JsonBinder(this.convertToOson(obj));
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
    }

    private byte[] convertToOson(Object obj) throws SQLException {
        OracleJsonFactory factory = this.connection.getOracleJsonFactory();
        OsonConverter osonConverter = this.connection.getOsonConverter();
        if (obj instanceof InputStream) {
            return this.convertByteArrayToOson(this.readStream((InputStream)obj), factory);
        }
        if (obj instanceof byte[]) {
            return this.convertByteArrayToOson((byte[])obj, factory);
        }
        ByteArrayOutputStream out = this.connection.osonSerializerStream;
        try {
            OracleJsonGenerator generator = factory.createJsonBinaryGenerator(out);
            if (obj instanceof OracleJsonValue) {
                generator.write((OracleJsonValue)obj);
                generator.close();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            if (obj instanceof OracleJsonParser) {
                generator.writeParser(obj);
                generator.close();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            if (obj instanceof CharSequence) {
                StringReader reader = new StringReader(((CharSequence)obj).toString());
                OracleJsonParser parser = factory.createJsonTextParser(reader);
                generator.writeParser(parser);
                parser.hasNext();
                generator.close();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            if (obj instanceof Reader) {
                OracleJsonParser parser = factory.createJsonTextParser((Reader)obj);
                generator.writeParser(parser);
                parser.hasNext();
                generator.close();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            if (PhysicalConnection.isJakartaJarPresent() && this.writeJakarta(generator, obj)) {
                generator.close();
                byte[] parser = out.toByteArray();
                return parser;
            }
            if (PhysicalConnection.isJsonJarPresent() && this.writeJsonp(generator, obj)) {
                generator.close();
                byte[] parser = out.toByteArray();
                return parser;
            }
            if (obj instanceof OracleJsonDatum) {
                OracleJsonDatum datum = (OracleJsonDatum)obj;
                byte[] byArray = datum.shareBytes();
                return byArray;
            }
            if (!osonConverter.equals(DefaultJsonProvider.NO_OP_OSON_CONVERTER)) {
                osonConverter.serialize(generator, obj);
                generator.close();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            catch (OracleJsonException e) {
                throw this.toSQLException(e);
            }
        }
        finally {
            out.reset();
        }
    }

    private boolean writeJsonp(OracleJsonGenerator generator, Object obj) throws SQLException {
        block4: {
            try {
                if (obj instanceof JsonValue) {
                    generator.wrap(javax.json.stream.JsonGenerator.class).write((JsonValue)obj);
                    break block4;
                }
                if (obj instanceof javax.json.stream.JsonParser) {
                    generator.writeParser(obj);
                    break block4;
                }
                return false;
            }
            catch (RuntimeException e) {
                throw this.toSQLException(e);
            }
        }
        return true;
    }

    private boolean writeJakarta(OracleJsonGenerator generator, Object obj) throws SQLException {
        block4: {
            try {
                if (obj instanceof jakarta.json.JsonValue) {
                    generator.wrap(JsonGenerator.class).write((jakarta.json.JsonValue)obj);
                    break block4;
                }
                if (obj instanceof JsonParser) {
                    generator.writeParser(obj);
                    break block4;
                }
                return false;
            }
            catch (RuntimeException e) {
                throw this.toSQLException(e);
            }
        }
        return true;
    }

    private byte[] convertByteArrayToOson(byte[] bytes, OracleJsonFactory factory) throws SQLException {
        if (this.isOsonArray(bytes)) {
            return bytes;
        }
        ByteArrayOutputStream out = this.connection.osonSerializerStream;
        try {
            OracleJsonGenerator generator = factory.createJsonBinaryGenerator(out);
            OracleJsonParser parser = factory.createJsonTextParser(new ByteArrayInputStream(bytes));
            generator.writeParser(parser);
            parser.hasNext();
            generator.close();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (RuntimeException e) {
            throw this.toSQLException(e);
        }
        finally {
            out.reset();
        }
    }

    private byte[] readStream(InputStream is) throws SQLException {
        try {
            int n;
            byte[] buffer = new byte[8192];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((n = is.read(buffer)) != -1) {
                baos.write(buffer, 0, n);
            }
            return baos.toByteArray();
        }
        catch (IOException ioEx) {
            throw this.toSQLException(ioEx);
        }
    }

    private SQLException toSQLException(Exception e) {
        return (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
    }

    private boolean isOsonArray(byte[] src) {
        return src.length > OsonConstants.MAGIC_BYTES.length && src[0] == OsonConstants.MAGIC_BYTES[0] && src[1] == OsonConstants.MAGIC_BYTES[1] && src[2] == OsonConstants.MAGIC_BYTES[2];
    }

    @Override
    public void setBlob(int paramIndex, Blob lob) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setBLOBInternal(paramIndex, (oracle.jdbc.internal.OracleBlob)lob);
        }
    }

    void setBlobInternal(int paramIndex, Blob lob) throws SQLException {
        this.setBLOBInternal(paramIndex, (oracle.jdbc.internal.OracleBlob)lob);
    }

    @Override
    public void setCLOB(int paramIndex, CLOB lob) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setFormOfUseInternal(paramIndex, this.defaultFormOfUse);
            this.setCLOBInternal(paramIndex, lob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCLOBInternal(int paramIndex, oracle.jdbc.internal.OracleClob lob) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (lob == null) {
            this.currentRowBinders[index] = new ClobNullBinder();
        } else {
            byte[] locator = lob.getBytes();
            if (PhysicalConnection.isQuasiLocator(locator)) {
                ByteBuffer lobData;
                OracleLargeObject.PrefetchData<char[]> prefetchData = lob.getPrefetchData();
                int clobDataLength = prefetchData.length();
                char[] clobData = this.connection.getCharBuffer(clobDataLength);
                try {
                    prefetchData.copy(0, clobData, 0, clobDataLength);
                    lobData = this.connection.convertClobDataInNetworkCharSet(lob, clobData, clobDataLength);
                }
                finally {
                    this.connection.cacheBuffer(clobData);
                }
                this.currentRowBinders[index] = new ClobBinder(locator, lobData);
            } else {
                this.currentRowBinders[index] = new ClobBinder(locator);
            }
        }
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
    }

    @Override
    public void setClob(int paramIndex, Clob lob) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setFormOfUseInternal(paramIndex, this.defaultFormOfUse);
            this.setCLOBInternal(paramIndex, (oracle.jdbc.internal.OracleClob)lob);
        }
    }

    void setClobInternal(int paramIndex, Clob lob) throws SQLException {
        this.setCLOBInternal(paramIndex, (oracle.jdbc.internal.OracleClob)lob);
    }

    @Override
    public void setBFILE(int paramIndex, BFILE file) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setBFILEInternal(paramIndex, file);
        }
    }

    void setBFILEInternal(int paramIndex, oracle.jdbc.internal.OracleBfile file) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = file == null ? new BfileNullBinder() : new BfileBinder(file.getBytes());
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
    }

    @Override
    public void setBfile(int paramIndex, BFILE file) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setBFILEInternal(paramIndex, file);
        }
    }

    void setBfileInternal(int paramIndex, BFILE file) throws SQLException {
        this.setBFILEInternal(paramIndex, file);
    }

    @Override
    public void setBytes(int paramIndex, byte[] x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setBytesInternal(paramIndex, x);
        }
    }

    void setBytesInternal(int paramIndex, byte[] x) throws SQLException {
        int byteLength;
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        int n = byteLength = x != null ? x.length : 0;
        if (byteLength == 0) {
            this.setNullInternal(paramIndex, -2);
        } else if (this.sqlKind == OracleStatement.SqlKind.PLSQL_BLOCK) {
            if (byteLength > this.maxRawBytesPlsql) {
                this.setBytesForBlobCritical(paramIndex, x);
            } else {
                this.basicBindBytes(paramIndex, x);
            }
        } else if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK) {
            if (byteLength > this.maxRawBytesPlsql) {
                this.setBytesForBlobCritical(paramIndex, x);
            } else {
                this.basicBindBytes(paramIndex, x);
            }
        } else if (byteLength > this.maxRawBytesSql) {
            this.bindBytesAsStream(paramIndex, x);
        } else {
            this.basicBindBytes(paramIndex, x);
        }
        this.debugp(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setBytesInternal", null, "index={0},value={1}. ", null, () -> new Object[]{paramIndex, Arrays.toString(x)});
    }

    void bindBytesAsStream(int paramIndex, byte[] x) throws SQLException {
        int byteLength = x.length;
        byte[] bytebuf = new byte[byteLength];
        System.arraycopy(x, 0, bytebuf, 0, byteLength);
        this.basicBindBinaryStream(paramIndex, new ByteArrayInputStream(bytebuf), byteLength, true);
    }

    void basicBindBytes(int paramIndex, byte[] x) throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        int index = paramIndex - 1;
        DatumBinder binder = this.sqlKind.isPlsqlOrCall() ? new PlsqlRawBinder(x) : new RawBinder(x);
        this.currentRowBinders[index] = binder;
        this.currentRowByteLens[index] = x.length;
        this.currentRowCharLens[index] = 0;
    }

    void basicBindBinaryStream(int paramIndex, InputStream istream, int length) throws SQLException {
        this.basicBindBinaryStream(paramIndex, istream, length, false);
    }

    void basicBindBinaryStream(int paramIndex, InputStream istream, int length, boolean isInternal) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int index = paramIndex - 1;
            this.currentRowBinders[index] = isInternal ? this.theLongRawStreamForBytesBinder : this.theLongRawStreamBinder;
            if (this.parameterStream == null) {
                this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterStream[this.currentRank][index] = isInternal ? this.connection.conversion.ConvertStreamInternal(istream, 6, length) : this.connection.conversion.ConvertStream(istream, 6, length, this.connection);
            this.currentRowByteLens[index] = 0;
            this.currentRowCharLens[index] = 0;
        }
    }

    @Override
    public void setBytesForBlob(int paramIndex, byte[] x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (x == null) {
                this.setNull(paramIndex, -2);
                return;
            }
            int arrayLength = x.length;
            if (arrayLength == 0) {
                this.setNull(paramIndex, -2);
                return;
            }
            if (this.sqlKind.isPlsqlOrCall()) {
                if (arrayLength <= this.maxRawBytesPlsql) {
                    this.setBytes(paramIndex, x);
                } else {
                    this.setBytesForBlobCritical(paramIndex, x);
                }
            } else if (arrayLength <= this.maxRawBytesSql) {
                this.setBytes(paramIndex, x);
            } else {
                this.setBytesForBlobCritical(paramIndex, x);
            }
        }
    }

    void setBytesForBlobCritical(int paramIndex, byte[] x) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setBytesForBlobCritical", (String)null, "index={0}, value={1}. ", null, (Object)paramIndex, (Object)Arrays.toString(x));
        BLOB tblob = this.createTemporaryBlobInternal();
        tblob.setBytes(1L, x);
        this.lastBoundBlobs[paramIndex - 1] = tblob;
        this.setBLOBInternal(paramIndex, tblob);
    }

    final BLOB createTemporaryBlobInternal() throws SQLException {
        BLOB tblob = BLOB.createTemporary(this.connection, true, 10);
        this.addToTempLobsToFree(tblob);
        return tblob;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setBinaryStreamContentsForBlobCritical(int paramIndex, InputStream inputStream, long length, boolean isLengthSpecified) throws SQLException {
        int retByte;
        long lengthRemaining;
        byte[] bytebuf;
        int bufferSize;
        OracleBlobOutputStream outputStream;
        BLOB tblob;
        Monitor.CloseableLock lock;
        block15: {
            long l;
            block14: {
                lock = this.connection.acquireCloseableLock();
                try {
                    inputStream = this.isInputStreamEmpty(inputStream);
                    if (inputStream == null) {
                        if (isLengthSpecified) {
                            throw new SQLException(length + " byte of BLOB data cannot be read");
                        }
                        this.setBLOBInternal(paramIndex, null);
                        return;
                    }
                    tblob = BLOB.createTemporary(this.connection, true, 10);
                    outputStream = (OracleBlobOutputStream)tblob.setBinaryStream(1L);
                    bufferSize = tblob.getBufferSize();
                    bytebuf = new byte[bufferSize];
                    lengthRemaining = 0L;
                    retByte = 0;
                    if (!isLengthSpecified) break block14;
                }
                catch (IOException x) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), x).fillInStackTrace();
                }
                l = length;
                break block15;
            }
            l = Long.MAX_VALUE;
        }
        try {
            for (lengthRemaining = v413300; lengthRemaining > 0L; lengthRemaining -= (long)retByte) {
                retByte = lengthRemaining >= (long)bufferSize ? inputStream.read(bytebuf) : inputStream.read(bytebuf, 0, (int)lengthRemaining);
                if (retByte == -1) {
                    if (!isLengthSpecified) break;
                    throw new SQLException(lengthRemaining + " byte of BLOB data cannot be read");
                }
                outputStream.write(bytebuf, 0, retByte);
            }
            outputStream.flush();
        }
        catch (IOException x) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), x).fillInStackTrace();
        }
        this.addToTempLobsToFree(tblob);
        this.lastBoundBlobs[paramIndex - 1] = tblob;
        this.setBLOBInternal(paramIndex, tblob);
        return;
        finally {
            if (lock != null) {
                lock.close();
            }
        }
    }

    @Override
    public void setBytesForBlobAtName(String paramName, byte[] x) throws SQLException {
        if (paramName == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        String iName = paramName.intern();
        String[] names = this.sqlObject.getParameterList();
        boolean nameMatchedAtLeastOnce = false;
        int count = Math.min(this.sqlObject.getParameterCount(), names.length);
        for (int i = 0; i < count; ++i) {
            if (names[i] != iName) continue;
            this.setBytesForBlob(i + 1, x);
            nameMatchedAtLeastOnce = true;
        }
        if (!nameMatchedAtLeastOnce) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
        }
    }

    @Override
    public void setInternalBytes(int paramIndex, byte[] x, int dbtype) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setInternalBytesInternal(paramIndex, x, dbtype);
        }
    }

    void setInternalBytesInternal(int paramIndex, byte[] x, int dbtype) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("setInternalBytesInternal").fillInStackTrace();
    }

    @Override
    public void setDate(int paramIndex, Date x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setDATEInternal(paramIndex, x == null ? null : new DATE(x, this.getDefaultCalendar()));
        }
    }

    void setDateInternal(int paramIndex, Date x) throws SQLException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setDateInternal(int, Date)", (String)null, "index={0}, value={1}. ", null, (Object)paramIndex, (Object)x);
        this.setDATEInternal(paramIndex, x == null ? null : new DATE(x, this.getDefaultCalendar()));
    }

    @Override
    public void setTime(int paramIndex, Time x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setTimeInternal(paramIndex, x);
        }
    }

    void setTimeInternal(int paramIndex, Time x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = x == null ? new DateNullBinder() : new TimeBinder(x);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setTimeInternal", (String)null, "index={0}, value={1}. ", null, (Object)index, (Object)x);
    }

    @Override
    public void setTimestamp(int paramIndex, Timestamp x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setTimestampInternal(paramIndex, x);
        }
    }

    void setTimestampInternal(int paramIndex, Timestamp x) throws SQLException {
        this.setTimestampInternal(paramIndex, x, -1);
    }

    void setTimestampInternal(int paramIndex, Timestamp x, int scale) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setTimeInternal(int, Timestamp, int)", (String)null, "index={0}, value={1}, scale={2}. ", null, (Object)index, (Object)x, (Object)scale);
        this.currentRowBinders[index] = x == null ? new TimestampNullBinder(scale) : new TimestampBinder(x, scale);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
    }

    @Override
    public void setINTERVALYM(int paramIndex, INTERVALYM x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setINTERVALYMInternal(paramIndex, x);
        }
    }

    void setINTERVALYMInternal(int paramIndex, INTERVALYM x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = x == null ? new IntervalYMNullBinder() : new IntervalYMBinder(x.getBytes());
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
    }

    @Override
    public void setINTERVALDS(int paramIndex, INTERVALDS x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setINTERVALDSInternal(paramIndex, x);
        }
    }

    void setINTERVALDSInternal(int paramIndex, INTERVALDS x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = x == null ? new IntervalDSNullBinder() : new IntervalDSBinder(x.getBytes());
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
    }

    @Override
    public void setTIMESTAMP(int paramIndex, TIMESTAMP x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setTIMESTAMPInternal(paramIndex, x, -1);
        }
    }

    void setTIMESTAMPInternal(int paramIndex, TIMESTAMP x) throws SQLException {
        this.setTIMESTAMPInternal(paramIndex, x, -1);
    }

    void setTIMESTAMPInternal(int paramIndex, TIMESTAMP x, int scale) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = x == null ? new TimestampNullBinder(scale) : new OracleTimestampBinder(x.getBytes(), scale);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
    }

    @Override
    public void setTIMESTAMPTZ(int paramIndex, TIMESTAMPTZ x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setTIMESTAMPTZInternal(paramIndex, x);
        }
    }

    void setTIMESTAMPTZInternal(int paramIndex, TIMESTAMPTZ x) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = x == null ? new TSTZNullBinder() : new TSTZBinder(x.getBytes());
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
    }

    @Override
    public void setTIMESTAMPLTZ(int paramIndex, TIMESTAMPLTZ x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setTIMESTAMPLTZInternal(paramIndex, x);
        }
    }

    void setTIMESTAMPLTZInternal(int paramIndex, TIMESTAMPLTZ x) throws SQLException {
        if (this.connection.getSessionTimeZone() == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 105).fillInStackTrace();
        }
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = x == null ? new TSLTZNullBinder() : new TSLTZBinder(x.getBytes());
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
    }

    private Reader isReaderEmpty(Reader rd) throws IOException {
        if (!rd.markSupported()) {
            rd = new BufferedReader(rd, 4096);
        }
        rd.mark(10);
        if (rd.read() == -1) {
            return null;
        }
        rd.reset();
        return rd;
    }

    private InputStream isInputStreamEmpty(InputStream is) throws IOException {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is, 4096);
        }
        is.mark(10);
        if (is.read() == -1) {
            return null;
        }
        is.reset();
        return is;
    }

    @Override
    public void setAsciiStream(int paramIndex, InputStream istream, int length) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (length < 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setAsciiStream cannot be negative").fillInStackTrace();
            }
            this.setAsciiStreamInternal(paramIndex, istream, length);
        }
    }

    void setAsciiStreamInternal(int paramIndex, InputStream istream, int length) throws SQLException {
        this.setAsciiStreamInternal(paramIndex, istream, length, true);
    }

    void setAsciiStreamInternal(int paramIndex, InputStream istream, long length, boolean isLengthSpecified) throws SQLException {
        int index = paramIndex - 1;
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (index < 0 || paramIndex > this.numberOfBindPositions) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (isLengthSpecified && length < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 43).fillInStackTrace();
            }
            this.checkUserStreamForDuplicates(istream, index);
            if (istream == null || isLengthSpecified && length == 0L) {
                this.basicBindNullString(paramIndex);
            } else {
                if (!(this.userRsetType == DEFAULT_RESULT_SET_TYPE || length <= (long)this.maxVcsCharsSql && isLengthSpecified)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 169).fillInStackTrace();
                }
                if (!isLengthSpecified) {
                    this.setAsciiStreamContentsForClobCritical(paramIndex, istream, length, isLengthSpecified);
                } else if (this.currentRowFormOfUse[index] == 1) {
                    if (this.sqlKind.isPlsqlOrCall()) {
                        if (length <= (long)this.maxVcsCharsPlsql) {
                            this.setAsciiStreamContentsForStringInternal(paramIndex, istream, (int)length);
                        } else {
                            this.setAsciiStreamContentsForClobCritical(paramIndex, istream, length, isLengthSpecified);
                        }
                    } else if (length <= (long)this.maxVcsCharsSql) {
                        this.setAsciiStreamContentsForStringInternal(paramIndex, istream, (int)length);
                    } else if (length > Integer.MAX_VALUE) {
                        this.setAsciiStreamContentsForClobCritical(paramIndex, istream, length, isLengthSpecified);
                    } else {
                        this.basicBindAsciiStream(paramIndex, istream, (int)length);
                    }
                } else if (this.sqlKind.isPlsqlOrCall()) {
                    if (length <= (long)this.maxVcsNCharsPlsql) {
                        this.setAsciiStreamContentsForStringInternal(paramIndex, istream, (int)length);
                    } else {
                        this.setAsciiStreamContentsForClobCritical(paramIndex, istream, length, isLengthSpecified);
                    }
                } else if (length <= (long)this.maxVcsNCharsSql) {
                    this.setAsciiStreamContentsForStringInternal(paramIndex, istream, (int)length);
                } else {
                    this.setAsciiStreamContentsForClobCritical(paramIndex, istream, length, isLengthSpecified);
                }
            }
        }
    }

    void basicBindAsciiStream(int paramIndex, InputStream istream, int length) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.userRsetType != DEFAULT_RESULT_SET_TYPE) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 169).fillInStackTrace();
            }
            int index = paramIndex - 1;
            this.currentRowBinders[index] = this.theLongStreamBinder;
            if (this.parameterStream == null) {
                this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterStream[this.currentRank][index] = this.connection.conversion.ConvertStream(istream, 5, length, this.connection);
            this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
            this.currentRowCharLens[index] = 0;
        }
    }

    void setAsciiStreamContentsForStringInternal(int paramIndex, InputStream istream, int length) throws SQLException {
        byte[] bytebuf = new byte[length];
        int actual_length = 0;
        try {
            int read_length;
            for (int length_remaining = length; length_remaining > 0 && (read_length = istream.read(bytebuf, actual_length, length_remaining)) != -1; length_remaining -= read_length) {
                actual_length += read_length;
            }
        }
        catch (IOException e) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
        }
        char[] charbuf = new char[length];
        DBConversion.asciiBytesToJavaChars(bytebuf, actual_length, charbuf);
        this.basicBindString(paramIndex, new String(charbuf));
    }

    @Override
    public void setBinaryStream(int paramIndex, InputStream istream, int length) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (length < 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setBinaryStream cannot be negative").fillInStackTrace();
            }
            this.setBinaryStreamInternal(paramIndex, istream, length);
        }
    }

    void setBinaryStreamInternal(int paramIndex, InputStream istream, int length) throws SQLException {
        this.setBinaryStreamInternal(paramIndex, istream, length, true);
    }

    void checkUserStreamForDuplicates(Object streamOrReader, int index) throws SQLException {
        if (streamOrReader == null) {
            return;
        }
        if (this.userStream != null) {
            Object[][] objectArray = this.userStream;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object[] o;
                for (Object oo : o = objectArray[i]) {
                    if (oo != streamOrReader) continue;
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 270, (Object)(index + 1)).fillInStackTrace();
                }
            }
        } else {
            this.userStream = new Object[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.userStream[this.currentRank][index] = streamOrReader;
    }

    void setBinaryStreamInternal(int paramIndex, InputStream istream, long length, boolean isLengthSpecified) throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.checkUserStreamForDuplicates(istream, index);
        if (istream == null) {
            this.setRAWInternal(paramIndex, null);
        } else {
            if (!(this.userRsetType == DEFAULT_RESULT_SET_TYPE || length <= (long)this.maxRawBytesSql && isLengthSpecified)) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 169).fillInStackTrace();
            }
            if (!isLengthSpecified) {
                this.setBinaryStreamContentsForBlobCritical(paramIndex, istream, length, isLengthSpecified);
            } else if (this.sqlKind.isPlsqlOrCall()) {
                if (length > (long)this.maxRawBytesPlsql) {
                    this.setBinaryStreamContentsForBlobCritical(paramIndex, istream, length, isLengthSpecified);
                } else {
                    this.setBinaryStreamContentsForByteArrayInternal(paramIndex, istream, (int)length);
                }
            } else if (length > Integer.MAX_VALUE) {
                this.setBinaryStreamContentsForBlobCritical(paramIndex, istream, length, isLengthSpecified);
            } else if (length > (long)this.maxRawBytesSql) {
                this.basicBindBinaryStream(paramIndex, istream, (int)length);
            } else {
                this.setBinaryStreamContentsForByteArrayInternal(paramIndex, istream, (int)length);
            }
        }
    }

    void setBinaryStreamContentsForByteArrayInternal(int paramIndex, InputStream inputStream, int length) throws SQLException {
        byte[] bytebuf = new byte[length];
        int actual_length = 0;
        try {
            int read_length;
            for (int length_remaining = length; length_remaining > 0 && (read_length = inputStream.read(bytebuf, actual_length, length_remaining)) != -1; length_remaining -= read_length) {
                actual_length += read_length;
            }
        }
        catch (IOException e) {
            SQLException sqlEx = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 266).fillInStackTrace();
            sqlEx.initCause(e);
            throw sqlEx;
        }
        if (actual_length != length) {
            byte[] newbuf = new byte[actual_length];
            System.arraycopy(bytebuf, 0, newbuf, 0, actual_length);
            bytebuf = newbuf;
        }
        this.setBytesInternal(paramIndex, bytebuf);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int paramIndex, InputStream istream, int length) throws SQLException {
        if (length < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setUnicodeStream cannot be negative").fillInStackTrace();
        }
        this.setUnicodeStreamInternal(paramIndex, istream, length);
    }

    void setUnicodeStreamInternal(int paramIndex, InputStream istream, int length) throws SQLException {
        block14: {
            try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                int index = paramIndex - 1;
                if (index < 0 || paramIndex > this.numberOfBindPositions) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
                }
                this.checkUserStreamForDuplicates(istream, index);
                if (istream == null) {
                    this.setStringInternal(paramIndex, null);
                    break block14;
                }
                if (this.userRsetType != DEFAULT_RESULT_SET_TYPE && length > this.maxVcsCharsSql) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 169).fillInStackTrace();
                }
                if (this.sqlKind.isPlsqlOrCall() || length <= this.maxVcsCharsSql) {
                    byte[] bytebuf = new byte[length];
                    int actual_length = 0;
                    try {
                        int read_length;
                        for (int length_remaining = length; length_remaining > 0 && (read_length = istream.read(bytebuf, actual_length, length_remaining)) != -1; length_remaining -= read_length) {
                            actual_length += read_length;
                        }
                    }
                    catch (IOException e) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
                    }
                    char[] charbuf = new char[actual_length >> 1];
                    DBConversion.ucs2BytesToJavaChars(bytebuf, actual_length, charbuf);
                    this.setStringInternal(paramIndex, new String(charbuf));
                    break block14;
                }
                this.currentRowBinders[index] = this.theLongStreamBinder;
                if (this.parameterStream == null) {
                    this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
                }
                this.parameterStream[this.currentRank][index] = this.connection.conversion.ConvertStream(istream, 4, length, this.connection);
                this.currentRowByteLens[index] = 0;
                this.currentRowCharLens[index] = 0;
            }
        }
    }

    @Override
    @Deprecated
    public void setCustomDatum(int paramIndex, CustomDatum x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (x == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            this.setObjectInternal(paramIndex, this.connection.toDatum(x));
        }
    }

    void setCustomDatumInternal(int paramIndex, CustomDatum x) throws SQLException {
        PhysicalConnection c2;
        PhysicalConnection c1;
        if (x == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        PhysicalConnection phys = this.connection;
        if (x instanceof DatumWithConnection) {
            phys = (PhysicalConnection)((DatumWithConnection)((Object)x)).getPhysicalConnection();
        }
        if (phys == null || this.connection == phys) {
            try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                Datum datum = this.connection.toDatum(x);
                int sqlType = this.sqlTypeForObject(datum);
                this.setObjectCritical(paramIndex, datum, sqlType, 0);
            }
        }
        this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "setCustomDatumInternal", "CustomDatum created by one OracleConnection was used by a different OracleConnection. ", null, null);
        if (this.connection.hashCode() < phys.hashCode()) {
            c1 = this.connection;
            c2 = phys;
        } else {
            c1 = phys;
            c2 = this.connection;
        }
        try (Monitor.CloseableLock lock1 = c1.acquireCloseableLock();
             Monitor.CloseableLock lock2 = c2.acquireCloseableLock();){
            Datum datum = this.connection.toDatum(x);
            int sqlType = this.sqlTypeForObject(datum);
            this.setObjectCritical(paramIndex, datum, sqlType, 0);
        }
    }

    @Override
    public void setORAData(int paramIndex, ORAData x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (x == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            this.setORADataInternal(paramIndex, x);
        }
    }

    void setORADataInternal(int paramIndex, ORAData x) throws SQLException {
        if (x == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        Datum datum = x.toDatum(this.connection);
        int sqlType = this.sqlTypeForObject(datum);
        this.setObjectCritical(paramIndex, datum, sqlType, 0);
        if (sqlType == 2002 || sqlType == 2008 || sqlType == 2003) {
            this.currentRowCharLens[paramIndex - 1] = 0;
        }
    }

    void setOracleDataInternal(int paramIndex, OracleData x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Object jdbcObject = x.toJDBCObject(this.connection);
            if (jdbcObject instanceof _Proxy_) {
                final _Proxy_ proxiedJDBCObject = (_Proxy_)jdbcObject;
                jdbcObject = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return ProxyFactory.extractDelegate(proxiedJDBCObject);
                    }
                });
            }
            int sqlType = this.sqlTypeForObject(jdbcObject);
            this.setObjectCritical(paramIndex, jdbcObject, sqlType, 0);
            if (sqlType == 2002 || sqlType == 2008 || sqlType == 2003) {
                this.currentRowCharLens[paramIndex - 1] = 0;
            }
        }
    }

    @Override
    public void setObject(int paramIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setObjectInternal(paramIndex, x, targetSqlType, scale);
        }
    }

    void setObjectInternal(int paramIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (x == null && targetSqlType != 2002 && targetSqlType != 2008 && targetSqlType != 2003 && targetSqlType != 2007 && targetSqlType != 2006 && targetSqlType != 93 && targetSqlType != 2009) {
            this.setNullInternal(paramIndex, targetSqlType);
        } else if (x instanceof TTCData) {
            this.setTTCData(paramIndex, (TTCData)x);
        } else if (targetSqlType == 2002 || targetSqlType == 2008 || targetSqlType == 2003 || targetSqlType == 2009) {
            this.setObjectCritical(paramIndex, x, targetSqlType, scale);
            this.currentRowCharLens[paramIndex - 1] = 0;
        } else {
            this.setObjectCritical(paramIndex, x, targetSqlType, scale);
        }
    }

    void setObjectCritical(int paramIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            switch (targetSqlType) {
                case -15: {
                    this.setFormOfUseInternal(paramIndex, (short)2);
                }
                case 1: {
                    if (x instanceof CHAR) {
                        this.setCHARInternal(paramIndex, (CHAR)x);
                        break;
                    }
                    if (x instanceof String) {
                        this.setFixedCHARInternal(paramIndex, (String)x);
                        break;
                    }
                    if (x instanceof Boolean) {
                        this.setStringInternal(paramIndex, "" + ((Boolean)x != false ? 1 : 0));
                        break;
                    }
                    if (x instanceof Integer) {
                        this.setStringInternal(paramIndex, "" + (Integer)x);
                        break;
                    }
                    if (x instanceof Long) {
                        this.setStringInternal(paramIndex, "" + (Long)x);
                        break;
                    }
                    if (x instanceof Float) {
                        this.setStringInternal(paramIndex, "" + ((Float)x).floatValue());
                        break;
                    }
                    if (x instanceof Double) {
                        this.setStringInternal(paramIndex, "" + (Double)x);
                        break;
                    }
                    if (x instanceof BigDecimal) {
                        this.setStringInternal(paramIndex, ((BigDecimal)x).toString());
                        break;
                    }
                    if (x instanceof Date) {
                        this.setStringInternal(paramIndex, ((Date)x).toString());
                        break;
                    }
                    if (x instanceof Time) {
                        this.setStringInternal(paramIndex, ((Time)x).toString());
                        break;
                    }
                    if (x instanceof Timestamp) {
                        this.setStringInternal(paramIndex, ((Timestamp)x).toString());
                        break;
                    }
                    if (x instanceof URL) {
                        this.setStringInternal(paramIndex, ((URL)x).toString());
                        break;
                    }
                    this.setStringInternal(paramIndex, JavaToJavaConverter.convert(x, String.class, this.connection, scale, null));
                    break;
                }
                case -9: {
                    this.setFormOfUseInternal(paramIndex, (short)2);
                }
                case 12: {
                    if (x instanceof String) {
                        this.setStringInternal(paramIndex, (String)x);
                        break;
                    }
                    if (x instanceof Boolean) {
                        this.setStringInternal(paramIndex, "" + ((Boolean)x != false ? 1 : 0));
                        break;
                    }
                    if (x instanceof Integer) {
                        this.setStringInternal(paramIndex, "" + (Integer)x);
                        break;
                    }
                    if (x instanceof Long) {
                        this.setStringInternal(paramIndex, "" + (Long)x);
                        break;
                    }
                    if (x instanceof Float) {
                        this.setStringInternal(paramIndex, "" + ((Float)x).floatValue());
                        break;
                    }
                    if (x instanceof Double) {
                        this.setStringInternal(paramIndex, "" + (Double)x);
                        break;
                    }
                    if (x instanceof BigDecimal) {
                        this.setStringInternal(paramIndex, ((BigDecimal)x).toString());
                        break;
                    }
                    if (x instanceof Date) {
                        this.setStringInternal(paramIndex, ((Date)x).toString());
                        break;
                    }
                    if (x instanceof Time) {
                        this.setStringInternal(paramIndex, ((Time)x).toString());
                        break;
                    }
                    if (x instanceof Timestamp) {
                        this.setStringInternal(paramIndex, ((Timestamp)x).toString());
                        break;
                    }
                    if (x instanceof URL) {
                        this.setStringInternal(paramIndex, ((URL)x).toString());
                        break;
                    }
                    this.setStringInternal(paramIndex, JavaToJavaConverter.convert(x, String.class, this.connection, scale, null));
                    break;
                }
                case 999: {
                    this.setFixedCHARInternal(paramIndex, (String)x);
                    break;
                }
                case -16: {
                    this.setFormOfUseInternal(paramIndex, (short)2);
                }
                case -1: {
                    if (x instanceof String) {
                        this.setStringInternal(paramIndex, (String)x);
                        break;
                    }
                    if (x instanceof Boolean) {
                        this.setStringInternal(paramIndex, "" + ((Boolean)x != false ? 1 : 0));
                        break;
                    }
                    if (x instanceof Integer) {
                        this.setStringInternal(paramIndex, "" + (Integer)x);
                        break;
                    }
                    if (x instanceof Long) {
                        this.setStringInternal(paramIndex, "" + (Long)x);
                        break;
                    }
                    if (x instanceof Float) {
                        this.setStringInternal(paramIndex, "" + ((Float)x).floatValue());
                        break;
                    }
                    if (x instanceof Double) {
                        this.setStringInternal(paramIndex, "" + (Double)x);
                        break;
                    }
                    if (x instanceof BigDecimal) {
                        this.setStringInternal(paramIndex, ((BigDecimal)x).toString());
                        break;
                    }
                    if (x instanceof Date) {
                        this.setStringInternal(paramIndex, ((Date)x).toString());
                        break;
                    }
                    if (x instanceof Time) {
                        this.setStringInternal(paramIndex, ((Time)x).toString());
                        break;
                    }
                    if (x instanceof Timestamp) {
                        this.setStringInternal(paramIndex, ((Timestamp)x).toString());
                        break;
                    }
                    if (x instanceof URL) {
                        this.setStringInternal(paramIndex, ((URL)x).toString());
                        break;
                    }
                    this.setStringInternal(paramIndex, JavaToJavaConverter.convert(x, String.class, this.connection, scale, null));
                    break;
                }
                case 2: {
                    if (x instanceof NUMBER) {
                        this.setNUMBERInternal(paramIndex, (NUMBER)x);
                        break;
                    }
                    if (x instanceof Integer) {
                        this.setIntInternal(paramIndex, (Integer)x);
                        break;
                    }
                    if (x instanceof Long) {
                        this.setLongInternal(paramIndex, (Long)x);
                        break;
                    }
                    if (x instanceof Float) {
                        this.setFloatInternal(paramIndex, ((Float)x).floatValue());
                        break;
                    }
                    if (x instanceof Double) {
                        this.setDoubleInternal(paramIndex, (Double)x);
                        break;
                    }
                    if (x instanceof BigDecimal) {
                        this.setBigDecimalInternal(paramIndex, (BigDecimal)x);
                        break;
                    }
                    if (x instanceof BigInteger) {
                        this.setBigDecimalInternal(paramIndex, new BigDecimal((BigInteger)x));
                        break;
                    }
                    if (x instanceof String) {
                        this.setNUMBERInternal(paramIndex, new NUMBER((String)x, scale));
                        break;
                    }
                    if (x instanceof Boolean) {
                        this.setIntInternal(paramIndex, (Boolean)x != false ? 1 : 0);
                        break;
                    }
                    if (x instanceof Short) {
                        this.setShortInternal(paramIndex, (Short)x);
                        break;
                    }
                    if (x instanceof Byte) {
                        this.setByteInternal(paramIndex, (Byte)x);
                        break;
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132).fillInStackTrace();
                }
                case 3: {
                    if (x instanceof BigDecimal) {
                        this.setBigDecimalInternal(paramIndex, (BigDecimal)x);
                        break;
                    }
                    if (x instanceof Number) {
                        this.setBigDecimalInternal(paramIndex, new BigDecimal(((Number)x).doubleValue()));
                        break;
                    }
                    if (x instanceof NUMBER) {
                        this.setBigDecimalInternal(paramIndex, ((NUMBER)x).bigDecimalValue());
                        break;
                    }
                    if (x instanceof String) {
                        this.setBigDecimalInternal(paramIndex, new BigDecimal((String)x));
                        break;
                    }
                    if (x instanceof Boolean) {
                        this.setBigDecimalInternal(paramIndex, new BigDecimal((Boolean)x != false ? 1.0 : 0.0));
                        break;
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132).fillInStackTrace();
                }
                case -7: {
                    if (x instanceof Boolean) {
                        this.setByteInternal(paramIndex, (byte)((Boolean)x != false ? 1 : 0));
                        break;
                    }
                    if (x instanceof String) {
                        this.setByteInternal(paramIndex, (byte)("true".equalsIgnoreCase((String)x) || "1".equals(x) ? 1 : 0));
                        break;
                    }
                    if (x instanceof Number) {
                        this.setIntInternal(paramIndex, ((Number)x).byteValue() != 0 ? 1 : 0);
                        break;
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132).fillInStackTrace();
                }
                case 252: {
                    if (this.connection.databaseMetaData.getDatabaseMajorVersion() < 12 || this.connection.databaseMetaData.getDatabaseMajorVersion() == 12 && this.connection.databaseMetaData.getDatabaseMinorVersion() < 1) {
                        throw (SQLException)DatabaseError.createSqlException(299).fillInStackTrace();
                    }
                    if (x instanceof BOOLEAN) {
                        x = ((BOOLEAN)x).toBooleanValue();
                    }
                    this.setPlsqlBooleanInternal(paramIndex, (Boolean)x);
                    break;
                }
                case -6: {
                    if (x instanceof Number) {
                        this.setByteInternal(paramIndex, ((Number)x).byteValue());
                        break;
                    }
                    if (x instanceof String) {
                        this.setByteInternal(paramIndex, Byte.parseByte((String)x));
                        break;
                    }
                    if (x instanceof Boolean) {
                        this.setByteInternal(paramIndex, (byte)((Boolean)x != false ? 1 : 0));
                        break;
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132).fillInStackTrace();
                }
                case 5: {
                    if (x instanceof Number) {
                        this.setShortInternal(paramIndex, ((Number)x).shortValue());
                        break;
                    }
                    if (x instanceof String) {
                        this.setShortInternal(paramIndex, Short.parseShort((String)x));
                        break;
                    }
                    if (x instanceof Boolean) {
                        this.setShortInternal(paramIndex, (short)((Boolean)x != false ? 1 : 0));
                        break;
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132).fillInStackTrace();
                }
                case 4: {
                    if (x instanceof Number) {
                        this.setIntInternal(paramIndex, ((Number)x).intValue());
                        break;
                    }
                    if (x instanceof String) {
                        this.setIntInternal(paramIndex, Integer.parseInt((String)x));
                        break;
                    }
                    if (x instanceof Boolean) {
                        this.setIntInternal(paramIndex, (Boolean)x != false ? 1 : 0);
                        break;
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132).fillInStackTrace();
                }
                case -5: {
                    if (x instanceof Number) {
                        this.setLongInternal(paramIndex, ((Number)x).longValue());
                        break;
                    }
                    if (x instanceof String) {
                        this.setLongInternal(paramIndex, Long.parseLong((String)x));
                        break;
                    }
                    if (x instanceof Boolean) {
                        this.setLongInternal(paramIndex, (Boolean)x != false ? 1L : 0L);
                        break;
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132).fillInStackTrace();
                }
                case 7: {
                    if (x instanceof Number) {
                        this.setFloatInternal(paramIndex, ((Number)x).floatValue());
                        break;
                    }
                    if (x instanceof String) {
                        this.setFloatInternal(paramIndex, Float.valueOf((String)x).floatValue());
                        break;
                    }
                    if (x instanceof Boolean) {
                        this.setFloatInternal(paramIndex, (Boolean)x != false ? 1.0f : 0.0f);
                        break;
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132).fillInStackTrace();
                }
                case 6: 
                case 8: {
                    if (x instanceof Number) {
                        this.setDoubleInternal(paramIndex, ((Number)x).doubleValue());
                        break;
                    }
                    if (x instanceof String) {
                        this.setDoubleInternal(paramIndex, Double.valueOf((String)x));
                        break;
                    }
                    if (x instanceof Boolean) {
                        this.setDoubleInternal(paramIndex, (Boolean)x != false ? 1.0 : 0.0);
                        break;
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132).fillInStackTrace();
                }
                case -2: {
                    if (x instanceof RAW) {
                        this.setRAWInternal(paramIndex, (RAW)x);
                        break;
                    }
                    if (x instanceof LogicalTransactionId) {
                        this.setBytesInternal(paramIndex, ((LogicalTransactionId)x).getBytes());
                        break;
                    }
                    this.setBytesInternal(paramIndex, (byte[])x);
                    break;
                }
                case -3: {
                    this.setBytesInternal(paramIndex, (byte[])x);
                    break;
                }
                case -4: {
                    this.setBytesInternal(paramIndex, (byte[])x);
                    break;
                }
                case 91: {
                    if (x instanceof DATE) {
                        this.setDATEInternal(paramIndex, (DATE)x);
                        break;
                    }
                    if (x instanceof Date) {
                        this.setDATEInternal(paramIndex, new DATE(x, this.getDefaultCalendar()));
                        break;
                    }
                    if (x instanceof Timestamp) {
                        this.setDATEInternal(paramIndex, new DATE((Timestamp)x));
                        break;
                    }
                    if (x instanceof String) {
                        this.setDateInternal(paramIndex, Date.valueOf((String)x));
                        break;
                    }
                    this.setDATEInternal(paramIndex, JavaToJavaConverter.convert(x, DATE.class, this.connection, scale, null));
                    break;
                }
                case 92: {
                    if (x instanceof Time) {
                        this.setTimeInternal(paramIndex, (Time)x);
                        break;
                    }
                    Time time = x instanceof Timestamp ? new Time(((Timestamp)x).getTime()) : (x instanceof Date ? new Time(((Date)x).getTime()) : (x instanceof String ? OraclePreparedStatement.convertStringToTime(x.toString(), this.connection.use1900AsYearForTime) : JavaToJavaConverter.convert(x, Time.class, this.connection, scale, null)));
                    if (MAP_TIME_TO_TIMESTAMP) {
                        this.setTimestampInternal(paramIndex, new Timestamp(time.getTime()));
                        break;
                    }
                    this.setTimeInternal(paramIndex, time);
                    break;
                }
                case 93: {
                    if (x instanceof TIMESTAMP) {
                        this.setTIMESTAMPInternal(paramIndex, (TIMESTAMP)x, scale);
                        break;
                    }
                    if (x instanceof Timestamp) {
                        this.setTimestampInternal(paramIndex, (Timestamp)x, scale);
                        break;
                    }
                    if (x instanceof Date) {
                        this.setTIMESTAMPInternal(paramIndex, new TIMESTAMP((Date)x), scale);
                        break;
                    }
                    if (x instanceof DATE) {
                        this.setTIMESTAMPInternal(paramIndex, new TIMESTAMP(((DATE)x).timestampValue()), scale);
                        break;
                    }
                    if (x instanceof String) {
                        this.setTimestampInternal(paramIndex, Timestamp.valueOf((String)x), scale);
                        break;
                    }
                    this.setTIMESTAMPInternal(paramIndex, JavaToJavaConverter.convert(x, TIMESTAMP.class, this.connection, scale, null), scale);
                    break;
                }
                case -100: {
                    this.setTIMESTAMPInternal(paramIndex, (TIMESTAMP)x, scale);
                    break;
                }
                case -101: 
                case 2013: 
                case 2014: {
                    this.setTIMESTAMPTZInternal(paramIndex, JavaToJavaConverter.convert(x, TIMESTAMPTZ.class, this.connection, scale, null));
                    break;
                }
                case -102: {
                    this.setTIMESTAMPLTZInternal(paramIndex, JavaToJavaConverter.convert(x, TIMESTAMPLTZ.class, this.connection, scale, null));
                    break;
                }
                case -103: {
                    this.setINTERVALYMInternal(paramIndex, JavaToJavaConverter.convert(x, INTERVALYM.class, this.connection, scale, null));
                    break;
                }
                case -104: {
                    this.setINTERVALDSInternal(paramIndex, JavaToJavaConverter.convert(x, INTERVALDS.class, this.connection, scale, null));
                    break;
                }
                case -8: {
                    this.setROWIDInternal(paramIndex, (ROWID)x);
                    break;
                }
                case 100: {
                    if (x instanceof Float) {
                        this.setBinaryFloatInternal(paramIndex, new BINARY_FLOAT((Float)x));
                        break;
                    }
                    this.setBinaryFloatInternal(paramIndex, (BINARY_FLOAT)x);
                    break;
                }
                case 101: {
                    if (x instanceof Double) {
                        this.setBinaryDoubleInternal(paramIndex, new BINARY_DOUBLE((Double)x));
                        break;
                    }
                    this.setBinaryDoubleInternal(paramIndex, (BINARY_DOUBLE)x);
                    break;
                }
                case 2004: {
                    this.setBLOBInternal(paramIndex, (oracle.jdbc.internal.OracleBlob)x);
                    break;
                }
                case 2016: {
                    this.setJsonInternal(paramIndex, x);
                    break;
                }
                case 2005: 
                case 2011: {
                    this.setCLOBInternal(paramIndex, (oracle.jdbc.internal.OracleClob)x);
                    if (((oracle.jdbc.internal.OracleClob)x).isNCLOB()) {
                        this.setFormOfUseInternal(paramIndex, (short)2);
                        break;
                    }
                    this.setFormOfUseInternal(paramIndex, this.defaultFormOfUse);
                    break;
                }
                case -13: {
                    this.setBFILEInternal(paramIndex, (oracle.jdbc.internal.OracleBfile)x);
                    break;
                }
                case 2002: 
                case 2008: {
                    this.setSTRUCTInternal(paramIndex, STRUCT.toSTRUCT(x, this.connection));
                    break;
                }
                case 2003: {
                    this.setARRAYInternal(paramIndex, ARRAY.toARRAY(x, this.connection));
                    break;
                }
                case 2007: {
                    if (x instanceof ANYDATA) {
                        this.setOPAQUEInternal(paramIndex, (OPAQUE)((ANYDATA)x).toDatum(this.getConnection()));
                        break;
                    }
                    if (x instanceof TypeDescriptor) {
                        this.setOPAQUEInternal(paramIndex, (OPAQUE)((TypeDescriptor)x).toDatum(this.getConnection()));
                        break;
                    }
                    this.setOPAQUEInternal(paramIndex, (OPAQUE)x);
                    break;
                }
                case 2006: {
                    this.setREFInternal(paramIndex, (OracleRef)x);
                    break;
                }
                case 2009: {
                    this.setSQLXMLInternal(paramIndex, (SQLXML)x);
                    break;
                }
                case -10: 
                case 2012: {
                    this.setCursorInternal(paramIndex, x != null ? (ResultSet)x : null);
                    break;
                }
                case 16: {
                    if (x instanceof BOOLEAN) {
                        x = ((BOOLEAN)x).toBooleanValue();
                    }
                    this.setBooleanInternal(paramIndex, (Boolean)x);
                    break;
                }
                case -109: 
                case -108: 
                case -107: 
                case -106: 
                case -105: {
                    this.setVectorInternal(paramIndex, x, targetSqlType);
                    break;
                }
                default: {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }
            }
        }
        catch (ClassCastException cce) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
        }
    }

    @Override
    public void setObjectAtName(String paramName, Object x, int targetSqlType, int scale) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setObjectInternal(i + 1, x, targetSqlType, scale);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setObject(int paramIndex, Object x, int targetSqlType) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setObjectInternal(paramIndex, x, targetSqlType, -1);
        }
    }

    void setObjectInternal(int paramIndex, Object x, int targetSqlType) throws SQLException {
        this.setObjectInternal(paramIndex, x, targetSqlType, -1);
    }

    @Override
    public void setRefType(int paramIndex, REF ref) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setREFInternal(paramIndex, ref);
        }
    }

    void setRefTypeInternal(int paramIndex, REF ref) throws SQLException {
        this.setREFInternal(paramIndex, ref);
    }

    @Override
    public void setRef(int paramIndex, Ref ref) throws SQLException {
        this.setREFInternal(paramIndex, (OracleRef)ref);
    }

    void setRefInternal(int paramIndex, Ref ref) throws SQLException {
        this.setREFInternal(paramIndex, (OracleRef)ref);
    }

    @Override
    public void setREF(int paramIndex, REF ref) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setREFInternal(paramIndex, ref);
        }
    }

    void setREFInternal(int paramIndex, OracleRef ref) throws SQLException {
        PhysicalConnection c2;
        PhysicalConnection c1;
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (ref == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        PhysicalConnection phys = (PhysicalConnection)ref.getInternalConnection();
        if (phys == null || this.connection == phys) {
            try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                this.setREFCritical(index, ref);
                this.currentRowCharLens[index] = 0;
            }
        }
        this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "setREFInternal", "REF created by one OracleConnection was used by a different OracleConnection. ", null, null);
        if (this.connection.hashCode() < phys.hashCode()) {
            c1 = this.connection;
            c2 = phys;
        } else {
            c1 = phys;
            c2 = this.connection;
        }
        try (Monitor.CloseableLock lock1 = c1.acquireCloseableLock();
             Monitor.CloseableLock lock2 = c2.acquireCloseableLock();){
            this.setREFCritical(index, ref);
            this.currentRowCharLens[index] = 0;
        }
    }

    void setREFCritical(int index, OracleRef ref) throws SQLException {
        StructDescriptor desc = ref.getDescriptor();
        if (desc == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 52).fillInStackTrace();
        }
        OracleTypeADT otype = desc.getOracleTypeADT();
        otype.getTOID();
        this.currentRowBinders[index] = new RefTypeBinder(ref.getBytes(), otype);
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
    }

    @Override
    public void setObject(int paramIndex, Object x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setObjectInternal(paramIndex, x);
        }
    }

    void setObjectInternal(int paramIndex, Object x) throws SQLException {
        if (x instanceof ORAData) {
            this.setORADataInternal(paramIndex, (ORAData)x);
        } else if (x instanceof CustomDatum) {
            this.setCustomDatumInternal(paramIndex, (CustomDatum)x);
        } else if (x instanceof OracleData) {
            this.setOracleDataInternal(paramIndex, (OracleData)x);
        } else if (x instanceof OracleResultSet) {
            this.setCursorInternal(paramIndex, (ResultSet)x);
        } else {
            int sqlType = this.sqlTypeForObject(x);
            this.setObjectInternal(paramIndex, x, sqlType, -1);
        }
    }

    @Override
    public void setOracleObject(int paramIndex, Datum x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setObjectInternal(paramIndex, x);
        }
    }

    void setOracleObjectInternal(int paramIndex, Datum x) throws SQLException {
        this.setObjectInternal(paramIndex, x);
    }

    @Override
    @Deprecated
    public void setPlsqlIndexTable(int paramIndex, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setPlsqlIndexTableInternal(paramIndex, arrayData, maxLen, curLen, elemSqlType, elemMaxLen);
        }
    }

    void setPlsqlIndexTableInternal(int paramIndex, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (arrayData == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 271).fillInStackTrace();
        }
        if (curLen > Array.getLength(arrayData)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, String.format("curLen (%d) is greater than Array Length (%d)", curLen, Array.getLength(arrayData))).fillInStackTrace();
        }
        if (curLen > maxLen) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, String.format("curLen (%d) is greater than maxLen (%d)", curLen, maxLen)).fillInStackTrace();
        }
        if (Array.getLength(arrayData) > maxLen) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, String.format("Array Length (%d) is greater than maxLen (%d)", Array.getLength(arrayData), maxLen)).fillInStackTrace();
        }
        int elem_internal_type = this.getInternalType(elemSqlType);
        Object[] darray = null;
        switch (elem_internal_type) {
            case 1: 
            case 96: {
                String[] l_darray = null;
                int datalen = 0;
                if (arrayData instanceof CHAR[]) {
                    CHAR[] data = (CHAR[])arrayData;
                    datalen = data.length;
                    l_darray = new String[datalen];
                    for (int i = 0; i < datalen; ++i) {
                        CHAR elem = data[i];
                        if (elem == null) continue;
                        l_darray[i] = elem.getString();
                    }
                } else if (arrayData instanceof String[]) {
                    l_darray = (String[])arrayData;
                    datalen = l_darray.length;
                } else {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97).fillInStackTrace();
                }
                if (elemMaxLen == 0 && l_darray != null) {
                    for (int i = 0; i < datalen; ++i) {
                        String elem = l_darray[i];
                        if (elem == null || elemMaxLen >= elem.length()) continue;
                        elemMaxLen = elem.length();
                    }
                }
                darray = l_darray;
                break;
            }
            case 2: 
            case 6: {
                darray = OracleTypeNUMBER.toNUMBERArray(arrayData, this.connection, 1L, curLen);
                if (elemMaxLen == 0 && darray != null) {
                    elemMaxLen = 22;
                }
                this.currentRowCharLens[index] = 0;
                break;
            }
            default: {
                int[] eMaxLen = new int[]{0};
                darray = this.handleOtherPlsqlTypes(elem_internal_type, arrayData, curLen, eMaxLen);
                if (darray == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97).fillInStackTrace();
                }
                if (elemMaxLen != 0) break;
                elemMaxLen = eMaxLen[0];
            }
        }
        if (darray.length == 0 && maxLen == 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 272).fillInStackTrace();
        }
        this.currentRowBinders[index] = this.thePlsqlIbtBinder;
        this.currentRowByteLens[index] = this.currentRowBinders[index].bytelen;
        this.currentRowCharLens[index] = 0;
        if (this.parameterPlsqlIbt == null) {
            this.parameterPlsqlIbt = new PlsqlIbtBindInfo[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
        }
        this.parameterPlsqlIbt[this.currentRank][index] = new PlsqlIbtBindInfo(this, darray, maxLen, curLen, elem_internal_type, elemMaxLen);
        this.hasIbtBind = true;
    }

    Object[] handleOtherPlsqlTypes(int internalType, Object arrayData, int curLen, int[] eMaxLen) throws SQLException {
        return null;
    }

    @Deprecated
    public void setPlsqlIndexTableAtName(String paramName, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setPlsqlIndexTableInternal(i + 1, arrayData, maxLen, curLen, elemSqlType, elemMaxLen);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    void endOfResultSet() throws SQLException {
        this.prepareForNewResults(false, false, false);
        this.rowPrefetchInLastFetch = -1;
    }

    int sqlTypeForObject(Object x) {
        if (x == null) {
            return 0;
        }
        if (!(x instanceof Datum)) {
            if (x instanceof String) {
                return this.fixedString || this.connection.mapStringParameterToCHAR ? 999 : 12;
            }
            if (x instanceof Character) {
                return 1;
            }
            if (x instanceof BigDecimal) {
                return 2;
            }
            if (x instanceof BigInteger) {
                return 2;
            }
            if (x instanceof Boolean) {
                return 16;
            }
            if (x instanceof Integer) {
                return 4;
            }
            if (x instanceof Long) {
                return -5;
            }
            if (x instanceof Float) {
                return 7;
            }
            if (x instanceof Double) {
                return 8;
            }
            if (x instanceof byte[]) {
                return -3;
            }
            if (x instanceof Short) {
                return 5;
            }
            if (x instanceof Byte) {
                return -6;
            }
            if (x instanceof Date) {
                return 91;
            }
            if (x instanceof Time) {
                return 92;
            }
            if (x instanceof Timestamp) {
                return 93;
            }
            if (x instanceof SQLData) {
                return 2002;
            }
            if (x instanceof ObjectData) {
                return 2002;
            }
            if (x instanceof URL) {
                return this.fixedString || this.connection.mapStringParameterToCHAR ? 999 : 12;
            }
            if (x instanceof LogicalTransactionId) {
                return -2;
            }
            if (x instanceof LocalDate) {
                return 93;
            }
            if (x instanceof LocalTime) {
                return 93;
            }
            if (x instanceof LocalDateTime) {
                return 93;
            }
            if (x instanceof ZonedDateTime) {
                return -101;
            }
            if (x instanceof OffsetDateTime) {
                return -101;
            }
            if (x instanceof OffsetTime) {
                return -101;
            }
            if (x instanceof Duration) {
                return -104;
            }
            if (x instanceof Period) {
                return -103;
            }
            if (x instanceof OracleJsonValue || x instanceof OracleJsonParser) {
                return 2016;
            }
            if (PhysicalConnection.isJsonJarPresent() && (x instanceof JsonValue || x instanceof javax.json.stream.JsonParser)) {
                return 2016;
            }
            if (PhysicalConnection.isJakartaJarPresent() && (x instanceof jakarta.json.JsonValue || x instanceof JsonParser)) {
                return 2016;
            }
        } else {
            if (x instanceof BINARY_FLOAT) {
                return 100;
            }
            if (x instanceof BINARY_DOUBLE) {
                return 101;
            }
            if (x instanceof BLOB || x instanceof OracleBlob) {
                return 2004;
            }
            if (x instanceof CLOB || x instanceof OracleClob) {
                return 2005;
            }
            if (x instanceof BFILE || x instanceof OracleBfile) {
                return -13;
            }
            if (x instanceof ROWID) {
                return -8;
            }
            if (x instanceof NUMBER) {
                return 2;
            }
            if (x instanceof DATE) {
                return 91;
            }
            if (x instanceof TIMESTAMP) {
                return 93;
            }
            if (x instanceof TIMESTAMPTZ) {
                return -101;
            }
            if (x instanceof TIMESTAMPLTZ) {
                return -102;
            }
            if (x instanceof REF) {
                return 2006;
            }
            if (x instanceof CHAR) {
                return 1;
            }
            if (x instanceof RAW) {
                return -2;
            }
            if (x instanceof ARRAY) {
                return 2003;
            }
            if (x instanceof STRUCT) {
                return 2002;
            }
            if (x instanceof OPAQUE) {
                return 2007;
            }
            if (x instanceof INTERVALYM) {
                return -103;
            }
            if (x instanceof INTERVALDS) {
                return -104;
            }
            if (x instanceof SQLXML) {
                return 2009;
            }
            if (x instanceof OracleJsonDatum) {
                return 2016;
            }
            if (x instanceof VECTOR) {
                return -105;
            }
            if (x instanceof BOOLEAN) {
                return 16;
            }
        }
        return 1111;
    }

    @Override
    public void clearParameters() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.clearParametersCritical();
        }
    }

    void clearParametersCritical() throws SQLException {
        this.clearParametersCritical(true);
    }

    void clearParametersCritical(boolean returnBlocksToSource) throws SQLException {
        this.ibtBindChars = null;
        this.ibtBindBytes = null;
        this.ibtBindIndicators = null;
        this.clearParameters = true;
        if (this.currentRowBinders != null) {
            for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                this.currentRowBinders[bindPos] = null;
            }
        }
        this.bindData.free(returnBlocksToSource);
    }

    @Override
    public void setCharacterStream(int paramIndex, Reader reader, int length) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (length < 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setCharacterStream cannot be negative").fillInStackTrace();
            }
            this.setCharacterStreamInternal(paramIndex, reader, length);
        }
    }

    void setCharacterStreamInternal(int paramIndex, Reader reader, int length) throws SQLException {
        this.setCharacterStreamInternal(paramIndex, reader, length, true);
    }

    void setCharacterStreamInternal(int paramIndex, Reader reader, long length, boolean isLengthSpecified) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (isLengthSpecified && length < 0L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 43).fillInStackTrace();
        }
        this.checkUserStreamForDuplicates(reader, index);
        if (reader == null || isLengthSpecified && length == 0L) {
            this.basicBindNullString(paramIndex);
        } else {
            if (!(this.userRsetType == DEFAULT_RESULT_SET_TYPE || length <= (long)this.maxVcsCharsSql && isLengthSpecified)) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 169).fillInStackTrace();
            }
            if (!isLengthSpecified) {
                this.setReaderContentsForClobCritical(paramIndex, reader, length, isLengthSpecified);
            } else if (this.currentRowFormOfUse[index] == 1) {
                if (this.sqlKind.isPlsqlOrCall()) {
                    if (length > (long)this.maxVcsBytesPlsql || length > (long)this.maxVcsCharsPlsql && this.isServerCharSetFixedWidth) {
                        this.setReaderContentsForClobCritical(paramIndex, reader, length, isLengthSpecified);
                    } else if (length <= (long)this.maxVcsCharsPlsql) {
                        this.setReaderContentsForStringInternal(paramIndex, reader, (int)length);
                    } else {
                        this.setReaderContentsForStringOrClobInVariableWidthCase(paramIndex, reader, (int)length, false);
                    }
                } else if (length <= (long)this.maxVcsCharsSql) {
                    this.setReaderContentsForStringInternal(paramIndex, reader, (int)length);
                } else if (length > Integer.MAX_VALUE) {
                    this.setReaderContentsForClobCritical(paramIndex, reader, length, isLengthSpecified);
                } else {
                    this.basicBindCharacterStream(paramIndex, reader, (int)length, false);
                }
            } else if (this.sqlKind.isPlsqlOrCall()) {
                if (length > (long)this.maxVcsBytesPlsql || length > (long)this.maxVcsNCharsPlsql && this.isServerCharSetFixedWidth) {
                    this.setReaderContentsForClobCritical(paramIndex, reader, length, isLengthSpecified);
                } else if (length <= (long)this.maxVcsNCharsPlsql) {
                    this.setReaderContentsForStringInternal(paramIndex, reader, (int)length);
                } else {
                    this.setReaderContentsForStringOrClobInVariableWidthCase(paramIndex, reader, (int)length, true);
                }
            } else if (length <= (long)this.maxVcsNCharsSql) {
                this.setReaderContentsForStringInternal(paramIndex, reader, (int)length);
            } else {
                this.setReaderContentsForClobCritical(paramIndex, reader, length, isLengthSpecified);
            }
        }
    }

    void basicBindCharacterStream(int paramIndex, Reader reader, int length, boolean isInternal) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.userRsetType != DEFAULT_RESULT_SET_TYPE && length > this.maxVcsCharsSql) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1717).fillInStackTrace();
            }
            int index = paramIndex - 1;
            this.currentRowBinders[index] = isInternal ? this.theLongStreamForStringBinder : this.theLongStreamBinder;
            if (this.parameterStream == null) {
                this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            int conversionCode = this.getConversionCodeForCharacterStream(index);
            short formOfUse = this.currentRowFormOfUse[index];
            this.parameterStream[this.currentRank][index] = isInternal ? this.connection.conversion.ConvertStreamInternal(reader, conversionCode, length, formOfUse) : this.connection.conversion.ConvertStream(reader, conversionCode, length, formOfUse, this.connection);
            this.currentRowByteLens[index] = 0;
            this.currentRowCharLens[index] = 0;
        }
    }

    void setReaderContentsForStringOrClobInVariableWidthCase(int paramIndex, Reader reader, int length, boolean isNChar) throws SQLException {
        int bytes_length;
        char[] charbuf = new char[length];
        int chars_length = 0;
        try {
            int read_length;
            for (int chars_remaining = length; chars_remaining > 0 && (read_length = reader.read(charbuf, chars_length, chars_remaining)) != -1; chars_remaining -= read_length) {
                chars_length += read_length;
            }
        }
        catch (IOException e) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
        }
        if (chars_length != length) {
            char[] newbuf = new char[chars_length];
            System.arraycopy(charbuf, 0, newbuf, 0, chars_length);
            charbuf = newbuf;
        }
        if ((bytes_length = this.connection.conversion.encodedByteLength(charbuf, isNChar)) < this.maxVcsBytesPlsql) {
            this.setStringInternal(paramIndex, new String(charbuf));
        } else {
            this.setStringForClobCritical(paramIndex, new String(charbuf));
        }
    }

    void setReaderContentsForStringInternal(int paramIndex, Reader reader, int length) throws SQLException {
        char[] charbuf = new char[length];
        int actual_length = 0;
        try {
            int read_length;
            for (int length_remaining = length; length_remaining > 0 && (read_length = reader.read(charbuf, actual_length, length_remaining)) != -1; length_remaining -= read_length) {
                actual_length += read_length;
            }
        }
        catch (IOException e) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
        }
        if (actual_length != length) {
            char[] newbuf = new char[actual_length];
            System.arraycopy(charbuf, 0, newbuf, 0, actual_length);
            charbuf = newbuf;
        }
        this.setStringInternal(paramIndex, new String(charbuf));
    }

    @Override
    public void setDate(int paramIndex, Date x, Calendar cal) throws SQLException {
        this.setDATEInternal(paramIndex, x == null ? null : new DATE(x, cal));
    }

    void setDateInternal(int paramIndex, Date x, Calendar cal) throws SQLException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setDateInternal(int, Date, Calendar)", (String)null, "index={0}, value={1}. ", null, (Object)paramIndex, (Object)x);
        this.setDATEInternal(paramIndex, x == null ? null : new DATE(x, cal));
    }

    @Override
    public void setTime(int paramIndex, Time x, Calendar cal) throws SQLException {
        this.setDATEInternal(paramIndex, x == null ? null : new DATE(x, cal));
    }

    void setTimeInternal(int paramIndex, Time x, Calendar cal) throws SQLException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setTimeInternal(int, Time, Calendar)", (String)null, "index={0}, value={1}, calendar={2}. ", null, (Object)paramIndex, (Object)x, (Object)cal);
        this.setDATEInternal(paramIndex, x == null ? null : new DATE(x, cal));
    }

    @Override
    public void setTimestamp(int paramIndex, Timestamp x, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setTimestampInternal(paramIndex, x, cal);
        }
    }

    void setTimestampInternal(int paramIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTIMESTAMPInternal(paramIndex, x == null ? null : new TIMESTAMP(x, cal));
    }

    @Override
    public void setCheckBindTypes(boolean flag) {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.checkBindTypes = flag;
        }
    }

    final void setBatchUpdate() {
        this.batchUpdate = true;
    }

    @Override
    final void checkIfBatchExists() throws SQLException {
        if (this.doesBatchExist()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 81, "batch must be either executed or cleared").fillInStackTrace();
        }
    }

    boolean doesBatchExist() {
        return this.currentRank > 0 && this.batchUpdate;
    }

    @Override
    public void addBatch() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.requireValidBatchCommand();
            this.setBatchUpdate();
            this.processCompletedBindRow(this.currentRank + 2, this.currentRank > 0 && this.sqlKind.isPlsqlOrCall());
            ++this.currentRank;
        }
    }

    private void requireValidBatchCommand() throws SQLException {
        if (!this.connection.continueBatchOnError) {
            return;
        }
        if (!this.isDmlReturning && this.autoKeyInfo == null) {
            return;
        }
        if (OracleStatement.SqlKind.UPDATE != this.sqlKind) {
            return;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 80, "DML returning is not supported for batch UPDATE commands when oracle.jdbc.continueBatchOnError=true").fillInStackTrace();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        try {
            throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("addBatch").fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.clearBatchCritical();
        }
    }

    @Override
    void clearBatchCritical() throws SQLException {
        for (int r = this.currentRank - 1; r >= 0; --r) {
            for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                this.binders[r][bindPos] = null;
            }
        }
        this.batchFIFOFront = null;
        this.batchFIFOBack = null;
        this.firstRowInBatch = 0;
        this.currentBatchAccumulatedBindsSize = 0L;
        if (this.binders != null) {
            this.binders[0] = this.currentRowBinders;
        }
        this.currentRank = 0;
    }

    private void executeForRowsWithTimeout(boolean isDescribed) throws SQLException {
        OracleTimeout timeout = null;
        try {
            this.cancelLock.enterExecuting();
            timeout = this.beginTimeout();
            this.executeForRows(isDescribed);
        }
        finally {
            if (timeout != null) {
                timeout.cancelTimeout();
            }
            this.cancelLock.exitExecuting();
        }
    }

    private void executeForRowsWithTimeoutAsync(boolean isDescribed, Consumer<Throwable> callback) {
        try {
            this.cancelLock.enterExecuting();
            OracleTimeout timeout = this.beginTimeout();
            this.executeForRowsAsync(isDescribed, error -> {
                try {
                    if (timeout != null) {
                        timeout.cancelTimeout();
                    }
                    this.cancelLock.exitExecuting();
                }
                catch (Throwable throwable) {
                    error = CompletionStageUtil.suppress(throwable, error);
                }
                finally {
                    callback.accept((Throwable)error);
                }
            });
        }
        catch (SQLException preExecutionFailure) {
            callback.accept(preExecutionFailure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            long[] lArray;
            this.beginCurrentSql(this.getOriginalSql());
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeLargeBatch", null, null, null);
            try {
                long[] result;
                block25: {
                    this.awaitResultSetPublishing();
                    this.checkSum = 0L;
                    this.checkSumComputationFailure = false;
                    long startToken = 0L;
                    if (this.dmsExecute != null) {
                        startToken = this.dmsExecute.start();
                    }
                    try {
                        this.connection.updateSystemContext();
                        this.cleanOldTempLobs();
                        this.setBatchUpdate();
                        if (this.currentRank > 0) {
                            this.initializeAutoKeyInfo();
                            this.prepareForExecuteBatch();
                            try {
                                try {
                                    this.prepareConnectionForExecuteBatch();
                                }
                                catch (SQLException preExecutionFailure) {
                                    throw this.generateBatchUpdateException(preExecutionFailure, new long[this.currentRank], 0);
                                }
                                int saved_current_rank = this.currentRank;
                                result = this.batchFIFOFront == null ? this.executeBatchWithoutQueue() : this.executeBatchFromQueue();
                                this.slideDownCurrentRow(saved_current_rank);
                            }
                            catch (BatchUpdateException batchExecutionFailure) {
                                this.handleExecuteBatchFailure();
                                throw batchExecutionFailure;
                            }
                            finally {
                                this.handleExecuteBatchCompletionAlways();
                            }
                            this.handleExecuteBatchCompletion(result);
                            break block25;
                        }
                        result = new long[]{};
                    }
                    finally {
                        if (this.dmsExecute != null) {
                            this.dmsExecute.stop(startToken);
                        }
                    }
                }
                lArray = result;
            }
            catch (Throwable throwable) {
                this.endCurrentSql();
                throw throwable;
            }
            this.endCurrentSql();
            return lArray;
        }
        catch (SQLException e) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeLargeBatch", null, null, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public Flow.Publisher<Long> executeBatchAsyncOracle() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Flow.Publisher<Long> publisher;
            this.requireOpenStatement();
            if (this.sqlKind.isSELECT()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 129).fillInStackTrace();
            }
            this.awaitResultSetPublishing();
            CompletableFuture<long[]> future = new CompletableFuture<long[]>();
            this.checkSum = 0L;
            this.checkSumComputationFailure = false;
            long startToken = this.dmsExecute != null ? this.dmsExecute.start() : 0L;
            int saved_current_rank = this.currentRank;
            BiConsumer<long[], Throwable> callback = (result, error) -> {
                try {
                    if (error == null) {
                        this.slideDownCurrentRow(saved_current_rank);
                    }
                }
                catch (Throwable throwable) {
                    error = CompletionStageUtil.suppress(throwable, error);
                }
                try {
                    if (error instanceof BatchUpdateException) {
                        this.handleExecuteBatchFailure();
                    }
                }
                catch (Throwable throwable) {
                    error = CompletionStageUtil.suppress(throwable, error);
                }
                try {
                    this.handleExecuteBatchCompletionAlways();
                    if (error == null) {
                        this.handleExecuteBatchCompletion((long[])result);
                    }
                }
                catch (Throwable throwable) {
                    error = CompletionStageUtil.suppress(throwable, error);
                }
                try {
                    if (this.dmsExecute != null) {
                        this.dmsExecute.stop(startToken);
                    }
                }
                catch (Throwable throwable) {
                    error = CompletionStageUtil.suppress(throwable, error);
                }
                if (error == null) {
                    future.complete((long[])result);
                } else {
                    future.completeExceptionally((Throwable)error);
                }
            };
            try {
                this.connection.updateSystemContext();
                this.cleanOldTempLobs();
                this.setBatchUpdate();
                if (this.currentRank > 0) {
                    this.initializeAutoKeyInfoAsync(error -> {
                        if (error != null) {
                            future.completeExceptionally((Throwable)error);
                            return;
                        }
                        try {
                            this.prepareForExecuteBatch();
                        }
                        catch (Throwable throwable) {
                            future.completeExceptionally(throwable);
                            return;
                        }
                        try {
                            this.prepareConnectionForExecuteBatch();
                            if (this.batchFIFOFront == null) {
                                this.executeBatchWithoutQueueAsync(callback);
                            } else {
                                this.executeBatchFromQueueAsync(callback);
                            }
                        }
                        catch (SQLException preExecutionFailure) {
                            future.completeExceptionally(this.generateBatchUpdateException(preExecutionFailure, new long[this.currentRank], 0));
                        }
                    });
                } else {
                    future.complete(new long[0]);
                }
            }
            catch (SQLException preExecutionFailure) {
                future.completeExceptionally(preExecutionFailure);
            }
            this.wrapper.beginAsyncExecution();
            Flow.Publisher<Long> publisher2 = publisher = CompletionStageUtil.newBatchItemPublisher(future.whenCompleteAsync((result, error) -> {
                if (this.wrapper != null) {
                    this.wrapper.endAsyncExecution();
                }
            }, this.connection.getAsyncExecutor()), x$0 -> {
                class ResultIterator
                implements Iterator<Long> {
                    final long[] result;
                    int i = 0;

                    private ResultIterator(long[] result) {
                        this.result = result;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i < this.result.length;
                    }

                    @Override
                    public Long next() {
                        return this.result[this.i++];
                    }
                }
                return new ResultIterator((long[])x$0);
            }, this.connection.getJoinPhaser());
            return publisher2;
        }
    }

    private void prepareForExecuteBatch() throws SQLException {
        this.awaitResultSetPublishing();
        if (this.connection.isDRCPEnabled()) {
            this.prepareForExecuteWithDRCP();
        }
        this.ensureOpen();
        this.prepareForNewResults(true, true, true);
        if (this.sqlKind.isSELECT()) {
            throw (SQLException)DatabaseError.createBatchUpdateException(80, 0, null).fillInStackTrace();
        }
        this.noMoreUpdateCounts = false;
    }

    private void prepareConnectionForExecuteBatch() throws SQLException {
        this.connection.needLine();
        if (this.connection.dmsUpdateSqlText()) {
            this.dmsSqlText.update(this.sqlObject.toString());
        }
        if (!this.isOpen) {
            this.connection.open(this);
            this.isOpen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] executeBatchWithoutQueue() throws BatchUpdateException {
        int batchSize = this.currentRank;
        long totalValidRows = 0L;
        try {
            this.setupBindBuffers(0, this.currentRank);
            try {
                this.executeForRowsWithTimeout(false);
                totalValidRows = this.validRows;
            }
            finally {
                this.resetBindersToNull(0);
            }
            if (this.batchRowsUpdatedArray != null && this.batchRowsUpdatedArray.length > 0) {
                assert (batchSize == this.batchRowsUpdatedArray.length);
                long[] lArray = this.batchRowsUpdatedArray;
                return lArray;
            }
            long[] batchResults = new long[batchSize];
            Arrays.fill(batchResults, -2L);
            long[] lArray = batchResults;
            return lArray;
        }
        catch (SQLException executionFailure) {
            throw this.generateBatchUpdateException(executionFailure, new long[batchSize], 0);
        }
        finally {
            this.setValidRowsAfterExecuteBatch(totalValidRows);
        }
    }

    private void executeBatchWithoutQueueAsync(BiConsumer<long[], Throwable> callback) {
        int batchSize = this.currentRank;
        this.executeForRowsWithTimeoutAsync(false, error -> {
            long[] result = null;
            long totalValidRows = 0L;
            try {
                if (error == null) {
                    totalValidRows = this.validRows;
                }
                this.resetBindersToNull(0);
                if (error == null) {
                    if (this.batchRowsUpdatedArray != null && this.batchRowsUpdatedArray.length > 0) {
                        assert (batchSize == this.batchRowsUpdatedArray.length);
                        result = this.batchRowsUpdatedArray;
                    } else {
                        result = new long[batchSize];
                        Arrays.fill(result, -2L);
                    }
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            try {
                if (error instanceof SQLException) {
                    error = this.generateBatchUpdateException((SQLException)error, new long[batchSize], 0);
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            try {
                this.setValidRowsAfterExecuteBatch(totalValidRows);
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            callback.accept((long[])(error == null ? result : null), (Throwable)error);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] executeBatchFromQueue() throws BatchUpdateException {
        long[] batchResults = new long[this.currentRank];
        int callResultIndex = 0;
        long totalValidRows = 0L;
        SQLException continueOnFailureException = null;
        try {
            if (this.currentRank > this.firstRowInBatch) {
                this.enqueueCurrentBatch(true);
            }
            boolean saved_need_to_parse = this.needToParse;
            this.fetchMode = OracleStatement.FetchMode.OVERWRITE;
            do {
                BatchFIFONode fifoNode = this.batchFIFOFront;
                this.prepareForExecuteBatchFromQueue(fifoNode);
                this.setupBindBuffers(fifoNode.first_row_in_batch, fifoNode.number_of_rows_to_be_bound);
                try {
                    this.executeForRowsWithTimeout(false);
                    this.copyEnqueuedBatchResults(batchResults, callResultIndex++);
                }
                catch (SQLException sqlException) {
                    continueOnFailureException = this.continueEnqueuedBatchOnFailure(continueOnFailureException, sqlException);
                    this.copyEnqueuedBatchFailureResults(batchResults, callResultIndex++);
                }
                finally {
                    this.resetBindersToNull(fifoNode.first_row_in_batch);
                    totalValidRows += this.validRows;
                    this.fetchMode = OracleStatement.FetchMode.APPEND;
                }
                this.batchFIFOFront = fifoNode.next;
            } while (this.batchFIFOFront != null);
            this.batchFIFOBack = null;
            this.firstRowInBatch = 0;
            this.needToParse = saved_need_to_parse;
        }
        catch (SQLException executionFailure) {
            throw this.generateBatchUpdateException(executionFailure, batchResults, callResultIndex);
        }
        finally {
            this.setValidRowsAfterExecuteBatch(totalValidRows);
            this.fetchMode = OracleStatement.FetchMode.OVERWRITE;
        }
        if (continueOnFailureException != null) {
            throw DatabaseError.createBatchUpdateException(continueOnFailureException, this.getBatchUpdateErrorMessage(), batchResults.length, batchResults);
        }
        return batchResults;
    }

    protected void executeBatchFromQueueAsync(BiConsumer<long[], Throwable> callback) {
        if (this.currentRank > this.firstRowInBatch) {
            try {
                this.enqueueCurrentBatch(true);
            }
            catch (SQLException sqlException) {
                callback.accept(null, sqlException);
                return;
            }
        }
        boolean saved_need_to_parse = this.needToParse;
        this.fetchMode = OracleStatement.FetchMode.OVERWRITE;
        long[] batchResults = new long[this.currentRank];
        SQLException continueOnFailureChain = new SQLException();
        this.executeEnqueuedBatchAsync(batchResults, 0, 0L, continueOnFailureChain, (totalValidRows, error) -> {
            try {
                if (error == null) {
                    this.batchFIFOBack = null;
                    this.firstRowInBatch = 0;
                    this.needToParse = saved_need_to_parse;
                }
                this.setValidRowsAfterExecuteBatch((long)totalValidRows);
                this.fetchMode = OracleStatement.FetchMode.OVERWRITE;
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            finally {
                if (error != null) {
                    callback.accept((long[])null, (Throwable)error);
                } else {
                    SQLException continueOnFailureException = continueOnFailureChain.getNextException();
                    if (continueOnFailureException != null) {
                        callback.accept(null, DatabaseError.createBatchUpdateException(continueOnFailureException, this.getBatchUpdateErrorMessage(), batchResults.length, batchResults));
                    } else {
                        callback.accept(batchResults, null);
                    }
                }
            }
        });
    }

    protected void executeEnqueuedBatchAsync(long[] batchResults, int callResultIndex, long totalValidRows, SQLException continueOnFailureException, BiConsumer<Long, Throwable> callback) {
        BatchFIFONode fifoNode = this.batchFIFOFront;
        this.prepareForExecuteBatchFromQueue(fifoNode);
        this.executeForRowsWithTimeoutAsync(false, error -> {
            long nextTotalValidRows = 0L;
            int nextCallResultIndex = callResultIndex;
            SQLException nextContinueOnFailureException = continueOnFailureException;
            try {
                if (error == null) {
                    this.copyEnqueuedBatchResults(batchResults, nextCallResultIndex);
                    ++nextCallResultIndex;
                } else if (error instanceof SQLException) {
                    try {
                        nextContinueOnFailureException = this.continueEnqueuedBatchOnFailure(continueOnFailureException, (SQLException)error);
                        error = null;
                        this.copyEnqueuedBatchFailureResults(batchResults, nextCallResultIndex);
                        ++nextCallResultIndex;
                    }
                    catch (SQLException sqlException) {
                        error = sqlException;
                    }
                }
                this.resetBindersToNull(fifoNode.first_row_in_batch);
                nextTotalValidRows = totalValidRows + this.validRows;
                this.fetchMode = OracleStatement.FetchMode.APPEND;
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            finally {
                try {
                    if (error instanceof SQLException) {
                        error = this.generateBatchUpdateException((SQLException)error, batchResults, callResultIndex);
                    }
                }
                catch (Throwable throwable) {
                    error = CompletionStageUtil.suppress(throwable, error);
                }
                if (error != null) {
                    callback.accept(nextTotalValidRows, (Throwable)error);
                } else {
                    this.batchFIFOFront = fifoNode.next;
                    if (this.batchFIFOFront != null) {
                        this.executeEnqueuedBatchAsync(batchResults, nextCallResultIndex, nextTotalValidRows, nextContinueOnFailureException, callback);
                    } else {
                        callback.accept(nextTotalValidRows, null);
                    }
                }
            }
        });
    }

    private void prepareForExecuteBatchFromQueue(BatchFIFONode batchedExecution) {
        this.currentBatchByteLens = batchedExecution.currentBatchByteLens;
        this.lastBoundByteLens = batchedExecution.lastBoundByteLens;
        this.currentBatchCharLens = batchedExecution.currentBatchCharLens;
        this.lastBoundCharLens = batchedExecution.lastBoundCharLens;
        this.lastBoundNeeded = batchedExecution.lastBoundNeeded;
        this.currentBatchBindAccessors = batchedExecution.currentBatchBindAccessors;
        this.needToParse = batchedExecution.need_to_parse;
        this.currentBatchNeedToPrepareBinds = batchedExecution.current_batch_need_to_prepare_binds;
        this.firstRowInBatch = batchedExecution.first_row_in_batch;
        this.currentRank = batchedExecution.number_of_rows_to_be_bound;
    }

    private void copyEnqueuedBatchResults(long[] batchResults, int callResultIndex) {
        if (this.batchRowsUpdatedArray != null && this.batchRowsUpdatedArray.length > 0) {
            this.copyBatchRowsUpdatedArray(batchResults);
        } else if (this.sqlKind.isPlsqlOrCall()) {
            batchResults[callResultIndex] = this.validRows;
        } else {
            for (int j = 0; j < this.currentRank; ++j) {
                batchResults[this.firstRowInBatch + j] = -2L;
            }
        }
    }

    private void copyEnqueuedBatchFailureResults(long[] batchResults, int callResultIndex) {
        if (this.sqlKind.isPlsqlOrCall()) {
            batchResults[callResultIndex] = -3L;
        } else {
            long[] failedBatchResults = this.generateFailedBatchResults(batchResults);
            if (failedBatchResults != batchResults) {
                System.arraycopy(failedBatchResults, 0, batchResults, 0, failedBatchResults.length);
            }
        }
    }

    private SQLException continueEnqueuedBatchOnFailure(SQLException previousException, SQLException sqlException) throws SQLException {
        if (!this.connection.continueBatchOnError) {
            throw sqlException;
        }
        if (!(sqlException.getCause() instanceof OracleDatabaseException)) {
            if (previousException != null) {
                sqlException.addSuppressed(previousException);
            }
            throw sqlException;
        }
        if (previousException == null) {
            return sqlException;
        }
        previousException.setNextException(sqlException);
        return previousException;
    }

    private void copyBatchRowsUpdatedArray(long[] dst) {
        if (this.batchRowsUpdatedArray.length < this.currentRank) {
            int newCopyLength = this.batchRowsUpdatedArray.length;
            int failedStart = this.firstRowInBatch + newCopyLength;
            int failedEnd = failedStart + (this.currentRank - newCopyLength);
            System.arraycopy(this.batchRowsUpdatedArray, 0, dst, this.firstRowInBatch, newCopyLength);
            for (int j = failedStart; j < failedEnd; ++j) {
                dst[j] = -3L;
            }
        } else {
            System.arraycopy(this.batchRowsUpdatedArray, 0, dst, this.firstRowInBatch, this.currentRank);
        }
    }

    private void setValidRowsAfterExecuteBatch(long totalValidRows) {
        if (this.sqlKind.isPlsqlOrCall() || totalValidRows > this.validRows) {
            this.validRows = totalValidRows;
        }
    }

    private void handleExecuteBatchFailure() throws SQLException {
        this.needToParse = true;
        this.clearBatchCritical();
        this.resetCurrentRowBinders();
    }

    private void handleExecuteBatchCompletionAlways() throws SQLException {
        this.checkValidRowsStatus();
        this.currentBatchAccumulatedBindsSize = 0L;
        this.currentRank = 0;
    }

    private void handleExecuteBatchCompletion(long[] result) throws SQLException {
        if (this.validRows < 0L) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = -3L;
            }
            throw (SQLException)DatabaseError.createBatchUpdateException(81, 0, result).fillInStackTrace();
        }
    }

    private BatchUpdateException generateBatchUpdateException(SQLException e, long[] batchResults, int callResultIndex) {
        int nFailedBatchResults;
        long[] failedBatchResults;
        if (this.sqlKind.isPlsqlOrCall()) {
            failedBatchResults = batchResults;
            nFailedBatchResults = callResultIndex;
        } else {
            failedBatchResults = this.generateFailedBatchResults(batchResults);
            nFailedBatchResults = failedBatchResults.length;
        }
        BatchUpdateException buEx = DatabaseError.createBatchUpdateException(e, this.getBatchUpdateErrorMessage(), nFailedBatchResults, failedBatchResults);
        buEx.fillInStackTrace();
        return buEx;
    }

    protected String getBatchUpdateErrorMessage() {
        return null;
    }

    private long[] generateFailedBatchResults(long[] batchResults) {
        long[] generatedResults;
        if (this.batchRowsUpdatedArray != null) {
            if (this.firstRowInBatch == 0) {
                generatedResults = this.batchRowsUpdatedArray;
            } else {
                if (this.batchRowsUpdatedArray.length == this.currentRank) {
                    generatedResults = batchResults;
                } else {
                    generatedResults = new long[this.firstRowInBatch + this.batchRowsUpdatedArray.length];
                    System.arraycopy(batchResults, 0, generatedResults, 0, this.firstRowInBatch);
                }
                System.arraycopy(this.batchRowsUpdatedArray, 0, generatedResults, this.firstRowInBatch, this.batchRowsUpdatedArray.length);
            }
            if (this.indexOfFailedElementsInBatch != null) {
                for (int failedIndex : this.indexOfFailedElementsInBatch) {
                    generatedResults[failedIndex + this.firstRowInBatch] = -3L;
                }
            }
        } else if (this.numberOfExecutedElementsInBatch != -1 && this.numberOfExecutedElementsInBatch != this.currentRank) {
            generatedResults = new long[this.numberOfExecutedElementsInBatch];
            Arrays.fill(generatedResults, -2L);
        } else {
            Arrays.fill(batchResults, -3L);
            generatedResults = batchResults;
        }
        return generatedResults;
    }

    void enqueueCurrentBatch(boolean fromExecuteBatch) throws SQLException {
        BatchFIFONode fifoNode = new BatchFIFONode();
        fifoNode.counter = this.batchQueueCounter++;
        fifoNode.currentBatchByteLens = new int[this.numberOfBindPositions];
        System.arraycopy(this.currentBatchByteLens, 0, fifoNode.currentBatchByteLens, 0, this.numberOfBindPositions);
        fifoNode.currentBatchCharLens = new int[this.numberOfBindPositions];
        System.arraycopy(this.currentBatchCharLens, 0, fifoNode.currentBatchCharLens, 0, this.numberOfBindPositions);
        fifoNode.lastBoundByteLens = new int[this.numberOfBindPositions];
        System.arraycopy(this.lastBoundByteLens, 0, fifoNode.lastBoundByteLens, 0, this.numberOfBindPositions);
        fifoNode.lastBoundCharLens = new int[this.numberOfBindPositions];
        System.arraycopy(this.lastBoundCharLens, 0, fifoNode.lastBoundCharLens, 0, this.numberOfBindPositions);
        if (this.currentBatchBindAccessors != null) {
            fifoNode.currentBatchBindAccessors = new Accessor[this.numberOfBindPositions];
            System.arraycopy(this.currentBatchBindAccessors, 0, fifoNode.currentBatchBindAccessors, 0, this.numberOfBindPositions);
        }
        fifoNode.lastBoundNeeded = this.lastBoundNeeded;
        fifoNode.need_to_parse = this.needToParse;
        fifoNode.current_batch_need_to_prepare_binds = this.currentBatchNeedToPrepareBinds;
        fifoNode.first_row_in_batch = this.firstRowInBatch;
        fifoNode.number_of_rows_to_be_bound = this.currentRank - this.firstRowInBatch;
        if (this.batchFIFOFront == null) {
            this.batchFIFOFront = fifoNode;
        } else {
            this.batchFIFOBack.next = fifoNode;
        }
        this.batchFIFOBack = fifoNode;
        this.currentBatchAccumulatedBindsSize = 0L;
        if (!fromExecuteBatch) {
            int bindPos;
            int[] tmp = this.currentBatchByteLens;
            this.currentBatchByteLens = this.lastBoundByteLens;
            this.lastBoundByteLens = tmp;
            for (bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                this.currentBatchByteLens[bindPos] = 0;
            }
            tmp = this.currentBatchCharLens;
            this.currentBatchCharLens = this.lastBoundCharLens;
            this.lastBoundCharLens = tmp;
            for (bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                this.currentBatchCharLens[bindPos] = 0;
            }
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "enqueueCurrentBatch", "end", null, null);
            this.firstRowInBatch = this.currentRank;
        }
    }

    long doScrollPstmtExecuteUpdate() throws SQLException {
        this.doScrollExecuteCommon();
        if (this.sqlKind.isSELECT()) {
            this.scrollRsetTypeSolved = true;
        }
        return this.validRows;
    }

    @Override
    public int copyBinds(Statement toStmt, int offset) throws SQLException {
        if (this.numberOfBindPositions > 0) {
            OraclePreparedStatement to = (OraclePreparedStatement)toStmt;
            int metadata_offset = this.bindIndicatorSubRange + 5;
            int byteoffset = this.bindByteSubRange;
            int charoffset = this.bindCharSubRange;
            int indoffset = this.indicatorsOffset;
            int lenoffset = this.valueLengthsOffset;
            int indicatorRowCount = this.getAllocBindsRowCount();
            for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                short type = this.bindIndicators[metadata_offset + 0];
                int bytePitch = this.bindIndicators[metadata_offset + 1];
                int charPitch = this.bindIndicators[metadata_offset + 2];
                int toPos = bindPos + offset;
                if (this.bindIndicators[indoffset] == -1) {
                    to.currentRowBinders[toPos] = this.copiedNullBinder(type, bytePitch);
                    if (charPitch > 0) {
                        to.currentRowCharLens[toPos] = 1;
                    }
                } else if (type == 109 || type == 111) {
                    Binder fromBinder = this.lastBinders[bindPos];
                    to.currentRowBinders[toPos] = type == 109 ? new NamedTypeBinder(((NamedTypeBinder)fromBinder).paramVal, ((NamedTypeBinder)fromBinder).paramOtype) : new RefTypeBinder(((NamedTypeBinder)fromBinder).paramVal, ((NamedTypeBinder)fromBinder).paramOtype);
                    to.currentRowByteLens[toPos] = bytePitch;
                } else if (this.bindUseDBA) {
                    to.currentRowBinders[toPos] = this.copiedDataBinder(type, this.bindData, this.bindDataOffsets[bindPos], this.bindDataLengths[bindPos]);
                    to.currentRowDataLengths[toPos] = this.bindDataLengths[bindPos];
                    to.currentRowFormOfUse[toPos] = this.currentRowFormOfUse[bindPos];
                } else if (bytePitch > 0) {
                    to.currentRowBinders[toPos] = this.copiedByteBinder(type, this.bindBytes, byteoffset, bytePitch, this.bindIndicators[lenoffset]);
                    to.currentRowByteLens[toPos] = bytePitch;
                } else if (charPitch > 0) {
                    to.currentRowBinders[toPos] = this.copiedCharBinder(type, this.bindChars, charoffset, charPitch, this.bindIndicators[lenoffset], this.getInoutIndicator(bindPos));
                    to.currentRowCharLens[toPos] = charPitch;
                } else {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "copyBinds doesn't understand type " + type).fillInStackTrace();
                }
                byteoffset += this.bindBufferCapacity * bytePitch;
                charoffset += this.bindBufferCapacity * charPitch;
                indoffset += indicatorRowCount;
                lenoffset += indicatorRowCount;
                metadata_offset += 10;
            }
        }
        return this.numberOfBindPositions;
    }

    Binder copiedNullBinder(short type, int bytelen) throws SQLException {
        return new CopiedNullBinder(type, bytelen);
    }

    Binder copiedDataBinder(short type, ByteArray data, long offset, int length) throws SQLException {
        byte[] b = data.get(offset, length);
        return new CopiedDataBinder(type, b, length);
    }

    Binder copiedByteBinder(short type, byte[] bytes, int offset, int pitch, short len) throws SQLException {
        byte[] b = new byte[pitch];
        System.arraycopy(bytes, offset, b, 0, pitch);
        return new CopiedByteBinder(type, pitch, b, len);
    }

    Binder copiedCharBinder(short type, char[] chars, int offset, int pitch, short len, short inoutIndicatorValue) throws SQLException {
        char[] c = new char[pitch];
        System.arraycopy(chars, offset, c, 0, pitch);
        return new CopiedCharBinder(type, c, len, inoutIndicatorValue);
    }

    @Override
    protected void hardClose() throws SQLException {
        super.hardClose();
        this.releaseBuffers();
        if (!this.connection.isClosedInternal()) {
            this.cleanAllTempLobs();
        }
        this.lastBoundBytes = null;
        this.lastBoundChars = null;
    }

    @Override
    protected void alwaysOnClose() throws SQLException {
        if (this.currentRank > 0 && this.batchUpdate) {
            this.clearBatchCritical();
        }
        if (this.sqlKind.isSELECT()) {
            OracleStatement child = this.children;
            while (child != null) {
                OracleStatement n = child.nextChild;
                if (child.serverCursor) {
                    child.cursorId = 0;
                }
                child = n;
            }
        }
        super.alwaysOnClose();
    }

    @Override
    public void setDisableStmtCaching(boolean cache) {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (cache) {
                this.cacheState = 3;
            }
        }
    }

    @Override
    public void setFormOfUse(int paramIndex, short formOfUse) {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            try {
                this.setFormOfUseInternal(paramIndex, formOfUse, true);
            }
            catch (SQLException se) {
                throw new RuntimeException(se.getMessage());
            }
        }
    }

    void setFormOfUseInternal(int paramIndex, short formOfUse) throws SQLException {
        this.setFormOfUseInternal(paramIndex, formOfUse, false);
    }

    private void setFormOfUseInternal(int paramIndex, short formOfUse, boolean externalCall) throws SQLException {
        int i = paramIndex - 1;
        if (i < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (externalCall) {
            this.currentRowFormOfUseSet[i] = true;
        }
        if (this.currentRowFormOfUse[i] != formOfUse && (!this.currentRowFormOfUseSet[i] || externalCall)) {
            Accessor accessor;
            this.currentRowFormOfUse[i] = formOfUse;
            if (this.currentRowBindAccessors != null && (accessor = this.currentRowBindAccessors[i]) != null) {
                accessor.setFormOfUse(formOfUse);
            }
            if (this.accessors != null && (accessor = this.accessors[i]) != null) {
                accessor.setFormOfUse(formOfUse);
            }
        }
    }

    @Override
    public void setURL(int paramIndex, URL x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setURLInternal(paramIndex, x);
        }
    }

    void setURLInternal(int paramIndex, URL x) throws SQLException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setURLInternal", (String)null, "index={0}, value={1}. ", null, (Object)paramIndex, (Object)x);
        if (x == null) {
            this.setNull(paramIndex, 1);
        } else {
            this.setStringInternal(paramIndex, x.toString());
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            oracle.jdbc.internal.OracleParameterMetaData oracleParameterMetaData;
            this.connection.beginNonRequestCalls();
            try {
                this.ensureOpen();
                if (this.parameterMetadata == null) {
                    this.parameterMetadata = (oracle.jdbc.internal.OracleParameterMetaData)OracleParameterMetaData.getParameterMetaData(this.sqlObject, this.connection, this);
                }
                oracleParameterMetaData = this.parameterMetadata;
            }
            catch (Throwable throwable) {
                this.connection.endNonRequestCalls();
                throw throwable;
            }
            this.connection.endNonRequestCalls();
            return oracleParameterMetaData;
        }
    }

    @Override
    public oracle.jdbc.OracleParameterMetaData OracleGetParameterMetaData() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("OracleGetParameterMetaData").fillInStackTrace();
    }

    @Override
    public void registerReturnParameter(int paramIndex, int externalType) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int index;
            if (this.numberOfBindPositions <= 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90).fillInStackTrace();
            }
            if (this.numReturnParams <= 0) {
                this.numReturnParams = this.sqlObject.getReturnParameterCount();
                if (this.numReturnParams <= 0) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90).fillInStackTrace();
                }
            }
            if ((index = paramIndex - 1) < this.numberOfBindPositions - this.numReturnParams || paramIndex > this.numberOfBindPositions) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            int internalType = this.getInternalTypeForDmlReturning(externalType);
            if (internalType == 111 || internalType == 109 && externalType != 2007 && externalType != 2009) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "Use registerReturnParameter(int paramIndex, int externalType, String typeName) for user-defined or REF types").fillInStackTrace();
            }
            short form = 0;
            if (this.currentRowFormOfUse != null && this.currentRowFormOfUse[index] != 0) {
                form = this.currentRowFormOfUse[index];
            }
            this.registerReturnParameterInternal(index, internalType, externalType, -1, form, null);
            this.currentRowBinders[index] = this.theReturnParamBinder;
        }
    }

    @Override
    public void registerReturnParameter(int paramIndex, int externalType, int maxSize) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.numberOfBindPositions <= 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90).fillInStackTrace();
            }
            int index = paramIndex - 1;
            if (index < 0 || paramIndex > this.numberOfBindPositions) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (externalType != 1 && externalType != 12 && externalType != -1 && externalType != -2 && externalType != -3 && externalType != -4 && externalType != 12) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            if (maxSize <= 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            int internalType = this.getInternalTypeForDmlReturning(externalType);
            short form = 0;
            if (this.currentRowFormOfUse != null && this.currentRowFormOfUse[index] != 0) {
                form = this.currentRowFormOfUse[index];
            }
            this.registerReturnParameterInternal(index, internalType, externalType, maxSize, form, null);
            this.currentRowBinders[index] = this.theReturnParamBinder;
        }
    }

    @Override
    public void registerReturnParameter(int paramIndex, int externalType, String typeName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.numberOfBindPositions <= 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90).fillInStackTrace();
            }
            int index = paramIndex - 1;
            if (index < 0 || paramIndex > this.numberOfBindPositions) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            int internalType = this.getInternalTypeForDmlReturning(externalType);
            if (internalType != 111 && internalType != 109) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            this.registerReturnParameterInternal(index, internalType, externalType, -1, (short)0, typeName);
            this.currentRowBinders[index] = this.theReturnParamBinder;
        }
    }

    @Override
    public ResultSet getReturnResultSet() throws SQLException {
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
        if (this.accessors == null || this.numReturnParams == 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 144).fillInStackTrace();
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.currentResultSet == null || this.numReturnParams == 0 || !this.isOpen) {
                this.isAllFetched = true;
                this.currentResultSet = this.createResultSet();
            }
            OracleResultSet oracleResultSet = this.currentResultSet;
            return oracleResultSet;
        }
    }

    int getInternalTypeForDmlReturning(int externalType) throws SQLException {
        int result = 0;
        switch (externalType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                result = 6;
                break;
            }
            case 100: {
                result = 100;
                break;
            }
            case 101: {
                result = 101;
                break;
            }
            case -15: 
            case 1: {
                result = 96;
                break;
            }
            case -9: 
            case 12: {
                result = 1;
                break;
            }
            case -16: 
            case -1: {
                result = 8;
                break;
            }
            case 91: 
            case 92: {
                result = 12;
                break;
            }
            case 93: {
                result = 180;
                break;
            }
            case -101: 
            case 2013: 
            case 2014: {
                result = 181;
                break;
            }
            case -102: {
                result = 231;
                break;
            }
            case -103: {
                result = 182;
                break;
            }
            case -104: {
                result = 183;
                break;
            }
            case -3: 
            case -2: {
                result = 23;
                break;
            }
            case -4: {
                result = 24;
                break;
            }
            case -8: {
                result = 104;
                break;
            }
            case 2004: {
                result = 113;
                break;
            }
            case 2016: {
                result = 119;
                break;
            }
            case 2005: 
            case 2011: {
                result = 112;
                break;
            }
            case -13: {
                result = 114;
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: 
            case 2009: {
                result = 109;
                break;
            }
            case 2006: {
                result = 111;
                break;
            }
            case 70: {
                result = 1;
                break;
            }
            case -108: 
            case -107: 
            case -106: 
            case -105: {
                result = 127;
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        }
        return result;
    }

    protected final void initializeAutoKeyInfo() throws SQLException {
        if (this.autoKeyInfo == null) {
            return;
        }
        if (!this.autoKeyInfo.isInitialized()) {
            this.autoKeyInfo.initialize(this.connection);
        }
        this.registerReturnParamsForAutoKey();
    }

    private void initializeAutoKeyInfoAsync(Consumer<Throwable> callback) {
        if (this.autoKeyInfo == null) {
            callback.accept(null);
            return;
        }
        Consumer<Throwable> initializeCallback = error -> {
            if (error == null) {
                try {
                    this.registerReturnParamsForAutoKey();
                }
                catch (Exception exception) {
                    error = exception;
                }
            }
            callback.accept((Throwable)error);
        };
        if (this.autoKeyInfo.isInitialized()) {
            initializeCallback.accept(null);
        } else {
            this.autoKeyInfo.initializeAsync(this.connection, initializeCallback);
        }
    }

    private void registerReturnParamsForAutoKey() throws SQLException {
        assert (this.autoKeyInfo.isInitialized()) : "autoKeyInfo is not initialized";
        int numberOfReturnParams = this.autoKeyInfo.returnParameterCount();
        int startPos = this.numberOfBindPositions - numberOfReturnParams;
        this.offsetOfFirstUserColumn = startPos - 1;
        for (int i = 0; i < numberOfReturnParams; ++i) {
            this.registerGeneratedKeysParameter(i);
            if (!this.autoKeyInfo.isNChar(i)) continue;
            this.setFormOfUseInternal(startPos + i + 1, (short)2);
        }
    }

    @Override
    void resetOnExceptionDuringExecute() {
        super.resetOnExceptionDuringExecute();
        this.currentRank = 0;
        this.currentBatchNeedToPrepareBinds = true;
    }

    @Override
    void resetCurrentRowBinders() {
        Binder[] lastBoundRow = this.currentRowBinders;
        if (this.binders != null && this.currentRowBinders != null && lastBoundRow != this.binders[0]) {
            this.currentRowBinders = this.binders[0];
            this.binders[this.numberOfBoundRows] = lastBoundRow;
        }
    }

    void resetBindersToNull(int first_row_to_be_bound) {
    }

    boolean isThinDriver() {
        return true;
    }

    CharacterSet getCharacterSetForBind(int index, short formOfUse) {
        return formOfUse == 1 ? this.connection.conversion.clientCharSet : this.connection.conversion.serverNCharSet;
    }

    int getConversionCodeForCharacterStream(int index) {
        return 7;
    }

    @Override
    public void setAsciiStream(int paramIndex, InputStream istream) throws SQLException {
        this.setAsciiStreamInternal(paramIndex, istream);
    }

    @Override
    public void setAsciiStream(int paramIndex, InputStream istream, long length) throws SQLException {
        if (length < 0L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setAsciiStream cannot be negative").fillInStackTrace();
        }
        this.setAsciiStreamInternal(paramIndex, istream, length);
    }

    @Override
    public void setBinaryStream(int paramIndex, InputStream istream) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setBinaryStreamInternal(paramIndex, istream);
        }
    }

    @Override
    public void setBinaryStream(int paramIndex, InputStream istream, long length) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (length < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setBinaryStream cannot be negative").fillInStackTrace();
            }
            this.setBinaryStreamInternal(paramIndex, istream, length);
        }
    }

    @Override
    public void setBlob(int paramIndex, InputStream s) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setBlobInternal(paramIndex, s);
        }
    }

    @Override
    public void setBlob(int paramIndex, InputStream s, long length) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (length < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setBlob cannot be negative").fillInStackTrace();
            }
            this.setBlobInternal(paramIndex, s, length);
        }
    }

    @Override
    public void setCharacterStream(int paramIndex, Reader reader) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setCharacterStreamInternal(paramIndex, reader);
        }
    }

    @Override
    public void setCharacterStream(int paramIndex, Reader reader, long length) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (length < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setCharacterStream cannot be negative").fillInStackTrace();
            }
            this.setCharacterStreamInternal(paramIndex, reader, length);
        }
    }

    @Override
    public void setClob(int paramIndex, Reader reader, long length) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (length < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setClob() cannot be negative").fillInStackTrace();
            }
            this.setFormOfUseInternal(paramIndex, this.defaultFormOfUse);
            this.setClobInternal(paramIndex, reader, length);
        }
    }

    @Override
    public void setClob(int paramIndex, Reader reader) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setFormOfUseInternal(paramIndex, this.defaultFormOfUse);
            this.setClobInternal(paramIndex, reader);
        }
    }

    @Override
    public void setRowId(int paramIndex, RowId value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setRowIdInternal(paramIndex, value);
        }
    }

    @Override
    public void setNCharacterStream(int paramIndex, Reader reader) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setNCharacterStreamInternal(paramIndex, reader);
        }
    }

    @Override
    public void setNCharacterStream(int paramIndex, Reader reader, long length) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (length < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setNCharacterStream cannot be negative").fillInStackTrace();
            }
            this.setNCharacterStreamInternal(paramIndex, reader, length);
        }
    }

    @Override
    public void setNClob(int paramIndex, NClob value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setNClobInternal(paramIndex, value);
        }
    }

    @Override
    public void setNClob(int paramIndex, Reader reader, long length) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (length < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setNClob cannot be negative").fillInStackTrace();
            }
            this.setNClobInternal(paramIndex, reader, length);
        }
    }

    @Override
    public void setNClob(int paramIndex, Reader reader) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setNClobInternal(paramIndex, reader);
        }
    }

    @Override
    public void setSQLXML(int paramIndex, SQLXML value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setSQLXMLInternal(paramIndex, value);
        }
    }

    @Override
    public void setNString(int paramIndex, String value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setNStringInternal(paramIndex, value);
        }
    }

    void setAsciiStreamInternal(int paramIndex, InputStream istream) throws SQLException {
        this.setAsciiStreamInternal(paramIndex, istream, 0L, false);
    }

    void setAsciiStreamInternal(int paramIndex, InputStream istream, long length) throws SQLException {
        this.setAsciiStreamInternal(paramIndex, istream, length, true);
    }

    void setBinaryStreamInternal(int paramIndex, InputStream istream) throws SQLException {
        this.setBinaryStreamInternal(paramIndex, istream, 0L, false);
    }

    void setBinaryStreamInternal(int paramIndex, InputStream istream, long length) throws SQLException {
        this.setBinaryStreamInternal(paramIndex, istream, length, true);
    }

    void setBlobInternal(int paramIndex, InputStream istream, long length) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (istream == null) {
            this.setNullInternal(paramIndex, 2004);
        } else {
            this.setBinaryStreamContentsForBlobCritical(paramIndex, istream, length, length != -1L);
        }
    }

    void setBlobInternal(int paramIndex, InputStream istream) throws SQLException {
        this.setBlobInternal(paramIndex, istream, -1L);
    }

    void setCharacterStreamInternal(int paramIndex, Reader reader) throws SQLException {
        this.setCharacterStreamInternal(paramIndex, reader, 0L, false);
    }

    void setCharacterStreamInternal(int paramIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStreamInternal(paramIndex, reader, length, true);
    }

    void setClobInternal(int paramIndex, Reader reader) throws SQLException {
        this.setClobInternal(paramIndex, reader, -1L);
    }

    void setClobInternal(int paramIndex, Reader reader, long length) throws SQLException {
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (reader == null) {
            this.setNullInternal(paramIndex, 2005);
        } else {
            this.setReaderContentsForClobCritical(paramIndex, reader, length, length != -1L);
        }
    }

    void setNCharacterStreamInternal(int paramIndex, Reader reader) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.setFormOfUseInternal(paramIndex, (short)2);
        this.setCharacterStreamInternal(paramIndex, reader, 0L, false);
    }

    void setNCharacterStreamInternal(int paramIndex, Reader reader, long length) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.setFormOfUseInternal(paramIndex, (short)2);
        this.setCharacterStreamInternal(paramIndex, reader, length);
    }

    void setNClobInternal(int paramIndex, NClob value) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.setFormOfUseInternal(paramIndex, (short)2);
        this.setClobInternal(paramIndex, value);
    }

    void setNClobInternal(int paramIndex, Reader value) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.setFormOfUseInternal(paramIndex, (short)2);
        this.setClobInternal(paramIndex, value);
    }

    void setNClobInternal(int paramIndex, Reader value, long length) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (length < 0L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 43).fillInStackTrace();
        }
        this.setFormOfUseInternal(paramIndex, (short)2);
        this.setClobInternal(paramIndex, value, length);
    }

    void setNStringInternal(int paramIndex, String value) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.setFormOfUseInternal(paramIndex, (short)2);
        this.setStringInternal(paramIndex, value);
    }

    void setRowIdInternal(int paramIndex, RowId rowid) throws SQLException {
        this.setROWIDInternal(paramIndex, (ROWID)rowid);
    }

    void setTTCData(int paramIndex, TTCData ttcData) throws SQLException {
        byte[] encoding;
        if (ttcData == null || (encoding = ttcData.getTTCEncoding()) == null) {
            this.setNullInternal(paramIndex, 0);
            return;
        }
        if (paramIndex < 1 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.setFormOfUseInternal(paramIndex, ttcData.getFormOfUse());
        DatumBinder binder = new DatumBinder(encoding){
            Binder copyingBinder;
            {
                this.copyingBinder = null;
            }

            @Override
            Binder copyingBinder() {
                if (this.copyingBinder == null) {
                    this.copyingBinder = new ByteCopyingBinder(){};
                    this.copyingBinder.type = this.type;
                }
                return this.copyingBinder;
            }
        };
        binder.type = ttcData.getTTCType();
        binder.bytelen = encoding.length;
        int index = paramIndex - 1;
        this.currentRowBinders[index] = binder;
        this.currentRowByteLens[index] = encoding.length;
        this.currentRowCharLens[index] = 0;
    }

    private void setVectorInternal(int paramIndex, Object value, int targetSQLType) throws SQLException {
        Binder binder;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setVectorInternal", (String)null, "index={0}, value={1}, targetSqlType={2}. ", null, (Object)paramIndex, value, (Object)targetSQLType);
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.currentRowBinders[index] = binder = this.createVectorBinder(value, targetSQLType, false);
        this.currentRowByteLens[index] = binder.bytelen;
        this.currentRowCharLens[index] = 0;
    }

    protected Binder createVectorBinder(Object value, int targetSqlType, boolean isComputingNorm) throws SQLException {
        if (value == null) {
            return new VectorNullBinder();
        }
        if (value instanceof VECTOR) {
            return new VectorDatumBinder((VECTOR)value);
        }
        return new VectorBinder<Object>(value, targetSqlType, isComputingNorm);
    }

    @Override
    public void setObject(int parameterIndex, Object value, SQLType targetSqlType) throws SQLException {
        if (targetSqlType == null) {
            throw new IllegalArgumentException("null SQLType");
        }
        this.setObject(parameterIndex, value, targetSqlType, 0);
    }

    @Override
    public void setObject(int parameterIndex, Object value, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (targetSqlType == null) {
                throw new IllegalArgumentException("null SQLType");
            }
            if (value == null) {
                this.setObject(parameterIndex, value, targetSqlType.getVendorTypeNumber(), scaleOrLength);
            } else if (targetSqlType == JDBCType.DATE) {
                DATE tempDate = null;
                tempDate = value instanceof DATE ? (DATE)value : (value instanceof Date ? new DATE(value, this.getDefaultCalendar()) : (value instanceof Timestamp ? new DATE((Timestamp)value) : (value instanceof String ? new DATE(Date.valueOf((String)value)) : JavaToJavaConverter.convert(value, DATE.class, this.connection, scaleOrLength, null))));
                this.setDATE(parameterIndex, tempDate.zeroTime());
            } else {
                this.setObject(parameterIndex, value, targetSqlType.getVendorTypeNumber(), scaleOrLength);
            }
        }
    }

    private static Time convertStringToTime(String string, boolean use1900AsYear) {
        Time time;
        string = ((String)string).trim();
        if (MAP_TIME_TO_TIMESTAMP && ((String)string).contains(".")) {
            int spaceIndex = ((String)string).indexOf(" ");
            if (((String)string).length() > 11 && spaceIndex > -1) {
                string = ((String)string).substring(spaceIndex + 1);
            }
            String date = (use1900AsYear ? "1900" : "1970") + "-01-01";
            string = date + " " + (String)string;
            time = new Time(Timestamp.valueOf((String)string).getTime());
        } else {
            time = Time.valueOf((String)string);
        }
        return time;
    }

    @Override
    public void setArrayAtName(String paramName, java.sql.Array x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setArray(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setBigDecimalAtName(String paramName, BigDecimal x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setBigDecimal(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setBlobAtName(String paramName, Blob x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setBlob(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setBooleanAtName(String paramName, boolean x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setBoolean(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setByteAtName(String paramName, byte x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setByte(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setBytesAtName(String paramName, byte[] x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setBytes(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setClobAtName(String paramName, Clob x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setClob(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setDateAtName(String paramName, Date x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setDate(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setDateAtName(String paramName, Date x, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setDate(i + 1, x, y);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setDoubleAtName(String paramName, double x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setDouble(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setFloatAtName(String paramName, float x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setFloat(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setIntAtName(String paramName, int x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setInt(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setLongAtName(String paramName, long x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setLong(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setNClobAtName(String paramName, NClob x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setNClob(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setNStringAtName(String paramName, String x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setNString(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setObjectAtName(String paramName, Object x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setObject(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setObjectAtName(String paramName, Object x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setObject(i + 1, x, y);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setRefAtName(String paramName, Ref x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setRef(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setRowIdAtName(String paramName, RowId x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setRowId(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setShortAtName(String paramName, short x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setShort(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setSQLXMLAtName(String paramName, SQLXML x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setSQLXML(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setStringAtName(String paramName, String x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setString(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setTimeAtName(String paramName, Time x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setTime(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setTimeAtName(String paramName, Time x, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setTime(i + 1, x, y);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setTimestampAtName(String paramName, Timestamp x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setTimestamp(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setTimestampAtName(String paramName, Timestamp x, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setTimestamp(i + 1, x, y);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setURLAtName(String paramName, URL x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setURL(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setARRAYAtName(String paramName, ARRAY x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setARRAY(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setBFILEAtName(String paramName, BFILE x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setBFILE(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setBfileAtName(String paramName, BFILE x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setBfile(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setBinaryFloatAtName(String paramName, float x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setBinaryFloat(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setBinaryFloatAtName(String paramName, BINARY_FLOAT x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setBinaryFloat(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setBinaryDoubleAtName(String paramName, double x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setBinaryDouble(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setBinaryDoubleAtName(String paramName, BINARY_DOUBLE x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setBinaryDouble(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setBLOBAtName(String paramName, BLOB x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setBLOB(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setCHARAtName(String paramName, CHAR x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setCHAR(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setCLOBAtName(String paramName, CLOB x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setCLOB(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setCursorAtName(String paramName, ResultSet x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setCursor(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setDATEAtName(String paramName, DATE x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setDATE(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setFixedCHARAtName(String paramName, String x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setFixedCHAR(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setINTERVALDSAtName(String paramName, INTERVALDS x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setINTERVALDS(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setINTERVALYMAtName(String paramName, INTERVALYM x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setINTERVALYM(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setNUMBERAtName(String paramName, NUMBER x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setNUMBER(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setOPAQUEAtName(String paramName, OPAQUE x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setOPAQUE(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setOracleObjectAtName(String paramName, Datum x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setOracleObject(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setORADataAtName(String paramName, ORAData x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setORAData(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setRAWAtName(String paramName, RAW x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setRAW(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setREFAtName(String paramName, REF x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setREF(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setRefTypeAtName(String paramName, REF x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setRefType(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setROWIDAtName(String paramName, ROWID x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setROWID(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setSTRUCTAtName(String paramName, STRUCT x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setSTRUCT(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setTIMESTAMPLTZAtName(String paramName, TIMESTAMPLTZ x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setTIMESTAMPLTZ(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setTIMESTAMPTZAtName(String paramName, TIMESTAMPTZ x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setTIMESTAMPTZ(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setTIMESTAMPAtName(String paramName, TIMESTAMP x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setTIMESTAMP(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setCustomDatumAtName(String paramName, CustomDatum x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                this.setCustomDatum(i + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setBlobAtName(String paramName, InputStream x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setBlob(i + 1, x);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setBlobAtName(String paramName, InputStream x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setBlob(i + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setClobAtName(String paramName, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setClob(i + 1, x);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setClobAtName(String paramName, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setClob(i + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setNClobAtName(String paramName, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setNClob(i + 1, x);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setNClobAtName(String paramName, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setNClob(i + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setAsciiStreamAtName(String paramName, InputStream x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setAsciiStream(i + 1, x);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setAsciiStreamAtName(String paramName, InputStream x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setAsciiStream(i + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setAsciiStreamAtName(String paramName, InputStream x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setAsciiStream(i + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setBinaryStreamAtName(String paramName, InputStream x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setBinaryStream(i + 1, x);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setBinaryStreamAtName(String paramName, InputStream x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setBinaryStream(i + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setBinaryStreamAtName(String paramName, InputStream x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setBinaryStream(i + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setCharacterStreamAtName(String paramName, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setCharacterStream(i + 1, x);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setCharacterStreamAtName(String paramName, Reader x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setCharacterStream(i + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setCharacterStreamAtName(String paramName, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setCharacterStream(i + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setNCharacterStreamAtName(String paramName, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setNCharacterStream(i + 1, x);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setNCharacterStreamAtName(String paramName, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setNCharacterStream(i + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    @Override
    public void setUnicodeStreamAtName(String paramName, InputStream x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (paramName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.setUnicodeStream(i + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName).fillInStackTrace();
            }
        }
    }

    private static final class Pair
    implements Comparable<Pair> {
        private final int index;
        private final long offset;

        Pair(int i, long o) {
            this.index = i;
            this.offset = o;
        }

        @Override
        public int compareTo(Pair other) {
            return this.offset == other.offset ? 0 : (this.offset < other.offset ? -1 : 1);
        }

        public int getIndex() {
            return this.index;
        }
    }

    class BatchFIFONode {
        int counter;
        int[] currentBatchByteLens;
        int[] currentBatchCharLens;
        int[] lastBoundByteLens;
        int[] lastBoundCharLens;
        Accessor[] currentBatchBindAccessors;
        boolean lastBoundNeeded;
        boolean need_to_parse;
        boolean current_batch_need_to_prepare_binds;
        int first_row_in_batch;
        int number_of_rows_to_be_bound;
        BatchFIFONode next;

        BatchFIFONode() {
        }
    }
}

