/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.oracle;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.AbstractJdbcQueries;
import io.kestra.plugin.jdbc.oracle.OracleCellConverter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.ZoneId;
import lombok.Generated;
import oracle.jdbc.OracleDriver;

@Schema(title="Perform multiple queries on an Oracle database.")
@Plugin(examples={@Example(full=true, title="Execute multiple queries and get the results.", code={"id: oracle_query\nnamespace: company.team\n\ntasks:\n  - id: select\n    type: io.kestra.plugin.jdbc.oracle.Queries\n    url: jdbc:oracle:thin:@localhost:49161:XE\n    username: oracle_user\n    password: oracle_password\n    sql: select * from employee; select * from laptop;\n    fetchType: FETCH\n"})})
public class Queries
extends AbstractJdbcQueries
implements RunnableTask<AbstractJdbcQueries.MultiQueryOutput> {
    @Override
    protected AbstractCellConverter getCellConverter(ZoneId zoneId) {
        return new OracleCellConverter(zoneId);
    }

    @Override
    public void registerDriver() throws SQLException {
        DriverManager.registerDriver(new OracleDriver());
    }

    @Generated
    protected Queries(QueriesBuilder<?, ?> b) {
        super((AbstractJdbcQueries.AbstractJdbcQueriesBuilder<?, ?>)b);
    }

    @Generated
    public static QueriesBuilder<?, ?> builder() {
        return new QueriesBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Queries(super=" + super.toString() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Queries)) {
            return false;
        }
        Queries other = (Queries)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Queries;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public Queries() {
    }

    @Generated
    private static final class QueriesBuilderImpl
    extends QueriesBuilder<Queries, QueriesBuilderImpl> {
        @Generated
        private QueriesBuilderImpl() {
        }

        @Override
        @Generated
        protected QueriesBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Queries build() {
            return new Queries(this);
        }
    }

    @Generated
    public static abstract class QueriesBuilder<C extends Queries, B extends QueriesBuilder<C, B>>
    extends AbstractJdbcQueries.AbstractJdbcQueriesBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Queries.QueriesBuilder(super=" + super.toString() + ")";
        }
    }
}

