/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.oracle;

import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.AbstractJdbcBatch;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OracleCellConverter
extends AbstractCellConverter {
    public OracleCellConverter(ZoneId zoneId) {
        super(zoneId);
    }

    @Override
    public Object convertCell(int columnIndex, ResultSet rs, Connection connection) throws SQLException {
        Object data = rs.getObject(columnIndex);
        if (data == null) {
            return null;
        }
        Object columnVal = rs.getObject(columnIndex);
        String columnTypeName = rs.getMetaData().getColumnTypeName(columnIndex);
        if (columnVal instanceof BLOB) {
            BLOB col = (BLOB)columnVal;
            return col.getBytes(1L, Long.valueOf(col.length()).intValue());
        }
        if (columnVal instanceof CLOB) {
            CLOB col = (CLOB)columnVal;
            return col.getSubString(1L, (int)col.length());
        }
        if (columnVal instanceof TIMESTAMP) {
            TIMESTAMP col = (TIMESTAMP)columnVal;
            return col.toLocalDateTime();
        }
        if (columnVal instanceof TIMESTAMPTZ) {
            TIMESTAMPTZ col = (TIMESTAMPTZ)columnVal;
            return col.toOffsetDateTime().toZonedDateTime();
        }
        if (columnVal instanceof TIMESTAMPLTZ) {
            TIMESTAMPLTZ col = (TIMESTAMPLTZ)columnVal;
            return col.toLocalDateTime(connection);
        }
        if (columnTypeName.equals("DATE")) {
            return ((Timestamp)data).toLocalDateTime().toLocalDate();
        }
        return super.convert(columnIndex, rs);
    }

    @Override
    protected PreparedStatement addPreparedStatementValue(PreparedStatement ps, AbstractJdbcBatch.ParameterType parameterType, Object value, int index, Connection connection) throws Exception {
        Class<?> cls = parameterType.getClass(index);
        if (cls == TIMESTAMP.class) {
            if (value instanceof LocalDateTime) {
                ps.setTimestamp(index, Timestamp.valueOf((LocalDateTime)value));
                return ps;
            }
        } else if (cls == TIMESTAMPTZ.class) {
            if (value instanceof ZonedDateTime) {
                ZonedDateTime current = (ZonedDateTime)value;
                ps.setTimestamp(index, Timestamp.valueOf(current.toLocalDateTime()), Calendar.getInstance(TimeZone.getTimeZone(current.getZone())));
                return ps;
            }
        } else if (cls == TIMESTAMPLTZ.class && value instanceof LocalDateTime) {
            ps.setTimestamp(index, Timestamp.valueOf((LocalDateTime)value));
            return ps;
        }
        return super.addPreparedStatementValue(ps, parameterType, value, index, connection);
    }
}

