/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.MDC;

public final class LoggingContext
implements AutoCloseable {
    public static final String CONNECTOR_CONTEXT = "connector.context";
    public static final Collection<String> ALL_CONTEXTS = Collections.singleton("connector.context");
    private final Map<String, String> previous = MDC.getCopyOfContextMap();

    public static void clear() {
        MDC.clear();
    }

    public static LoggingContext forConnector(String connectorName) {
        Objects.requireNonNull(connectorName);
        LoggingContext context = new LoggingContext();
        MDC.put(CONNECTOR_CONTEXT, LoggingContext.prefixFor(connectorName, Scope.WORKER, null));
        return context;
    }

    public static LoggingContext forValidation(String connectorName) {
        LoggingContext context = new LoggingContext();
        MDC.put(CONNECTOR_CONTEXT, LoggingContext.prefixFor(connectorName, Scope.VALIDATE, null));
        return context;
    }

    public static LoggingContext forTask(ConnectorTaskId id) {
        Objects.requireNonNull(id);
        LoggingContext context = new LoggingContext();
        MDC.put(CONNECTOR_CONTEXT, LoggingContext.prefixFor(id.connector(), Scope.TASK, id.task()));
        return context;
    }

    public static LoggingContext forOffsets(ConnectorTaskId id) {
        Objects.requireNonNull(id);
        LoggingContext context = new LoggingContext();
        MDC.put(CONNECTOR_CONTEXT, LoggingContext.prefixFor(id.connector(), Scope.OFFSETS, id.task()));
        return context;
    }

    static String prefixFor(String connectorName, Scope scope, Integer taskNumber) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(connectorName);
        if (taskNumber != null) {
            sb.append("|");
            sb.append((Object)Scope.TASK);
            sb.append("-");
            sb.append(taskNumber);
        }
        if (scope != Scope.TASK) {
            sb.append("|");
            sb.append(scope.toString());
        }
        sb.append("] ");
        return sb.toString();
    }

    private LoggingContext() {
    }

    @Override
    public void close() {
        for (String param : ALL_CONTEXTS) {
            if (this.previous != null && this.previous.containsKey(param)) {
                MDC.put(param, this.previous.get(param));
                continue;
            }
            MDC.remove(param);
        }
    }

    public static enum Scope {
        WORKER("worker"),
        TASK("task"),
        OFFSETS("offsets"),
        VALIDATE("validate");

        private final String text;

        private Scope(String value) {
            this.text = value;
        }

        public String toString() {
            return this.text;
        }
    }
}

