/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.storage;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.storage.OffsetBackingStore;
import org.apache.kafka.connect.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MemoryOffsetBackingStore
implements OffsetBackingStore {
    private static final Logger log = LoggerFactory.getLogger(MemoryOffsetBackingStore.class);
    protected Map<ByteBuffer, ByteBuffer> data = new HashMap<ByteBuffer, ByteBuffer>();
    protected ExecutorService executor;

    @Override
    public void configure(WorkerConfig config) {
    }

    @Override
    public void start() {
        this.executor = Executors.newFixedThreadPool(1, ThreadUtils.createThreadFactory(this.getClass().getSimpleName() + "-%d", false));
    }

    @Override
    public void stop() {
        if (this.executor != null) {
            ThreadUtils.shutdownExecutorServiceQuietly(this.executor, 30L, TimeUnit.SECONDS);
            this.executor = null;
        }
    }

    @Override
    public Future<Map<ByteBuffer, ByteBuffer>> get(Collection<ByteBuffer> keys) {
        return this.executor.submit(() -> {
            HashMap<ByteBuffer, ByteBuffer> result = new HashMap<ByteBuffer, ByteBuffer>();
            for (ByteBuffer key : keys) {
                result.put(key, this.data.get(key));
            }
            return result;
        });
    }

    @Override
    public Future<Void> set(Map<ByteBuffer, ByteBuffer> values, Callback<Void> callback) {
        return this.executor.submit(() -> {
            this.data.putAll(values);
            this.save();
            if (callback != null) {
                callback.onCompletion(null, null);
            }
            return null;
        });
    }

    protected void save() {
    }

    @Override
    public abstract Set<Map<String, Object>> connectorPartitions(String var1);
}

