/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.distributed;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.runtime.distributed.ConnectProtocolCompatibility;
import org.apache.kafka.connect.runtime.distributed.DistributedConfig;
import org.apache.kafka.connect.runtime.distributed.ExtendedAssignment;
import org.apache.kafka.connect.runtime.distributed.WorkerCoordinator;
import org.apache.kafka.connect.runtime.distributed.WorkerRebalanceListener;
import org.apache.kafka.connect.storage.ConfigBackingStore;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.Logger;

public class WorkerGroupMember {
    private static final String JMX_PREFIX = "kafka.connect";
    private final Logger log;
    private final String clientId;
    private final ConsumerNetworkClient client;
    private final Metrics metrics;
    private final WorkerCoordinator coordinator;
    private boolean stopped = false;

    public WorkerGroupMember(DistributedConfig config, String restUrl, ConfigBackingStore configStorage, WorkerRebalanceListener listener, Time time, String clientId, LogContext logContext) {
        try {
            this.clientId = clientId;
            this.log = logContext.logger(WorkerGroupMember.class);
            LinkedHashMap<String, String> metricsTags = new LinkedHashMap<String, String>();
            metricsTags.put("client-id", clientId);
            MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples")).timeWindow(config.getLong("metrics.sample.window.ms"), TimeUnit.MILLISECONDS).tags(metricsTags);
            List<MetricsReporter> reporters = CommonClientConfigs.metricsReporters(clientId, (AbstractConfig)config);
            HashMap<String, Object> contextLabels = new HashMap<String, Object>();
            contextLabels.putAll(config.originalsWithPrefix("metrics.context."));
            contextLabels.put("connect.kafka.cluster.id", config.kafkaClusterId());
            contextLabels.put("connect.group.id", config.getString("group.id"));
            KafkaMetricsContext metricsContext = new KafkaMetricsContext(JMX_PREFIX, contextLabels);
            this.metrics = new Metrics(metricConfig, reporters, time, metricsContext);
            long retryBackoffMs = config.getLong("retry.backoff.ms");
            long retryBackoffMaxMs = config.getLong("retry.backoff.max.ms");
            Metadata metadata = new Metadata(retryBackoffMs, retryBackoffMaxMs, config.getLong("metadata.max.age.ms"), logContext, new ClusterResourceListeners());
            List<InetSocketAddress> addresses = ClientUtils.parseAndValidateAddresses(config.getList("bootstrap.servers"), config.getString("client.dns.lookup"));
            metadata.bootstrap(addresses);
            String metricGrpPrefix = "connect";
            ChannelBuilder channelBuilder = ClientUtils.createChannelBuilder(config, time, logContext);
            NetworkClient netClient = new NetworkClient((Selectable)new Selector(config.getLong("connections.max.idle.ms"), this.metrics, time, metricGrpPrefix, channelBuilder, logContext), metadata, clientId, 100, (long)config.getLong("reconnect.backoff.ms"), (long)config.getLong("reconnect.backoff.max.ms"), (int)config.getInt("send.buffer.bytes"), (int)config.getInt("receive.buffer.bytes"), (int)config.getInt("request.timeout.ms"), (long)config.getLong("socket.connection.setup.timeout.ms"), (long)config.getLong("socket.connection.setup.timeout.max.ms"), time, true, new ApiVersions(), logContext);
            this.client = new ConsumerNetworkClient(logContext, netClient, metadata, time, retryBackoffMs, config.getInt("request.timeout.ms"), Integer.MAX_VALUE);
            this.coordinator = new WorkerCoordinator(new GroupRebalanceConfig(config, GroupRebalanceConfig.ProtocolType.CONNECT), logContext, this.client, this.metrics, metricGrpPrefix, time, restUrl, configStorage, listener, ConnectProtocolCompatibility.compatibility(config.getString("connect.protocol")), config.getInt("scheduled.rebalance.max.delay.ms"));
            AppInfoParser.registerAppInfo(JMX_PREFIX, clientId, this.metrics, time.milliseconds());
            this.log.debug("Connect group member created");
        }
        catch (Throwable t) {
            this.stop(true);
            throw new KafkaException("Failed to construct kafka consumer", t);
        }
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stop(false);
    }

    public void ensureActive(Supplier<Utils.UncheckedCloseable> onPoll) {
        this.coordinator.poll(0L, onPoll);
    }

    public void poll(long timeout, Supplier<Utils.UncheckedCloseable> onPoll) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout must not be negative");
        }
        this.coordinator.poll(timeout, onPoll);
    }

    public void wakeup() {
        this.client.wakeup();
    }

    public String memberId() {
        return this.coordinator.memberId();
    }

    public void requestRejoin() {
        this.coordinator.requestRejoin("connect worker requested rejoin");
    }

    public void maybeLeaveGroup(String leaveReason) {
        this.coordinator.maybeLeaveGroup(leaveReason);
    }

    public String ownerUrl(String connector) {
        return this.coordinator.ownerUrl(connector);
    }

    public String ownerUrl(ConnectorTaskId task) {
        return this.coordinator.ownerUrl(task);
    }

    public short currentProtocolVersion() {
        return this.coordinator.currentProtocolVersion();
    }

    public void revokeAssignment(ExtendedAssignment assignment) {
        this.coordinator.revokeAssignment(assignment);
    }

    private void stop(boolean swallowException) {
        this.log.trace("Stopping the Connect group member.");
        AtomicReference<Throwable> firstException = new AtomicReference<Throwable>();
        this.stopped = true;
        Utils.closeQuietly((AutoCloseable)this.coordinator, "coordinator", firstException);
        Utils.closeQuietly((AutoCloseable)this.metrics, "consumer metrics", firstException);
        Utils.closeQuietly((AutoCloseable)this.client, "consumer network client", firstException);
        AppInfoParser.unregisterAppInfo(JMX_PREFIX, this.clientId, this.metrics);
        if (firstException.get() != null && !swallowException) {
            throw new KafkaException("Failed to stop the Connect group member", firstException.get());
        }
        this.log.debug("The Connect group member has stopped.");
    }

    Metrics metrics() {
        return this.metrics;
    }
}

