/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.debezium.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.debezium.data.Envelope;
import io.kestra.plugin.debezium.models.Message;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.Generated;

public class Envelope
extends Message {
    @JsonIgnore
    @Nullable
    Envelope.Operation operation;
    @JsonIgnore
    @Nullable
    Instant timestamp;
    @Nullable
    Map<String, Object> before;
    @Nullable
    Map<String, Object> after;
    @Nullable
    Map<String, Object> transaction;

    @JsonGetter(value="op")
    public String getOp() {
        return this.operation != null ? this.operation.code() : null;
    }

    public void setOp(String value) {
        this.operation = Envelope.Operation.forCode(value);
    }

    @JsonGetter(value="ts_ms")
    public Long getTs() {
        return this.timestamp != null ? Long.valueOf(this.timestamp.toEpochMilli()) : null;
    }

    @JsonSetter(value="ts_ms")
    public void setTsMs(Long value) {
        this.timestamp = Instant.ofEpochMilli(value);
    }

    @Nullable
    @Generated
    public Envelope.Operation getOperation() {
        return this.operation;
    }

    @Nullable
    @Generated
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    @Generated
    public Map<String, Object> getBefore() {
        return this.before;
    }

    @Nullable
    @Generated
    public Map<String, Object> getAfter() {
        return this.after;
    }

    @Nullable
    @Generated
    public Map<String, Object> getTransaction() {
        return this.transaction;
    }

    @JsonIgnore
    @Generated
    public void setOperation(@Nullable Envelope.Operation operation) {
        this.operation = operation;
    }

    @JsonIgnore
    @Generated
    public void setTimestamp(@Nullable Instant timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setBefore(@Nullable Map<String, Object> before) {
        this.before = before;
    }

    @Generated
    public void setAfter(@Nullable Map<String, Object> after) {
        this.after = after;
    }

    @Generated
    public void setTransaction(@Nullable Map<String, Object> transaction) {
        this.transaction = transaction;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Envelope)) {
            return false;
        }
        Envelope other = (Envelope)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Envelope.Operation this$operation = this.getOperation();
        Envelope.Operation other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Map<String, Object> this$before = this.getBefore();
        Map<String, Object> other$before = other.getBefore();
        if (this$before == null ? other$before != null : !((Object)this$before).equals(other$before)) {
            return false;
        }
        Map<String, Object> this$after = this.getAfter();
        Map<String, Object> other$after = other.getAfter();
        if (this$after == null ? other$after != null : !((Object)this$after).equals(other$after)) {
            return false;
        }
        Map<String, Object> this$transaction = this.getTransaction();
        Map<String, Object> other$transaction = other.getTransaction();
        return !(this$transaction == null ? other$transaction != null : !((Object)this$transaction).equals(other$transaction));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Envelope;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Envelope.Operation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Map<String, Object> $before = this.getBefore();
        result = result * 59 + ($before == null ? 43 : ((Object)$before).hashCode());
        Map<String, Object> $after = this.getAfter();
        result = result * 59 + ($after == null ? 43 : ((Object)$after).hashCode());
        Map<String, Object> $transaction = this.getTransaction();
        result = result * 59 + ($transaction == null ? 43 : ((Object)$transaction).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Envelope(super=" + super.toString() + ", operation=" + String.valueOf((Object)this.getOperation()) + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", before=" + String.valueOf(this.getBefore()) + ", after=" + String.valueOf(this.getAfter()) + ", transaction=" + String.valueOf(this.getTransaction()) + ")";
    }

    @ConstructorProperties(value={"operation", "timestamp", "before", "after", "transaction"})
    @Generated
    public Envelope(@Nullable Envelope.Operation operation, @Nullable Instant timestamp, @Nullable Map<String, Object> before, @Nullable Map<String, Object> after, @Nullable Map<String, Object> transaction) {
        this.operation = operation;
        this.timestamp = timestamp;
        this.before = before;
        this.after = after;
        this.transaction = transaction;
    }
}

