/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.DebeziumException;
import java.io.File;
import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;

public interface SchemaResource {
    public static final String SCHEMA_ENDPOINT = "/schema";
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public String getSchemaFilePath();

    @GET
    @Path(value="/schema")
    default public JsonNode getConnectorSchema() {
        try {
            return MAPPER.readValue(this.getClass().getResourceAsStream(this.getSchemaFilePath()), JsonNode.class);
        }
        catch (IOException e) {
            throw new DebeziumException("Unable to open \"" + this.getSchemaFilePath().substring(this.getSchemaFilePath().lastIndexOf(File.separator) + 1) + "\" schema file.", e);
        }
    }
}

