/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.signal.actions.snapshotting;

import io.debezium.DebeziumException;
import io.debezium.document.Array;
import io.debezium.document.Document;
import io.debezium.document.Value;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.signal.SignalPayload;
import io.debezium.pipeline.signal.actions.AbstractSnapshotSignal;
import io.debezium.pipeline.signal.actions.snapshotting.AdditionalCondition;
import io.debezium.pipeline.signal.actions.snapshotting.SnapshotConfiguration;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Strings;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteSnapshot<P extends Partition>
extends AbstractSnapshotSignal<P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteSnapshot.class);
    public static final String NAME = "execute-snapshot";
    private static final String MATCH_ALL_PATTERN = ".*";
    private final EventDispatcher<P, ? extends DataCollectionId> dispatcher;
    private final ChangeEventSourceCoordinator<P, ? extends OffsetContext> changeEventSourceCoordinator;

    public ExecuteSnapshot(EventDispatcher<P, ? extends DataCollectionId> dispatcher, ChangeEventSourceCoordinator<P, ?> changeEventSourceCoordinator) {
        this.dispatcher = dispatcher;
        this.changeEventSourceCoordinator = changeEventSourceCoordinator;
    }

    @Override
    public boolean arrived(SignalPayload<P> signalPayload) throws InterruptedException {
        List<String> dataCollections = ExecuteSnapshot.getDataCollections(signalPayload.data);
        if (dataCollections == null) {
            return false;
        }
        AbstractSnapshotSignal.SnapshotType type = ExecuteSnapshot.getSnapshotType(signalPayload.data);
        List<AdditionalCondition> additionalConditions = this.getAdditionalConditions(signalPayload.data, type);
        Optional<String> surrogateKey = ExecuteSnapshot.getSurrogateKey(signalPayload.data);
        LOGGER.info("Requested '{}' snapshot of data collections '{}' with additional conditions '{}' and surrogate key '{}'", new Object[]{type, dataCollections, additionalConditions, surrogateKey.orElse("PK of table will be used")});
        SnapshotConfiguration.Builder snapsthoConfigurationBuilder = SnapshotConfiguration.Builder.builder();
        snapsthoConfigurationBuilder.dataCollections(dataCollections);
        snapsthoConfigurationBuilder.surrogateKey(surrogateKey.orElse(""));
        additionalConditions.forEach(snapsthoConfigurationBuilder::addCondition);
        switch (type) {
            case INCREMENTAL: {
                if (this.dispatcher.getIncrementalSnapshotChangeEventSource() == null) {
                    throw new DebeziumException("Incremental snapshot is not properly configured, either sinalling data collection is not provided or connector-specific snapshotting not set");
                }
                this.dispatcher.getIncrementalSnapshotChangeEventSource().addDataCollectionNamesToSnapshot(signalPayload, snapsthoConfigurationBuilder.build());
                break;
            }
            case BLOCKING: {
                this.changeEventSourceCoordinator.doBlockingSnapshot(signalPayload.partition, signalPayload.offsetContext, snapsthoConfigurationBuilder.build());
            }
        }
        return true;
    }

    private List<AdditionalCondition> getAdditionalConditions(Document data, AbstractSnapshotSignal.SnapshotType type) {
        Optional<String> oldAdditionalConditionField = ExecuteSnapshot.getAdditionalCondition(data);
        if (oldAdditionalConditionField.isPresent() && type.equals((Object)AbstractSnapshotSignal.SnapshotType.INCREMENTAL)) {
            return List.of(AdditionalCondition.AdditionalConditionBuilder.builder().dataCollection(Pattern.compile(MATCH_ALL_PATTERN, 2)).filter(oldAdditionalConditionField.orElse("")).build());
        }
        return Optional.ofNullable(data.getArray("additional-conditions")).orElse(Array.create()).streamValues().map(this::buildAdditionalCondition).collect(Collectors.toList());
    }

    private AdditionalCondition buildAdditionalCondition(Value value) {
        return AdditionalCondition.AdditionalConditionBuilder.builder().dataCollection(Pattern.compile(value.asDocument().getString("data-collection"), 2)).filter(value.asDocument().getString("filter")).build();
    }

    public static List<String> getDataCollections(Document data) {
        Array dataCollectionsArray = data.getArray("data-collections");
        if (dataCollectionsArray == null || dataCollectionsArray.isEmpty()) {
            LOGGER.warn("Execute snapshot signal '{}' has arrived but the requested field '{}' is missing from data or is empty", (Object)data, (Object)"data-collections");
            return null;
        }
        return dataCollectionsArray.streamValues().map(v -> v.asString().trim()).collect(Collectors.toList());
    }

    @Deprecated
    public static Optional<String> getAdditionalCondition(Document data) {
        String additionalCondition = data.getString("additional-condition");
        return Strings.isNullOrBlank(additionalCondition) ? Optional.empty() : Optional.of(additionalCondition);
    }

    public static Optional<String> getSurrogateKey(Document data) {
        String surrogateKey = data.getString("surrogate-key");
        return Strings.isNullOrBlank(surrogateKey) ? Optional.empty() : Optional.of(surrogateKey);
    }
}

