/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded.async;

import io.debezium.util.DelayStrategy;
import java.util.concurrent.Callable;
import org.apache.kafka.connect.errors.RetriableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RetryingCallable<V>
implements Callable<V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryingCallable.class);
    private final int retries;

    public RetryingCallable(int retries) {
        this.retries = retries;
    }

    public abstract V doCall() throws Exception;

    public abstract DelayStrategy delayStrategy();

    @Override
    public V call() throws Exception {
        DelayStrategy delayStrategy = this.delayStrategy();
        int attempts = this.retries;
        while (attempts != 0) {
            try {
                return this.doCall();
            }
            catch (RetriableException e) {
                String retriesExplained = this.retries == -1 ? "infinity" : String.valueOf(this.retries);
                LOGGER.info("Failed with retriable exception, will retry later; attempt #{} out of {}", this.retries - --attempts, retriesExplained, e);
                delayStrategy.sleepWhen(true);
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException("Callable was interrupted while sleeping in DelayStrategy");
            }
        }
        return this.doCall();
    }
}

