/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.EnumeratedValue;
import io.debezium.converters.spi.SerializerType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.storage.ConverterConfig;

public class CloudEventsConverterConfig
extends ConverterConfig {
    public static final String CLOUDEVENTS_SERIALIZER_TYPE_CONFIG = "serializer.type";
    public static final String CLOUDEVENTS_SERIALIZER_TYPE_DEFAULT = "json";
    private static final String CLOUDEVENTS_SERIALIZER_TYPE_DOC = "Specify a serializer to serialize CloudEvents values";
    public static final String CLOUDEVENTS_DATA_SERIALIZER_TYPE_CONFIG = "data.serializer.type";
    public static final String CLOUDEVENTS_DATA_SERIALIZER_TYPE_DEFAULT = "json";
    private static final String CLOUDEVENTS_DATA_SERIALIZER_TYPE_DOC = "Specify a serializer to serialize the data field of CloudEvents values";
    public static final String CLOUDEVENTS_EXTENSION_ATTRIBUTES_ENABLE_CONFIG = "extension.attributes.enable";
    public static final boolean CLOUDEVENTS_EXTENSION_ATTRIBUTES_ENABLE_DEFAULT = true;
    private static final String CLOUDEVENTS_EXTENSION_ATTRIBUTES_ENABLE_DOC = "Specify whether to include extension attributes to a cloud event";
    public static final String CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_CONFIG = "schema.name.adjustment.mode";
    public static final String CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_DEFAULT = "avro";
    private static final String CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_DOC = "Specify how schema names should be adjusted for compatibility with the message converter used by the connector, including:'avro' replaces the characters that cannot be used in the Avro type name with underscore (default)'none' does not apply any adjustment";
    public static final String CLOUDEVENTS_SCHEMA_CLOUDEVENTS_NAME_CONFIG = "schema.cloudevents.name";
    public static final String CLOUDEVENTS_SCHEMA_CLOUDEVENTS_NAME_DEFAULT = null;
    private static final String CLOUDEVENTS_SCHEMA_CLOUDEVENTS_NAME_DOC = "Specify CloudEvents schema name under which the schema is registered in a Schema Registry";
    public static final String CLOUDEVENTS_SCHEMA_DATA_NAME_SOURCE_HEADERS_ENABLE_CONFIG = "schema.data.name.source.header.enable";
    public static final boolean CLOUDEVENTS_SCHEMA_DATA_NAME_SOURCE_HEADERS_ENABLE_DEFAULT = false;
    private static final String CLOUDEVENTS_SCHEMA_DATA_NAME_SOURCE_HEADERS_ENABLE_DOC = "Specify whether CloudEvents.data schema name can be retrieved from the header";
    public static final String CLOUDEVENTS_METADATA_SOURCE_CONFIG = "metadata.source";
    public static final String CLOUDEVENTS_METADATA_SOURCE_DEFAULT = "value,id:generate,type:generate,dataSchemaName:generate";
    private static final String CLOUDEVENTS_METADATA_SOURCE_DOC = "Specify from where to retrieve metadata";
    private static final ConfigDef CONFIG = ConverterConfig.newConfigDef();

    public static ConfigDef configDef() {
        return CONFIG;
    }

    public CloudEventsConverterConfig(Map<String, ?> props) {
        super(CONFIG, props);
    }

    public SerializerType cloudeventsSerializerType() {
        return SerializerType.withName(this.getString(CLOUDEVENTS_SERIALIZER_TYPE_CONFIG));
    }

    public SerializerType cloudeventsDataSerializerTypeConfig() {
        return SerializerType.withName(this.getString(CLOUDEVENTS_DATA_SERIALIZER_TYPE_CONFIG));
    }

    public boolean extensionAttributesEnable() {
        return this.getBoolean(CLOUDEVENTS_EXTENSION_ATTRIBUTES_ENABLE_CONFIG);
    }

    public CommonConnectorConfig.SchemaNameAdjustmentMode schemaNameAdjustmentMode() {
        return CommonConnectorConfig.SchemaNameAdjustmentMode.parse(this.getString(CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_CONFIG));
    }

    public String schemaCloudEventsName() {
        return this.getString(CLOUDEVENTS_SCHEMA_CLOUDEVENTS_NAME_CONFIG);
    }

    public MetadataSource metadataSource() {
        boolean setDefaultDataSchemaNameSource;
        MetadataSourceValue global;
        List<String> metadataSources = this.getList(CLOUDEVENTS_METADATA_SOURCE_CONFIG);
        boolean enableDataSchemaNameFromHeader = this.getBoolean(CLOUDEVENTS_SCHEMA_DATA_NAME_SOURCE_HEADERS_ENABLE_CONFIG);
        Set<MetadataSourceValue> globalMetadataSourceAllowedValues = Set.of(MetadataSourceValue.VALUE, MetadataSourceValue.HEADER);
        if (!globalMetadataSourceAllowedValues.contains(global = MetadataSourceValue.parse(metadataSources.get(0)))) {
            throw new ConfigException("Global metadata source can't be " + global.name());
        }
        Set<MetadataSourceValue> fieldMetadataSourceAllowedValues = Set.of(MetadataSourceValue.HEADER, MetadataSourceValue.GENERATE);
        MetadataSourceValue idCustomSource = null;
        MetadataSourceValue typeCustomSource = null;
        MetadataSourceValue dataSchemaNameCustomSource = null;
        block10: for (int i = 1; i < metadataSources.size(); ++i) {
            String[] parts = metadataSources.get(i).split(":");
            String fieldName = parts[0];
            MetadataSourceValue fieldSource = MetadataSourceValue.parse(parts[1]);
            if (fieldSource == null) {
                throw new ConfigException("Field source `" + parts[1] + "` is not valid");
            }
            if (!fieldMetadataSourceAllowedValues.contains(fieldSource)) {
                throw new ConfigException("Field metadata source can't be " + fieldSource.name());
            }
            switch (fieldName) {
                case "id": {
                    idCustomSource = fieldSource;
                    continue block10;
                }
                case "type": {
                    typeCustomSource = fieldSource;
                    continue block10;
                }
                case "dataSchemaName": {
                    dataSchemaNameCustomSource = fieldSource;
                    continue block10;
                }
                default: {
                    throw new ConfigException("Field `" + fieldName + "` is not allowed to set custom source");
                }
            }
        }
        MetadataSourceValue idSource = idCustomSource != null ? idCustomSource : global;
        MetadataSourceValue typeSource = typeCustomSource != null ? typeCustomSource : global;
        MetadataSourceValue dataSchemaNameSource = dataSchemaNameCustomSource != null ? dataSchemaNameCustomSource : global;
        boolean bl = setDefaultDataSchemaNameSource = dataSchemaNameSource == MetadataSourceValue.HEADER && !enableDataSchemaNameFromHeader;
        if (setDefaultDataSchemaNameSource) {
            dataSchemaNameSource = MetadataSourceValue.GENERATE;
        }
        return new MetadataSource(global, idSource, typeSource, dataSchemaNameSource);
    }

    static {
        CONFIG.define(CLOUDEVENTS_SERIALIZER_TYPE_CONFIG, ConfigDef.Type.STRING, "json", ConfigDef.Importance.HIGH, CLOUDEVENTS_SERIALIZER_TYPE_DOC);
        CONFIG.define(CLOUDEVENTS_DATA_SERIALIZER_TYPE_CONFIG, ConfigDef.Type.STRING, "json", ConfigDef.Importance.HIGH, CLOUDEVENTS_DATA_SERIALIZER_TYPE_DOC);
        CONFIG.define(CLOUDEVENTS_EXTENSION_ATTRIBUTES_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.HIGH, CLOUDEVENTS_EXTENSION_ATTRIBUTES_ENABLE_DOC);
        CONFIG.define(CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_CONFIG, ConfigDef.Type.STRING, CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_DEFAULT, ConfigDef.Importance.LOW, CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_DOC);
        CONFIG.define(CLOUDEVENTS_SCHEMA_CLOUDEVENTS_NAME_CONFIG, ConfigDef.Type.STRING, CLOUDEVENTS_SCHEMA_CLOUDEVENTS_NAME_DEFAULT, ConfigDef.Importance.LOW, CLOUDEVENTS_SCHEMA_CLOUDEVENTS_NAME_DOC);
        CONFIG.define(CLOUDEVENTS_SCHEMA_DATA_NAME_SOURCE_HEADERS_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.LOW, CLOUDEVENTS_SCHEMA_DATA_NAME_SOURCE_HEADERS_ENABLE_DOC);
        CONFIG.define(CLOUDEVENTS_METADATA_SOURCE_CONFIG, ConfigDef.Type.LIST, CLOUDEVENTS_METADATA_SOURCE_DEFAULT, ConfigDef.Importance.HIGH, CLOUDEVENTS_METADATA_SOURCE_DOC);
    }

    public static enum MetadataSourceValue implements EnumeratedValue
    {
        VALUE("value"),
        HEADER("header"),
        GENERATE("generate");

        private final String value;

        private MetadataSourceValue(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static MetadataSourceValue parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (MetadataSourceValue option : MetadataSourceValue.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }
    }

    public class MetadataSource {
        private final MetadataSourceValue global;
        private final MetadataSourceValue id;
        private final MetadataSourceValue type;
        private final MetadataSourceValue dataSchemaName;

        public MetadataSource(MetadataSourceValue global, MetadataSourceValue id, MetadataSourceValue type, MetadataSourceValue dataSchemaName) {
            this.global = global;
            this.id = id;
            this.type = type;
            this.dataSchemaName = dataSchemaName;
        }

        public MetadataSourceValue global() {
            return this.global;
        }

        public MetadataSourceValue id() {
            return this.id;
        }

        public MetadataSourceValue type() {
            return this.type;
        }

        public MetadataSourceValue dataSchemaName() {
            return this.dataSchemaName;
        }
    }
}

