/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.executor;

import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowId;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithException;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.multipleflows.MultipleCondition;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionStorageInterface;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionWindow;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.services.ConditionService;
import io.kestra.core.services.FlowService;
import io.kestra.core.utils.ListUtils;
import io.kestra.plugin.core.trigger.Flow;
import jakarta.inject.Singleton;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

@Singleton
public class FlowTriggerService {
    private final ConditionService conditionService;
    private final RunContextFactory runContextFactory;
    private final FlowService flowService;

    public FlowTriggerService(ConditionService conditionService, RunContextFactory runContextFactory, FlowService flowService) {
        this.conditionService = conditionService;
        this.runContextFactory = runContextFactory;
        this.flowService = flowService;
    }

    public Stream<FlowWithFlowTrigger> withFlowTriggersOnly(Stream<FlowWithSource> allFlows) {
        return allFlows.filter(flow -> !flow.isDisabled()).filter(flow -> flow.getTriggers() != null && !flow.getTriggers().isEmpty()).flatMap(flow -> this.flowTriggers((Flow)flow).map(trigger -> new FlowWithFlowTrigger((Flow)flow, (io.kestra.plugin.core.trigger.Flow)trigger)));
    }

    public Stream<io.kestra.plugin.core.trigger.Flow> flowTriggers(Flow flow) {
        return flow.getTriggers().stream().filter(Predicate.not(AbstractTrigger::isDisabled)).filter(io.kestra.plugin.core.trigger.Flow.class::isInstance).map(io.kestra.plugin.core.trigger.Flow.class::cast);
    }

    public List<Execution> computeExecutionsFromFlowTriggers(Execution execution, List<? extends Flow> allFlows, Optional<MultipleConditionStorageInterface> multipleConditionStorage) {
        List<FlowWithFlowTrigger> validTriggersBeforeMultipleConditionEval = allFlows.stream().filter(flow -> this.flowService.removeUnwanted(flow, execution)).filter(flow -> execution.getKind() == null).filter(flow -> !flow.isDisabled() && !(flow instanceof FlowWithException)).filter(flow -> flow.getTriggers() != null && !flow.getTriggers().isEmpty()).flatMap(flow -> this.flowTriggers((Flow)flow).map(trigger -> new FlowWithFlowTrigger((Flow)flow, (io.kestra.plugin.core.trigger.Flow)trigger))).filter(flowWithFlowTrigger -> flowWithFlowTrigger.getTrigger().getStates().contains(execution.getState().getCurrent())).filter(flowWithFlowTrigger -> this.conditionService.valid((FlowInterface)flowWithFlowTrigger.getFlow(), Optional.ofNullable(flowWithFlowTrigger.getTrigger().getConditions()).stream().flatMap(Collection::stream).filter(Predicate.not(MultipleCondition.class::isInstance)).toList(), this.conditionService.conditionContext(this.runContextFactory.of((FlowInterface)flowWithFlowTrigger.getFlow(), execution), flowWithFlowTrigger.getFlow(), execution))).toList();
        if (validTriggersBeforeMultipleConditionEval.isEmpty()) {
            return Collections.emptyList();
        }
        Map<FlowWithFlowTriggerAndMultipleCondition, MultipleConditionWindow> multipleConditionWindowsByFlow = null;
        if (multipleConditionStorage.isPresent()) {
            List<FlowWithFlowTriggerAndMultipleCondition> flowWithMultipleConditionsToEvaluate = validTriggersBeforeMultipleConditionEval.stream().flatMap(flowWithFlowTrigger -> this.flowTriggerMultipleConditions((FlowWithFlowTrigger)flowWithFlowTrigger).map(multipleCondition -> new FlowWithFlowTriggerAndMultipleCondition(flowWithFlowTrigger.getFlow(), ((MultipleConditionStorageInterface)multipleConditionStorage.get()).getOrCreate((FlowId)flowWithFlowTrigger.getFlow(), multipleCondition, execution.getOutputs()), flowWithFlowTrigger.getTrigger(), (MultipleCondition)multipleCondition))).filter(flowWithFlowTriggerAndMultipleCondition -> flowWithFlowTriggerAndMultipleCondition.getMultipleConditionWindow().isValid(ZonedDateTime.now())).toList();
            multipleConditionWindowsByFlow = flowWithMultipleConditionsToEvaluate.stream().map(f -> {
                Map<String, Boolean> results = f.getMultipleCondition().getConditions().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, Boolean>((String)e.getKey(), this.conditionService.isValid((Condition)e.getValue(), (FlowInterface)f.getFlow(), execution))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                return Map.entry(f, f.getMultipleConditionWindow().with(results));
            }).filter(e -> !((MultipleConditionWindow)e.getValue()).getResults().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            multipleConditionStorage.get().save(new ArrayList<MultipleConditionWindow>(multipleConditionWindowsByFlow.values()));
        }
        List<Execution> executions = validTriggersBeforeMultipleConditionEval.stream().filter(flowWithFlowTrigger -> this.conditionService.isValid((AbstractTrigger)flowWithFlowTrigger.getTrigger(), flowWithFlowTrigger.getFlow(), execution, (MultipleConditionStorageInterface)multipleConditionStorage.orElse(null))).filter(flowWithFlowTrigger -> this.conditionService.isValid((MultipleCondition)flowWithFlowTrigger.getTrigger().getPreconditions(), flowWithFlowTrigger.getFlow(), execution, (MultipleConditionStorageInterface)multipleConditionStorage.orElse(null))).map(f -> f.getTrigger().evaluate(multipleConditionStorage, this.runContextFactory.of((FlowInterface)f.getFlow(), execution), f.getFlow(), execution)).filter(Optional::isPresent).map(Optional::get).toList();
        if (multipleConditionStorage.isPresent()) {
            Stream.concat(multipleConditionWindowsByFlow.entrySet().stream().map(e -> Map.entry(((FlowWithFlowTriggerAndMultipleCondition)e.getKey()).getMultipleCondition(), (MultipleConditionWindow)e.getValue())).filter(e -> !Boolean.FALSE.equals(((MultipleCondition)e.getKey()).getResetOnSuccess()) && ((MultipleCondition)e.getKey()).getConditions().size() == Optional.ofNullable(((MultipleConditionWindow)e.getValue()).getResults()).map(Map::size).orElse(0).intValue()).map(Map.Entry::getValue), multipleConditionStorage.get().expired(execution.getTenantId()).stream()).forEach(arg_0 -> ((MultipleConditionStorageInterface)multipleConditionStorage.get()).delete(arg_0));
        }
        return executions;
    }

    private Stream<MultipleCondition> flowTriggerMultipleConditions(FlowWithFlowTrigger flowWithFlowTrigger) {
        Stream<MultipleCondition> legacyMultipleConditions = ListUtils.emptyOnNull((List)flowWithFlowTrigger.getTrigger().getConditions()).stream().filter(MultipleCondition.class::isInstance).map(MultipleCondition.class::cast);
        Stream<Flow.Preconditions> preconditions = Optional.ofNullable(flowWithFlowTrigger.getTrigger().getPreconditions()).stream();
        return Stream.concat(legacyMultipleConditions, preconditions);
    }

    public static class FlowWithFlowTrigger {
        private final Flow flow;
        private final io.kestra.plugin.core.trigger.Flow trigger;

        @ConstructorProperties(value={"flow", "trigger"})
        @Generated
        public FlowWithFlowTrigger(Flow flow, io.kestra.plugin.core.trigger.Flow trigger) {
            this.flow = flow;
            this.trigger = trigger;
        }

        @Generated
        public Flow getFlow() {
            return this.flow;
        }

        @Generated
        public io.kestra.plugin.core.trigger.Flow getTrigger() {
            return this.trigger;
        }

        @Generated
        public String toString() {
            return "FlowTriggerService.FlowWithFlowTrigger(flow=" + String.valueOf(this.getFlow()) + ", trigger=" + String.valueOf(this.getTrigger()) + ")";
        }
    }

    protected static class FlowWithFlowTriggerAndMultipleCondition {
        private final Flow flow;
        private final MultipleConditionWindow multipleConditionWindow;
        private final io.kestra.plugin.core.trigger.Flow trigger;
        private final MultipleCondition multipleCondition;

        @ConstructorProperties(value={"flow", "multipleConditionWindow", "trigger", "multipleCondition"})
        @Generated
        public FlowWithFlowTriggerAndMultipleCondition(Flow flow, MultipleConditionWindow multipleConditionWindow, io.kestra.plugin.core.trigger.Flow trigger, MultipleCondition multipleCondition) {
            this.flow = flow;
            this.multipleConditionWindow = multipleConditionWindow;
            this.trigger = trigger;
            this.multipleCondition = multipleCondition;
        }

        @Generated
        public Flow getFlow() {
            return this.flow;
        }

        @Generated
        public MultipleConditionWindow getMultipleConditionWindow() {
            return this.multipleConditionWindow;
        }

        @Generated
        public io.kestra.plugin.core.trigger.Flow getTrigger() {
            return this.trigger;
        }

        @Generated
        public MultipleCondition getMultipleCondition() {
            return this.multipleCondition;
        }

        @Generated
        public String toString() {
            return "FlowTriggerService.FlowWithFlowTriggerAndMultipleCondition(flow=" + String.valueOf(this.getFlow()) + ", multipleConditionWindow=" + String.valueOf(this.getMultipleConditionWindow()) + ", trigger=" + String.valueOf(this.getTrigger()) + ", multipleCondition=" + String.valueOf(this.getMultipleCondition()) + ")";
        }
    }
}

