/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.executor;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.Label;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionKind;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionStorageInterface;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.services.ConditionService;
import io.kestra.core.services.FlowService;
import io.kestra.core.utils.IdUtils;
import io.kestra.executor.FlowTriggerService;
import io.kestra.plugin.core.log.Log;
import io.kestra.plugin.core.trigger.Flow;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@KestraTest
class FlowTriggerServiceTest {
    public static final List<Label> EMPTY_LABELS = List.of();
    public static final Optional<MultipleConditionStorageInterface> EMPTY_MULTIPLE_CONDITION_STORAGE = Optional.empty();
    @Inject
    private TestRunContextFactory runContextFactory;
    @Inject
    private ConditionService conditionService;
    @Inject
    private FlowService flowService;
    private FlowTriggerService flowTriggerService;

    FlowTriggerServiceTest() {
    }

    @BeforeEach
    void setUp() {
        this.flowTriggerService = new FlowTriggerService(this.conditionService, (RunContextFactory)this.runContextFactory, this.flowService);
    }

    @Test
    void computeExecutionsFromFlowTriggers_ok() {
        Flow simpleFlow = FlowTriggerServiceTest.aSimpleFlow();
        Flow flowWithFlowTrigger = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id("flow-with-flow-trigger")).namespace("io.kestra.unittest")).tenantId("main")).tasks(List.of(FlowTriggerServiceTest.simpleLogTask())).triggers(List.of(FlowTriggerServiceTest.flowTriggerWithNoConditions())).build();
        Execution simpleFlowExecution = Execution.newExecution((FlowInterface)simpleFlow, EMPTY_LABELS).withState(State.Type.SUCCESS);
        List resultingExecutionsToRun = this.flowTriggerService.computeExecutionsFromFlowTriggers(simpleFlowExecution, List.of(simpleFlow, flowWithFlowTrigger), EMPTY_MULTIPLE_CONDITION_STORAGE);
        Assertions.assertThat((List)resultingExecutionsToRun).size().isEqualTo(1);
        Assertions.assertThat((String)((Execution)resultingExecutionsToRun.get(0)).getFlowId()).isEqualTo(flowWithFlowTrigger.getId());
    }

    @Test
    void computeExecutionsFromFlowTriggers_filteringOutCreatedExecutions() {
        Flow simpleFlow = FlowTriggerServiceTest.aSimpleFlow();
        Flow flowWithFlowTrigger = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id("flow-with-flow-trigger")).namespace("io.kestra.unittest")).tenantId("main")).tasks(List.of(FlowTriggerServiceTest.simpleLogTask())).triggers(List.of(FlowTriggerServiceTest.flowTriggerWithNoConditions())).build();
        Execution simpleFlowExecution = Execution.newExecution((FlowInterface)simpleFlow, EMPTY_LABELS).withState(State.Type.CREATED);
        List resultingExecutionsToRun = this.flowTriggerService.computeExecutionsFromFlowTriggers(simpleFlowExecution, List.of(simpleFlow, flowWithFlowTrigger), EMPTY_MULTIPLE_CONDITION_STORAGE);
        Assertions.assertThat((List)resultingExecutionsToRun).size().isEqualTo(0);
    }

    @Test
    void computeExecutionsFromFlowTriggers_filteringOutTestExecutions() {
        Flow simpleFlow = FlowTriggerServiceTest.aSimpleFlow();
        Flow flowWithFlowTrigger = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id("flow-with-flow-trigger")).namespace("io.kestra.unittest")).tenantId("main")).tasks(List.of(FlowTriggerServiceTest.simpleLogTask())).triggers(List.of(FlowTriggerServiceTest.flowTriggerWithNoConditions())).build();
        Execution simpleFlowExecutionComingFromATest = Execution.newExecution((FlowInterface)simpleFlow, EMPTY_LABELS).withState(State.Type.SUCCESS).toBuilder().kind(ExecutionKind.TEST).build();
        List resultingExecutionsToRun = this.flowTriggerService.computeExecutionsFromFlowTriggers(simpleFlowExecutionComingFromATest, List.of(simpleFlow, flowWithFlowTrigger), EMPTY_MULTIPLE_CONDITION_STORAGE);
        Assertions.assertThat((List)resultingExecutionsToRun).size().isEqualTo(0);
    }

    private static Flow aSimpleFlow() {
        return ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id("simple-flow")).namespace("io.kestra.unittest")).tenantId("main")).tasks(List.of(FlowTriggerServiceTest.simpleLogTask())).build();
    }

    private static io.kestra.plugin.core.trigger.Flow flowTriggerWithNoConditions() {
        return ((Flow.FlowBuilder)((Flow.FlowBuilder)io.kestra.plugin.core.trigger.Flow.builder().id("flowTrigger")).type(io.kestra.plugin.core.trigger.Flow.class.getName())).build();
    }

    private static Log simpleLogTask() {
        return ((Log.LogBuilder)((Log.LogBuilder)Log.builder().id(IdUtils.create())).type(Log.class.getName())).message((Object)"Hello World").build();
    }
}

