/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.io;

import io.jsonwebtoken.io.AbstractDeserializer;
import io.jsonwebtoken.lang.Assert;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class OrgJsonDeserializer
extends AbstractDeserializer<Object> {
    private final JSONTokenerFactory TOKENER_FACTORY;

    public OrgJsonDeserializer() {
        this(JSONTokenerFactory.INSTANCE);
    }

    private OrgJsonDeserializer(JSONTokenerFactory factory) {
        this.TOKENER_FACTORY = (JSONTokenerFactory)Assert.notNull((Object)factory, (String)"JSONTokenerFactory cannot be null.");
    }

    protected Object doDeserialize(Reader reader) {
        return this.parse(reader);
    }

    private Object parse(Reader reader) throws JSONException {
        JSONTokener tokener = this.TOKENER_FACTORY.newTokener(reader);
        Assert.notNull((Object)tokener, (String)"JSONTokener cannot be null.");
        char c = tokener.nextClean();
        tokener.back();
        if (c == '{') {
            JSONObject o = new JSONObject(tokener);
            return this.toMap(o);
        }
        if (c == '[') {
            JSONArray a = new JSONArray(tokener);
            return this.toList(a);
        }
        Object value = tokener.nextValue();
        return this.convertIfNecessary(value);
    }

    private Map<String, Object> toMap(JSONObject o) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Iterator iterator = o.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = o.get(key);
            value = this.convertIfNecessary(value);
            map.put(key, value);
        }
        return map;
    }

    private List<Object> toList(JSONArray a) {
        int length = a.length();
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object value = a.get(i);
            value = this.convertIfNecessary(value);
            list.add(value);
        }
        return list;
    }

    private Object convertIfNecessary(Object v) {
        List<Object> value = v;
        if (JSONObject.NULL.equals(value)) {
            value = null;
        } else if (value instanceof JSONArray) {
            value = this.toList((JSONArray)value);
        } else if (value instanceof JSONObject) {
            value = this.toMap((JSONObject)value);
        }
        return value;
    }

    static class JSONTokenerFactory {
        private static final Reader TEST_READER = new CharArrayReader("{}".toCharArray());
        private static final JSONTokenerFactory INSTANCE = new JSONTokenerFactory();
        private final boolean readerCtorAvailable;

        JSONTokenerFactory() {
            boolean avail = true;
            try {
                this.testTokener(TEST_READER);
            }
            catch (NoSuchMethodError err) {
                avail = false;
            }
            this.readerCtorAvailable = avail;
        }

        protected void testTokener(Reader reader) throws NoSuchMethodError {
            new JSONTokener(reader);
        }

        private static String toString(Reader reader) throws IOException {
            StringBuilder sb = new StringBuilder(4096);
            char[] buf = new char[4096];
            int n = 0;
            while (-1 != n) {
                n = reader.read(buf);
                if (n <= 0) continue;
                sb.append(buf, 0, n);
            }
            return sb.toString();
        }

        private JSONTokener newTokener(Reader reader) {
            String s;
            if (this.readerCtorAvailable) {
                return new JSONTokener(reader);
            }
            try {
                s = JSONTokenerFactory.toString(reader);
            }
            catch (IOException ex) {
                String msg = "Unable to obtain JSON String from Reader: " + ex.getMessage();
                throw new JSONException(msg, (Throwable)ex);
            }
            return new JSONTokener(s);
        }
    }
}

