/*
 * Decompiled with CFR 0.152.
 */
package io.joyrpc.codec.serialization.jackson.java8;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.joyrpc.exception.SerializerException;
import java.io.IOException;
import java.util.OptionalLong;

public class OptionalLongDeserializer
extends JsonDeserializer<OptionalLong> {
    public static final JsonDeserializer INSTANCE = new OptionalLongDeserializer();

    public OptionalLong deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_NUMBER_INT: {
                return OptionalLong.of(parser.getLongValue());
            }
        }
        throw new SerializerException("Error occurs while parsing OptionalLong");
    }
}

