/*
 * Decompiled with CFR 0.152.
 */
package io.joyrpc.codec.serialization.jackson.java8;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.joyrpc.exception.SerializerException;
import java.io.IOException;
import java.util.OptionalInt;

public class OptionalIntDeserializer
extends JsonDeserializer<OptionalInt> {
    public static final JsonDeserializer INSTANCE = new OptionalIntDeserializer();

    public OptionalInt deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_NUMBER_INT: {
                return OptionalInt.of(parser.getIntValue());
            }
        }
        throw new SerializerException("Error occurs while parsing OptionalInt");
    }
}

