/*
 * Decompiled with CFR 0.152.
 */
package io.joyrpc.codec.serialization.jackson.java8;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.joyrpc.exception.SerializerException;
import java.io.IOException;
import java.util.Optional;

public class OptionalDeserializer
extends JsonDeserializer<Optional> {
    public static final JsonDeserializer INSTANCE = new OptionalDeserializer();

    public Optional deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case START_OBJECT: {
                return Optional.of(ctx.readValue(parser, ctx.getContextualType()));
            }
        }
        throw new SerializerException("Error occurs while parsing Optional");
    }
}

