/*
 * Decompiled with CFR 0.152.
 */
package io.joyrpc.codec.serialization.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class ThrowableSerializer
extends JsonSerializer<Throwable> {
    public static final JsonSerializer INSTANCE = new ThrowableSerializer();

    public void serialize(Throwable throwable, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (throwable == null) {
            gen.writeNull();
        } else {
            StackTraceElement[] traces;
            gen.writeStartObject();
            gen.writeStringField("@type", throwable.getClass().getName());
            gen.writeStringField("message", throwable.getMessage());
            if (throwable.getCause() != null) {
                gen.writeObjectField("cause", (Object)throwable.getCause());
            }
            if ((traces = throwable.getStackTrace()) != null) {
                gen.writeFieldName("stackTrace");
                gen.writeStartArray();
                for (StackTraceElement trace : traces) {
                    gen.writeObject((Object)trace);
                }
                gen.writeEndArray();
            }
            gen.writeEndObject();
        }
    }
}

