/*
 * Decompiled with CFR 0.152.
 */
package io.joyrpc.codec.serialization.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.joyrpc.codec.serialization.jackson.AbstractDeserializer;
import io.joyrpc.exception.CreationException;
import io.joyrpc.exception.SerializerException;
import io.joyrpc.util.ClassUtils;
import java.io.IOException;

public class ThrowableDeserializer
extends AbstractDeserializer<Throwable> {
    public static final JsonDeserializer INSTANCE = new ThrowableDeserializer();

    public Throwable deserialize(JsonParser parser, DeserializationContext ctx) throws IOException, JsonProcessingException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case START_OBJECT: {
                return this.parse(parser);
            }
        }
        throw new SerializerException("Error occurs while parsing throwable.");
    }

    protected Throwable parse(JsonParser parser) throws IOException {
        Class clazz = null;
        Throwable cause = null;
        String message = null;
        StackTraceElement[] stackTrace = null;
        try {
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String key = parser.currentName();
                if ("@type".equals(key)) {
                    String className = this.readString(parser, "@type", true);
                    if (className == null) continue;
                    clazz = ClassUtils.forName((String)className);
                    continue;
                }
                if ("cause".equals(key)) {
                    cause = this.parseCause(parser);
                    continue;
                }
                if ("message".equals(key)) {
                    message = this.readString(parser, "message", true);
                    continue;
                }
                if (!"stackTrace".equals(key)) continue;
                stackTrace = this.parseTrace(parser);
            }
            return ClassUtils.createException(clazz, message, cause, stackTrace);
        }
        catch (CreationException | ClassNotFoundException e) {
            throw new SerializerException(e.getMessage(), e.getCause());
        }
    }

    protected Throwable parseCause(JsonParser parser) throws IOException {
        switch (parser.nextToken()) {
            case START_OBJECT: {
                return (Throwable)parser.readValueAs(Throwable.class);
            }
            case VALUE_NULL: {
                return null;
            }
        }
        throw new SerializerException("syntax error: cause is illegal.");
    }

    protected StackTraceElement[] parseTrace(JsonParser parser) throws IOException {
        switch (parser.nextToken()) {
            case START_ARRAY: {
                return (StackTraceElement[])parser.readValueAs(StackTraceElement[].class);
            }
            case VALUE_NULL: {
                return null;
            }
        }
        throw new SerializerException("syntax error: stackTrace is illegal.");
    }
}

