/*
 * Decompiled with CFR 0.152.
 */
package io.joyrpc.codec.serialization.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.joyrpc.protocol.message.ResponsePayload;
import io.joyrpc.util.ClassUtils;
import java.io.IOException;
import java.lang.reflect.Type;

public class ResponsePayloadSerializer
extends JsonSerializer<ResponsePayload> {
    public static final JsonSerializer INSTANCE = new ResponsePayloadSerializer();

    public void serialize(ResponsePayload payload, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (payload == null) {
            gen.writeNull();
        } else {
            gen.writeStartObject();
            Throwable exception = payload.getException();
            Object response = payload.getResponse();
            if (response != null) {
                gen.writeStringField("class", this.getTypeName(response, payload.getType()));
                gen.writeObjectField("response", response);
            } else if (exception != null) {
                gen.writeStringField("class", ClassUtils.getCanonicalName(exception.getClass()));
                gen.writeObjectField("response", (Object)exception);
            }
            gen.writeEndObject();
        }
    }

    protected String getTypeName(Object response, Type type) {
        return type == null ? ClassUtils.getCanonicalName(response.getClass()) : type.getTypeName();
    }
}

