/*
 * Decompiled with CFR 0.152.
 */
package io.joyrpc.codec.serialization.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.joyrpc.codec.serialization.jackson.AbstractDeserializer;
import io.joyrpc.codec.serialization.jackson.SimpleTypeReference;
import io.joyrpc.exception.SerializerException;
import io.joyrpc.protocol.message.ResponsePayload;
import io.joyrpc.util.ClassUtils;
import io.joyrpc.util.GenericMethod;
import java.io.IOException;
import java.lang.reflect.Type;

public class ResponsePayloadDeserializer
extends AbstractDeserializer<ResponsePayload> {
    public static final JsonDeserializer INSTANCE = new ResponsePayloadDeserializer();

    public ResponsePayload deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case START_OBJECT: {
                return this.parse(parser);
            }
        }
        throw new SerializerException("Error occurs while parsing responsePayload");
    }

    protected ResponsePayload parse(JsonParser parser) throws IOException {
        ResponsePayload payload = new ResponsePayload();
        String typeName = null;
        try {
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String key = parser.currentName();
                if ("class".equals(key)) {
                    typeName = this.readString(parser, "class", false);
                    continue;
                }
                if ("response".equals(key)) {
                    payload.setResponse(this.readResponse(parser, typeName));
                    continue;
                }
                if (!"exception".equals(key)) continue;
                payload.setException(this.readException(parser, typeName));
            }
        }
        catch (ClassNotFoundException e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        return payload;
    }

    protected Object readResponse(JsonParser parser, String typeName) throws IOException, ClassNotFoundException {
        if (typeName == null || typeName.isEmpty()) {
            return null;
        }
        switch (parser.nextToken()) {
            case START_OBJECT: {
                return parser.readValueAs((TypeReference)new SimpleTypeReference(this.getType(typeName)));
            }
            case VALUE_NULL: {
                return null;
            }
        }
        throw new SerializerException("Error occurs while parsing responsePayload");
    }

    protected Throwable readException(JsonParser parser, String typeName) throws IOException, ClassNotFoundException {
        if (typeName == null || typeName.isEmpty()) {
            return null;
        }
        switch (parser.nextToken()) {
            case START_OBJECT: {
                return (Throwable)parser.readValueAs(this.getThrowableType(typeName));
            }
            case VALUE_NULL: {
                return null;
            }
        }
        throw new SerializerException("Error occurs while parsing responsePayload");
    }

    protected Class<?> getThrowableType(String typeName) throws ClassNotFoundException {
        Class clazz = ClassUtils.getClass((String)typeName);
        if (clazz == null) {
            return Throwable.class;
        }
        if (Throwable.class.isAssignableFrom(clazz)) {
            return clazz;
        }
        throw new SerializerException("syntax error: invalid throwable class " + typeName);
    }

    protected Type getType(String typeName) throws ClassNotFoundException {
        Type type = GenericMethod.getReturnGenericType((String)typeName);
        type = type == null ? ClassUtils.getClass((String)typeName) : type;
        return type;
    }
}

