/*
 * Decompiled with CFR 0.152.
 */
package io.joyrpc.codec.serialization.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import io.joyrpc.cluster.discovery.backup.BackupShard;
import io.joyrpc.codec.UnsafeByteArrayOutputStream;
import io.joyrpc.codec.serialization.Json;
import io.joyrpc.codec.serialization.Serialization;
import io.joyrpc.codec.serialization.Serializer;
import io.joyrpc.codec.serialization.TypeReference;
import io.joyrpc.codec.serialization.jackson.BackupShardSerializer;
import io.joyrpc.codec.serialization.jackson.CalendarDeserializer;
import io.joyrpc.codec.serialization.jackson.InvocationDeserializer;
import io.joyrpc.codec.serialization.jackson.InvocationSerializer;
import io.joyrpc.codec.serialization.jackson.ResponsePayloadDeserializer;
import io.joyrpc.codec.serialization.jackson.ResponsePayloadSerializer;
import io.joyrpc.codec.serialization.jackson.SimpleTypeReference;
import io.joyrpc.codec.serialization.jackson.ThrowableDeserializer;
import io.joyrpc.codec.serialization.jackson.ThrowableSerializer;
import io.joyrpc.codec.serialization.jackson.java8.DurationDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.DurationSerializer;
import io.joyrpc.codec.serialization.jackson.java8.InstantDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.InstantSerializer;
import io.joyrpc.codec.serialization.jackson.java8.LocalDateDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.LocalDateSerializer;
import io.joyrpc.codec.serialization.jackson.java8.LocalDateTimeDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.LocalDateTimeSerializer;
import io.joyrpc.codec.serialization.jackson.java8.LocalTimeDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.LocalTimeSerializer;
import io.joyrpc.codec.serialization.jackson.java8.MonthDayDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.MonthDaySerializer;
import io.joyrpc.codec.serialization.jackson.java8.OffsetDateTimeDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.OffsetDateTimeSerializer;
import io.joyrpc.codec.serialization.jackson.java8.OffsetTimeDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.OffsetTimeSerializer;
import io.joyrpc.codec.serialization.jackson.java8.OptionalDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.OptionalDoubleDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.OptionalDoubleSerializer;
import io.joyrpc.codec.serialization.jackson.java8.OptionalIntDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.OptionalIntSerializer;
import io.joyrpc.codec.serialization.jackson.java8.OptionalLongDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.OptionalLongSerializer;
import io.joyrpc.codec.serialization.jackson.java8.OptionalSerializer;
import io.joyrpc.codec.serialization.jackson.java8.PeriodDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.PeriodSerializer;
import io.joyrpc.codec.serialization.jackson.java8.YearDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.YearMonthDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.YearMonthSerializer;
import io.joyrpc.codec.serialization.jackson.java8.YearSerializer;
import io.joyrpc.codec.serialization.jackson.java8.ZoneIdDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.ZoneIdSerializer;
import io.joyrpc.codec.serialization.jackson.java8.ZoneOffsetDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.ZoneOffsetSerializer;
import io.joyrpc.codec.serialization.jackson.java8.ZonedDateTimeDeserializer;
import io.joyrpc.codec.serialization.jackson.java8.ZonedDateTimeSerializer;
import io.joyrpc.exception.SerializerException;
import io.joyrpc.extension.Extension;
import io.joyrpc.extension.Option;
import io.joyrpc.extension.condition.ConditionalOnClass;
import io.joyrpc.permission.BlackList;
import io.joyrpc.permission.SerializerBlackWhiteList;
import io.joyrpc.protocol.message.Invocation;
import io.joyrpc.protocol.message.ResponsePayload;
import io.joyrpc.util.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TimeZone;
import java.util.function.BiFunction;
import java.util.function.Function;

@Extension(value="json", provider="jackson", order=150)
@ConditionalOnClass(value={"com.fasterxml.jackson.core.JsonFactory"})
public class JacksonSerialization
implements Serialization,
Json,
BlackList.BlackListAware {
    public byte getTypeId() {
        return 13;
    }

    public String getContentType() {
        return "text/json";
    }

    public boolean autoType() {
        return false;
    }

    public Serializer getSerializer() {
        return JacksonSerializer.INSTANCE;
    }

    public void writeJSONString(OutputStream os, Object object) throws SerializerException {
        JacksonSerializer.INSTANCE.writeJSONString(os, object);
    }

    public String toJSONString(Object object) throws SerializerException {
        return JacksonSerializer.INSTANCE.toJSONString(object);
    }

    public byte[] toJSONBytes(Object object) throws SerializerException {
        return JacksonSerializer.INSTANCE.toJSONBytes(object);
    }

    public <T> T parseObject(String text, Type type) throws SerializerException {
        return JacksonSerializer.INSTANCE.parseObject(text, type);
    }

    public <T> T parseObject(String text, TypeReference<T> reference) throws SerializerException {
        return JacksonSerializer.INSTANCE.parseObject(text, reference);
    }

    public <T> T parseObject(InputStream is, Type type) throws SerializerException {
        return JacksonSerializer.INSTANCE.parseObject(is, type);
    }

    public <T> T parseObject(InputStream is, TypeReference<T> reference) throws SerializerException {
        return JacksonSerializer.INSTANCE.parseObject(is, reference);
    }

    public void parseArray(Reader reader, Function<Function<Type, Object>, Boolean> function) throws SerializerException {
        JacksonSerializer.INSTANCE.parseArray(reader, function);
    }

    public void parseObject(Reader reader, BiFunction<String, Function<Type, Object>, Boolean> function) throws SerializerException {
        JacksonSerializer.INSTANCE.parseObject(reader, function);
    }

    public void updateBlack(Collection<String> blackList) {
        JacksonSerializer.BLACK_WHITE_LIST.updateBlack(blackList);
    }

    protected static class MySimpleDeserializers
    extends SimpleDeserializers {
        protected SerializerBlackWhiteList blackWhiteList;

        public MySimpleDeserializers(SerializerBlackWhiteList blackWhiteList) {
            this.blackWhiteList = blackWhiteList;
        }

        public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
            if (this.blackWhiteList != null && !this.blackWhiteList.isValid(type.getRawClass())) {
                throw new JsonMappingException(null, "Failed to decode class " + type.getRawClass() + " by json serialization, it is not passed through blackWhiteList.");
            }
            JsonDeserializer result = super.findBeanDeserializer(type, config, beanDesc);
            if (result != null) {
                return result;
            }
            if (type.isThrowable()) {
                return ThrowableDeserializer.INSTANCE;
            }
            return null;
        }
    }

    protected static class MySimpleSerializers
    extends SimpleSerializers {
        protected MySimpleSerializers() {
        }

        public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
            JsonSerializer result = super.findSerializer(config, type, beanDesc);
            if (result != null) {
                return result;
            }
            if (type.isThrowable()) {
                return ThrowableSerializer.INSTANCE;
            }
            return null;
        }
    }

    protected static class JacksonSerializer
    implements Serializer,
    Json {
        protected static final SerializerBlackWhiteList BLACK_WHITE_LIST = new SerializerBlackWhiteList(new Resource.Definition[]{new Resource.Definition("permission/jackson.blacklist"), new Resource.Definition("META-INF/permission/jackson.blacklist", true)});
        protected static final JacksonSerializer INSTANCE = new JacksonSerializer();
        protected ObjectMapper mapper = new ObjectMapper();

        public JacksonSerializer() {
            ZoneId zoneId = null;
            try {
                zoneId = ZoneId.of("UTC");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SimpleModule module = new SimpleModule();
            module.setSerializers((SimpleSerializers)new MySimpleSerializers());
            module.setDeserializers((SimpleDeserializers)new MySimpleDeserializers(BLACK_WHITE_LIST));
            module.addSerializer(Invocation.class, InvocationSerializer.INSTANCE);
            module.addSerializer(ResponsePayload.class, ResponsePayloadSerializer.INSTANCE);
            module.addSerializer(BackupShard.class, (JsonSerializer)BackupShardSerializer.INSTANCE);
            module.addSerializer(Duration.class, DurationSerializer.INSTANCE);
            module.addSerializer(Instant.class, InstantSerializer.INSTANCE);
            module.addSerializer(LocalDateTime.class, LocalDateTimeSerializer.INSTANCE);
            module.addSerializer(LocalDate.class, LocalDateSerializer.INSTANCE);
            module.addSerializer(LocalTime.class, LocalTimeSerializer.INSTANCE);
            module.addSerializer(OffsetDateTime.class, OffsetDateTimeSerializer.INSTANCE);
            module.addSerializer(OffsetTime.class, OffsetTimeSerializer.INSTANCE);
            module.addSerializer(Option.class, OptionalSerializer.INSTANCE);
            module.addSerializer(OptionalDouble.class, OptionalDoubleSerializer.INSTANCE);
            module.addSerializer(OptionalInt.class, OptionalIntSerializer.INSTANCE);
            module.addSerializer(OptionalLong.class, OptionalLongSerializer.INSTANCE);
            module.addSerializer(Period.class, PeriodSerializer.INSTANCE);
            module.addSerializer(ZonedDateTime.class, ZonedDateTimeSerializer.INSTANCE);
            module.addSerializer(ZoneOffset.class, ZoneOffsetSerializer.INSTANCE);
            module.addSerializer(ZoneId.class, ZoneIdSerializer.INSTANCE);
            module.addSerializer(MonthDay.class, MonthDaySerializer.INSTANCE);
            module.addSerializer(YearMonth.class, YearMonthSerializer.INSTANCE);
            module.addSerializer(Year.class, YearSerializer.INSTANCE);
            module.addDeserializer(Invocation.class, InvocationDeserializer.INSTANCE);
            module.addDeserializer(ResponsePayload.class, ResponsePayloadDeserializer.INSTANCE);
            module.addDeserializer(Duration.class, DurationDeserializer.INSTANCE);
            module.addDeserializer(Instant.class, InstantDeserializer.INSTANCE);
            module.addDeserializer(LocalDateTime.class, LocalDateTimeDeserializer.INSTANCE);
            module.addDeserializer(LocalDate.class, LocalDateDeserializer.INSTANCE);
            module.addDeserializer(LocalTime.class, LocalTimeDeserializer.INSTANCE);
            module.addDeserializer(OffsetDateTime.class, OffsetDateTimeDeserializer.INSTANCE);
            module.addDeserializer(OffsetTime.class, OffsetTimeDeserializer.INSTANCE);
            module.addDeserializer(Option.class, OptionalDeserializer.INSTANCE);
            module.addDeserializer(OptionalDouble.class, OptionalDoubleDeserializer.INSTANCE);
            module.addDeserializer(OptionalInt.class, OptionalIntDeserializer.INSTANCE);
            module.addDeserializer(OptionalLong.class, OptionalLongDeserializer.INSTANCE);
            module.addDeserializer(Period.class, PeriodDeserializer.INSTANCE);
            module.addDeserializer(ZonedDateTime.class, ZonedDateTimeDeserializer.INSTANCE);
            module.addDeserializer(ZoneOffset.class, ZoneOffsetDeserializer.INSTANCE);
            module.addDeserializer(ZoneId.class, ZoneIdDeserializer.INSTANCE);
            if (zoneId != null) {
                module.addDeserializer(zoneId.getClass(), ZoneIdDeserializer.INSTANCE);
            }
            module.addDeserializer(MonthDay.class, MonthDayDeserializer.INSTANCE);
            module.addDeserializer(YearMonth.class, YearMonthDeserializer.INSTANCE);
            module.addDeserializer(Year.class, YearDeserializer.INSTANCE);
            module.addDeserializer(Calendar.class, (JsonDeserializer)CalendarDeserializer.INSTANCE);
            CalendarDeserializer deserializer = new CalendarDeserializer(GregorianCalendar.class);
            module.addDeserializer(GregorianCalendar.class, (JsonDeserializer)deserializer);
            this.mapper.setTimeZone(TimeZone.getDefault());
            this.mapper.registerModule((Module)module);
        }

        public void writeJSONString(OutputStream os, Object object) throws SerializerException {
            try {
                this.mapper.writeValue(os, object);
            }
            catch (IOException e) {
                throw new SerializerException("Error occurred while serializing object", (Throwable)e);
            }
        }

        public String toJSONString(Object object) throws SerializerException {
            try {
                return this.mapper.writeValueAsString(object);
            }
            catch (IOException e) {
                throw new SerializerException("Error occurred while serializing object", (Throwable)e);
            }
        }

        public byte[] toJSONBytes(Object object) throws SerializerException {
            try {
                UnsafeByteArrayOutputStream baos = new UnsafeByteArrayOutputStream();
                this.mapper.writeValue((OutputStream)baos, object);
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new SerializerException("Error occurred while serializing object", (Throwable)e);
            }
        }

        public <T> T parseObject(String text, Type type) throws SerializerException {
            if (text == null) {
                return null;
            }
            try {
                return (T)this.mapper.readValue(text, (com.fasterxml.jackson.core.type.TypeReference)new SimpleTypeReference(type));
            }
            catch (IOException e) {
                throw new SerializerException("Error occurs while parsing object", (Throwable)e);
            }
        }

        public <T> T parseObject(String text, TypeReference<T> reference) throws SerializerException {
            if (text == null) {
                return null;
            }
            try {
                return (T)this.mapper.readValue(text, (com.fasterxml.jackson.core.type.TypeReference)new SimpleTypeReference(reference.getType()));
            }
            catch (IOException e) {
                throw new SerializerException("Error occurs while parsing object", (Throwable)e);
            }
        }

        public <T> T parseObject(InputStream is, Type type) throws SerializerException {
            if (is == null) {
                return null;
            }
            try {
                return (T)this.mapper.readValue(is, (com.fasterxml.jackson.core.type.TypeReference)new SimpleTypeReference(type));
            }
            catch (IOException e) {
                throw new SerializerException("Error occurs while parsing object", (Throwable)e);
            }
        }

        public <T> T parseObject(InputStream is, TypeReference<T> reference) throws SerializerException {
            if (is == null) {
                return null;
            }
            try {
                return (T)this.mapper.readValue(is, (com.fasterxml.jackson.core.type.TypeReference)new SimpleTypeReference(reference.getType()));
            }
            catch (IOException e) {
                throw new SerializerException("Error occurs while parsing object", (Throwable)e);
            }
        }

        public void parseArray(Reader reader, Function<Function<Type, Object>, Boolean> function) throws SerializerException {
            try (JsonParser parser = this.mapper.createParser(reader);){
                while (parser.nextToken() != JsonToken.END_ARRAY && function.apply(o -> this.parseObject(parser, (Type)o)).booleanValue()) {
                }
            }
            catch (IOException e) {
                throw new SerializerException("Error occurs while parsing object", (Throwable)e);
            }
        }

        public void parseObject(Reader reader, BiFunction<String, Function<Type, Object>, Boolean> function) throws SerializerException {
            try (JsonParser parser = this.mapper.createParser(reader);){
                while (parser.nextToken() != JsonToken.END_ARRAY && function.apply(parser.getCurrentName(), o -> this.parseObject(parser, (Type)o)).booleanValue()) {
                }
            }
            catch (IOException e) {
                throw new SerializerException("Error occurs while parsing object", (Throwable)e);
            }
        }

        protected Object parseObject(JsonParser parser, Type type) {
            try {
                return parser.readValueAs((com.fasterxml.jackson.core.type.TypeReference)new SimpleTypeReference(type));
            }
            catch (IOException e) {
                throw new SerializerException("Error occurs while parsing object", (Throwable)e);
            }
        }

        public <T> void serialize(OutputStream os, T object) throws SerializerException {
            try {
                this.mapper.writeValue(os, object);
            }
            catch (IOException e) {
                throw new SerializerException("Error occurred serializing object", (Throwable)e);
            }
        }

        public <T> T deserialize(InputStream is, Type type) throws SerializerException {
            if (is == null) {
                return null;
            }
            try {
                return (T)this.mapper.readValue(is, (com.fasterxml.jackson.core.type.TypeReference)new SimpleTypeReference(type));
            }
            catch (IOException e) {
                throw new SerializerException("Error occurs while parsing object", (Throwable)e);
            }
        }
    }
}

