/*
 * Decompiled with CFR 0.152.
 */
package io.joyrpc.codec.serialization.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.joyrpc.protocol.message.Invocation;
import java.io.IOException;
import java.util.Map;

public class InvocationSerializer
extends JsonSerializer<Invocation> {
    public static final JsonSerializer INSTANCE = new InvocationSerializer();

    public void serialize(Invocation invocation, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (invocation == null) {
            gen.writeNull();
        } else {
            gen.writeStartObject();
            gen.writeStringField("className", invocation.getClassName());
            gen.writeStringField("alias", invocation.getAlias());
            gen.writeStringField("methodName", invocation.getMethodName());
            if (invocation.isCallback()) {
                gen.writeFieldName("argsType");
                String[] argsType = invocation.computeArgsType();
                gen.writeArray(argsType, 0, argsType.length);
            }
            gen.writeFieldName("args");
            Object[] args = invocation.getArgs();
            if (args == null) {
                gen.writeNull();
            } else {
                gen.writeStartArray();
                for (Object arg : args) {
                    gen.writeObject(arg);
                }
                gen.writeEndArray();
            }
            Map attachments = invocation.getAttachments();
            if (attachments != null && !attachments.isEmpty()) {
                gen.writeFieldName("attachments");
                gen.writeObject((Object)attachments);
            }
            gen.writeEndObject();
        }
    }
}

