/*
 * Decompiled with CFR 0.152.
 */
package io.joyrpc.codec.serialization.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.joyrpc.codec.serialization.jackson.AbstractDeserializer;
import io.joyrpc.codec.serialization.jackson.SimpleTypeReference;
import io.joyrpc.exception.MethodOverloadException;
import io.joyrpc.exception.SerializerException;
import io.joyrpc.protocol.message.Invocation;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;

public class InvocationDeserializer
extends AbstractDeserializer<Invocation> {
    public static final JsonDeserializer INSTANCE = new InvocationDeserializer();

    public Invocation deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_NULL: {
                return null;
            }
            case START_OBJECT: {
                return this.parse(parser);
            }
        }
        throw new SerializerException("Error occurs while parsing invocation");
    }

    protected Invocation parse(JsonParser parser) throws IOException {
        Invocation invocation = new Invocation();
        try {
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String key = parser.currentName();
                if ("className".equals(key)) {
                    this.readString(parser, "className", false, v -> invocation.setClassName(v));
                    continue;
                }
                if ("alias".equals(key)) {
                    this.readString(parser, "alias", true, v -> invocation.setAlias(v));
                    continue;
                }
                if ("methodName".equals(key)) {
                    this.readString(parser, "methodName", true, v -> invocation.setMethodName(v));
                    continue;
                }
                if ("argsType".equals(key)) {
                    invocation.setArgsType(this.readArgTypes(parser));
                    continue;
                }
                if ("args".equals(key)) {
                    invocation.setArgs(this.parseArgs(parser, invocation.computeTypes()));
                    continue;
                }
                if (!"attachments".equals(key)) continue;
                invocation.addAttachments(this.readAttachments(parser));
            }
        }
        catch (MethodOverloadException | ClassNotFoundException | NoSuchMethodException e) {
            throw new SerializerException(e.getMessage(), e);
        }
        return invocation;
    }

    protected String[] readArgTypes(JsonParser parser) throws IOException {
        switch (parser.nextToken()) {
            case START_ARRAY: {
                return (String[])parser.readValueAs(String[].class);
            }
            case VALUE_NULL: {
                return null;
            }
        }
        throw new SerializerException("Error occurs while parsing invocation");
    }

    protected Map<String, Object> readAttachments(JsonParser parser) throws IOException {
        switch (parser.nextToken()) {
            case START_OBJECT: {
                return (Map)parser.readValueAs((TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            case VALUE_NULL: {
                return null;
            }
        }
        throw new SerializerException("Error occurs while parsing invocation");
    }

    protected Object[] parseArgs(JsonParser parser, Type[] types) throws IOException {
        switch (parser.nextToken()) {
            case START_ARRAY: {
                Object[] objects = new Object[types.length];
                for (int i = 0; i < objects.length; ++i) {
                    parser.nextToken();
                    objects[i] = parser.readValueAs((TypeReference)new SimpleTypeReference(types[i]));
                }
                if (parser.nextToken() != JsonToken.END_ARRAY) {
                    throw new SerializerException("The argument size must be " + types.length);
                }
                return objects;
            }
            case VALUE_NULL: {
                if (types.length == 0) {
                    return new Object[0];
                }
                throw new SerializerException("syntax error: args can not be null");
            }
        }
        throw new SerializerException("Error occurs while parsing invocation");
    }
}

