/*
 * Decompiled with CFR 0.152.
 */
package io.joyrpc.codec.serialization.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.joyrpc.exception.SerializerException;
import java.io.IOException;
import java.util.function.Consumer;

public abstract class AbstractDeserializer<T>
extends JsonDeserializer<T> {
    protected String readString(JsonParser parser, String field, boolean nullable) throws IOException {
        switch (parser.nextToken()) {
            case VALUE_STRING: {
                return parser.getText();
            }
            case VALUE_NULL: {
                if (!nullable) {
                    throw new SerializerException("syntax error:" + field + " can not be null");
                }
                return null;
            }
        }
        throw new SerializerException("syntax error:" + field + " can not be null");
    }

    protected void readString(JsonParser parser, String field, boolean nullable, Consumer<String> consumer) throws IOException {
        consumer.accept(this.readString(parser, field, nullable));
    }
}

