/*
 * Decompiled with CFR 0.152.
 */
package io.joyrpc.protocol.jsonrpc.message;

import io.joyrpc.Plugin;
import io.joyrpc.codec.serialization.Json;
import io.joyrpc.protocol.http.message.AbstractJsonResponseMessage;
import io.joyrpc.protocol.jsonrpc.exception.JsonRpcCodecException;
import io.joyrpc.protocol.jsonrpc.message.JsonRpcError;
import io.joyrpc.protocol.jsonrpc.message.JsonRpcResponse;
import io.joyrpc.protocol.message.MessageHeader;
import io.joyrpc.protocol.message.ResponsePayload;

public class JsonRpcResponseMessage
extends AbstractJsonResponseMessage {
    protected JsonRpcResponse jsonRpcResponse;

    public JsonRpcResponseMessage(JsonRpcResponse jsonRpcResponse) {
        this.jsonRpcResponse = jsonRpcResponse;
    }

    public JsonRpcResponseMessage(MessageHeader header, ResponsePayload response, JsonRpcResponse jsonRpcResponse) {
        super(header, response);
        this.jsonRpcResponse = jsonRpcResponse;
    }

    protected void render() {
        if (!((ResponsePayload)this.response).isError()) {
            this.jsonRpcResponse.setResult(((ResponsePayload)this.response).getResponse());
        } else {
            Throwable exception = ((ResponsePayload)this.response).getException();
            if (exception instanceof JsonRpcCodecException) {
                JsonRpcCodecException jrce = (JsonRpcCodecException)((Object)exception);
                this.jsonRpcResponse.setError(new JsonRpcError(Integer.parseInt(jrce.getErrorCode()), exception.getMessage()));
            } else {
                this.jsonRpcResponse.setError(new JsonRpcError(-32603, exception.getMessage()));
            }
        }
        this.content = ((Json)Plugin.JSON.get()).toJSONBytes((Object)this.jsonRpcResponse);
        this.status = 200;
    }
}

