/*
 * Decompiled with CFR 0.152.
 */
package io.joyrpc.protocol.jsonrpc.controller;

import io.joyrpc.Plugin;
import io.joyrpc.codec.UnsafeByteArrayInputStream;
import io.joyrpc.codec.compression.Compression;
import io.joyrpc.codec.serialization.GenericSerializer;
import io.joyrpc.codec.serialization.Json;
import io.joyrpc.codec.serialization.generic.StandardGenericSerializer;
import io.joyrpc.constants.Constants;
import io.joyrpc.exception.LafException;
import io.joyrpc.exception.MethodOverloadException;
import io.joyrpc.exception.SerializerException;
import io.joyrpc.extension.Extension;
import io.joyrpc.extension.MapParametric;
import io.joyrpc.extension.Parametric;
import io.joyrpc.extension.URL;
import io.joyrpc.protocol.MsgType;
import io.joyrpc.protocol.http.AbstractHttpDecoder;
import io.joyrpc.protocol.http.ContentTypeHandler;
import io.joyrpc.protocol.http.HeaderMapping;
import io.joyrpc.protocol.jsonrpc.exception.JsonRpcCodecException;
import io.joyrpc.protocol.jsonrpc.message.JsonRpcRequest;
import io.joyrpc.protocol.jsonrpc.message.JsonRpcResponse;
import io.joyrpc.protocol.jsonrpc.message.JsonRpcResponseMessage;
import io.joyrpc.protocol.message.Call;
import io.joyrpc.protocol.message.Invocation;
import io.joyrpc.protocol.message.MessageHeader;
import io.joyrpc.protocol.message.RequestMessage;
import io.joyrpc.protocol.message.ResponsePayload;
import io.joyrpc.transport.channel.Channel;
import io.joyrpc.transport.channel.ChannelContext;
import io.joyrpc.transport.http.HttpRequestMessage;
import io.joyrpc.util.ClassUtils;
import io.joyrpc.util.SystemClock;
import java.io.InputStream;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

@Extension(value="application/json-rpc")
public class JsonRpcController
implements ContentTypeHandler {
    public static final String VERSION = "2.0";
    protected GenericSerializer genericSerializer = new StandardGenericSerializer();

    public Object execute(ChannelContext ctx, HttpRequestMessage message, URL url, List<String> params) throws Exception {
        JsonRpcRequest request = null;
        try {
            Map headerMap = message.headers().getAll();
            MapParametric parametric = new MapParametric(headerMap);
            JsonRpcDecoder decoder = new JsonRpcDecoder().url(url).header((Parametric)parametric).body(message.content()).serializer(this.genericSerializer);
            request = decoder.request;
            Invocation invocation = decoder.build();
            MessageHeader header = new MessageHeader(MsgType.BizReq.getType(), 13, 11);
            header.setLength(parametric.getPositive("Content-Length", (Integer)null));
            header.addAttribute(Byte.valueOf(HeaderMapping.KEEP_ALIVE.getNum()), (Object)message.headers().isKeepAlive());
            header.addAttribute(Byte.valueOf(HeaderMapping.ACCEPT_ENCODING.getNum()), (Object)parametric.getString("Accept-Encoding"));
            header.setTimeout(parametric.getTimeout(Constants.TIMEOUT_OPTION).intValue());
            RequestMessage result = RequestMessage.build((MessageHeader)header, (Invocation)invocation, (Channel)ctx.getChannel(), (Parametric)parametric, (long)SystemClock.now());
            result.setResponseSupplier(() -> new JsonRpcResponseMessage(new JsonRpcResponse(VERSION, decoder.request.getId())));
            return result;
        }
        catch (SerializerException e) {
            this.caught(ctx, message, new JsonRpcCodecException("Parse error", e, "-32700", request == null ? null : request.getId()));
        }
        catch (ClassNotFoundException e) {
            this.caught(ctx, message, new JsonRpcCodecException("Invalid Request", e, "-32600", request == null ? null : request.getId()));
        }
        catch (NoSuchMethodException e) {
            this.caught(ctx, message, new JsonRpcCodecException("Method not found", e, "-32601", request == null ? null : request.getId()));
        }
        catch (MethodOverloadException e) {
            this.caught(ctx, message, new JsonRpcCodecException("Invalid Request", e, "-32600", request == null ? null : request.getId()));
        }
        catch (JsonRpcCodecException e) {
            this.caught(ctx, message, e);
        }
        catch (Throwable e) {
            this.caught(ctx, message, new JsonRpcCodecException("Internal error", e, "-32603", request == null ? null : request.getId()));
        }
        return null;
    }

    protected void caught(ChannelContext ctx, HttpRequestMessage message, JsonRpcCodecException exception) {
        MessageHeader header = new MessageHeader(MsgType.BizReq.getType(), 13, 11);
        header.addAttribute(Byte.valueOf(HeaderMapping.KEEP_ALIVE.getNum()), (Object)message.headers().isKeepAlive());
        JsonRpcResponseMessage response = new JsonRpcResponseMessage(header, new ResponsePayload((Throwable)((Object)exception)), new JsonRpcResponse(VERSION, exception.getId()));
        ctx.getChannel().send((Object)response);
    }

    protected static class JsonRpcDecoder
    extends AbstractHttpDecoder {
        protected GenericSerializer serializer;
        protected transient JsonRpcRequest request;

        protected JsonRpcDecoder() {
        }

        public JsonRpcDecoder url(URL url) {
            return (JsonRpcDecoder)super.url(url);
        }

        public JsonRpcDecoder paths(String[] paths) {
            return (JsonRpcDecoder)super.paths(paths);
        }

        public JsonRpcDecoder header(Parametric header) {
            return (JsonRpcDecoder)super.header(header);
        }

        public JsonRpcDecoder body(byte[] body) {
            return (JsonRpcDecoder)super.body(body);
        }

        public JsonRpcDecoder serializer(GenericSerializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public JsonRpcDecoder error(Supplier<LafException> error) {
            return (JsonRpcDecoder)super.error(error);
        }

        protected void parse() throws Exception {
            String[] paths = this.getPaths();
            if (paths.length == 1) {
                this.className = paths[0];
                this.alias = this.header.getString(Constants.ALIAS_OPTION);
            } else if (paths.length == 2) {
                this.className = paths[0];
                this.alias = paths[1];
            } else {
                throw new JsonRpcCodecException("Invalid Request", "-32600", this.request.getId());
            }
            this.intfClass = ClassUtils.forName((String)this.className);
            this.genericClass = ClassUtils.getGenericClass((Class)this.intfClass);
            Compression compression = this.getCompression("Content-Encoding");
            byte[] content = compression == null ? this.body : compression.decompress(this.body);
            this.request = (JsonRpcRequest)((Json)Plugin.JSON.get()).parseObject((InputStream)new UnsafeByteArrayInputStream(content), JsonRpcRequest.class);
            this.methodName = this.request.getMethod();
            String id = this.request.getId();
            if (this.methodName == null || !JsonRpcController.VERSION.equals(this.request.getJsonrpc())) {
                throw new JsonRpcCodecException("Invalid Request", "-32600", this.request.getId());
            }
            if (id == null || !(id instanceof String) && !(id instanceof Number)) {
                throw new JsonRpcCodecException("Invalid Request", "-32600", this.request.getId());
            }
            this.parseMethod();
        }

        protected void parseArg(Invocation invocation) throws Exception {
            Object params = this.request.getParams();
            Parameter[] parameters = this.method.getParameters();
            if (parameters.length == 0) {
                return;
            }
            if (params == null) {
                throw new JsonRpcCodecException("Invalid Request", "-32600", this.request.getId());
            }
            Object args = null;
            if (params instanceof Map) {
                args = this.parseArgs(parameters, (Map)params);
            } else if (params instanceof List) {
                args = this.parseArgs(parameters, (List)params);
            } else if (params.getClass().isArray()) {
                args = params;
            }
            if (args == null) {
                throw new JsonRpcCodecException("Invalid Request", "-32600", this.request.getId());
            }
            invocation.setArgs(new Object[]{null, null, args});
            invocation.setArgs(this.serializer.deserialize((Call)invocation));
        }

        protected Object[] parseArgs(Parameter[] parameters, List<?> params) {
            List<?> objects = params;
            if (objects.size() != parameters.length) {
                throw new JsonRpcCodecException("Invalid Request", "-32600", this.request.getId());
            }
            Object[] args = objects.toArray();
            return args;
        }

        protected Object[] parseArgs(Parameter[] parameters, Map<String, Object> params) {
            if (params.size() != parameters.length) {
                throw new JsonRpcCodecException("Invalid Request", "-32600", this.request.getId());
            }
            Object[] args = new Object[parameters.length];
            int i = 0;
            for (Parameter parameter : parameters) {
                args[i] = params.get(parameter.getName());
                ++i;
            }
            return args;
        }
    }
}

