package joyfill.utils.joyobject

import joyfill.tools.joyobject.MapObject

internal data class ListObject(
    val wrapped: MutableList<Any?>
) : JoyList {
    override fun set(index: Int, value: JoyObject?) = when (value) {
        is JoyList -> when (value) {
            is ListObject -> wrapped[index] = value.wrapped
            else -> TODO("Unsupported JoyList type")
        }

        is JoyLiteral -> wrapped[index] = value.value
        is JoyMap -> when (value) {
            is MapObject -> wrapped[index] = value.wrapped
            else -> TODO("Unsupported JoyMap type")
        }

        null -> wrapped[index] = null
    }

    override fun set(index: Int, value: Number?) {
        wrapped[index] = value
    }

    override fun set(index: Int, value: Boolean?) {
        wrapped[index] = value
    }

    override fun set(index: Int, value: String?) {
        wrapped[index] = value
    }

    override fun get(index: Int): JoyObject? = wrapped[index]?.toJoyObject()

    override fun number(index: Int): Double? = wrapped[index]?.toString()?.toDoubleOrNull()

    override fun string(index: Int): String? = wrapped[index]?.toString()

    override fun boolean(index: Int): Boolean? = wrapped[index]?.toString()?.toBooleanStrictOrNull()

    override fun array(index: Int): JoyList? {
        val list = wrapped[index] as? MutableList<Any?> ?: return null
        return ListObject(list)
    }

    override fun obj(index: Int): JoyMap? {
        val o = wrapped[index] as? MutableMap<String, Any?> ?: return null
        return MapObject(o)
    }

    override fun push(value: Boolean?) {
        wrapped.add(value)
    }

    override fun push(value: Number?) {
        wrapped.add(value)
    }

    override fun push(value: String?) {
        wrapped.add(value)
    }

    override fun pop(): JoyObject? {
        if (wrapped.isEmpty()) return null
        val last = wrapped.last()
        wrapped.remove(last)
        return last?.toJoyObject()
    }

    override fun size(): Int = wrapped.size

    override fun iterator(): Iterator<JoyObject> = wrapped.map { it.toJoyObject() }.iterator()
}