package joyfill.utils.internal

import joyfill.internal.AbstractMappable
import joyfill.utils.Attachment
import joyfill.utils.ID
import joyfill.utils.toAttachment
import joyfill.utils.toNonNullableString
import joyfill.utils.toNullableString

internal class AttachmentImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), Attachment {
    override val id: String by lazy { wrapped[ID].toNonNullableString() }

    override val url: String by lazy { wrapped[Attachment::url.name].toNonNullableString() }

    override val fileName: String? by lazy { wrapped[Attachment::fileName.name].toNullableString() }

    override val filePath: String? by lazy { wrapped[Attachment::filePath.name].toNullableString() }

    override val download: String by lazy { (wrapped[Attachment::download.name].toNullableString()) ?: url }

    override fun copy(id: String, url: String, fileName: String?): Attachment {
        val newWrapped = wrapped.toMutableMap().apply {
            put(ID, id)
            put(Attachment::url.name, url)
            put(Attachment::fileName.name, fileName)
        }
        return newWrapped.toAttachment()
    }

    override fun toString(): String {
        val urlPreview = if (url.startsWith("data:") && url.length > 100) {
            "${url.take(50)}...${url.takeLast(10)} (${url.length} chars)"
        } else {
            url
        }
        return "Attachment(id='$id', url='$urlPreview', name=$fileName, path=$filePath, download='${if (download.length > 100) "${download.take(50)}...${download.takeLast(10)}" else download}')"
    }
}