package joyfill.utils.internal

import joyfill.internal.AbstractMappable
import joyfill.table.Cells
import joyfill.table.Column
import joyfill.table.Row
import joyfill.table.internal.CellsImpl
import joyfill.utils.ID
import joyfill.utils.TIME_ZONE
import joyfill.utils.toNonNullableString
import joyfill.utils.toNullableString

@PublishedApi
internal abstract class AbstractRowImpl(
    columns: List<Column>,
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), Row {
    override val id: String by lazy { wrapped[ID].toNonNullableString() }
    override val cells: Cells by lazy {
        val cells: MutableMap<String, Any?> = when (val cellsValue = wrapped[Row::cells.name]) {
            is MutableMap<*, *> -> cellsValue as MutableMap<String, Any?>
            else -> mutableMapOf()
        }
        CellsImpl(columns, cells)
    }
    override val deleted: Boolean by lazy { wrapped[Row::deleted.name] as? Boolean == true }
    override var timeZone: String?
        get() = wrapped[TIME_ZONE].toNullableString()
        set(value) { wrapped[TIME_ZONE] = value }
}