package joyfill.utils

import joyfill.Mappable
import kotlin.reflect.KProperty

internal fun <T : Mappable> MutableMap<String, Any?>.listAt(
    key: KProperty<List<T>>,
    factory: (MutableMap<String, Any?>) -> T,
): MutableList<T> = listAt(key.name, factory)

internal fun <T : Mappable> MutableMap<String, Any?>.listAt(
    key: String,
    factory: (MutableMap<String, Any?>) -> T,
): MutableList<T> = JsonList(parent = this, key = key, factory = factory)