package joyfill.utils

internal fun Any?.toNullableDouble(): Double? = when (this) {
    is Double -> this
    is Long -> toDouble()
    is Int -> toDouble()
    is Float -> toDouble()
    is String -> toDoubleOrNull()
    else -> null
}

internal fun Any?.toNullableLong(): Long? = when (this) {
    is Long -> this
    is Double -> toLong()
    is Int -> toLong()
    is Float -> toLong()
    is String -> toLongOrNull()
    else -> null
}

internal fun Any?.toNonNullableString(): String = when (this) {
    is Double, is Long, is Int, is Float, is Boolean -> this.toString()
    is String -> this
    null -> ""
    else -> toString()
}

internal fun Any?.toNullableString(): String? = when (this) {
    is Double, is Long, is Int, is Float, is Boolean -> this.toString()
    is String -> this
    else -> null
}