package joyfill.text_area.internal

import joyfill.components.Component
import joyfill.internal.AbstractValueBasedField
import joyfill.text_area.TextAreaField
import joyfill.utils.toNonNullableString

@PublishedApi
internal class TextAreaFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractValueBasedField<String>(wrapped), TextAreaField{
    override var value: String?
        get() = wrapped[Component::value.name].toNonNullableString()
        set(value) {
            wrapped[Component::value.name] = value
        }
}