package joyfill.text_area.internal

import joyfill.text_area.TextAreaCell
import joyfill.text_area.TextAreaColumn
import joyfill.text_area.TextAreaSchema
import joyfill.utils.toNonNullableString

@PublishedApi
internal class TextAreaCellImpl(
    override val column: TextAreaColumn,
    private val wrapped: MutableMap<String, Any?>
) : TextAreaCell, TextAreaSchema by column {
    override var value: String?
        get() = wrapped[column.id].toNonNullableString()
        set(value) {
            wrapped[column.id] = value
        }
}