package joyfill.text.internal

import joyfill.text.TextCell
import joyfill.text.TextColumn
import joyfill.text.TextSchema
import joyfill.utils.toNonNullableString

@PublishedApi
internal class TextCellImpl(
    override val column: TextColumn,
    private val wrapped: MutableMap<String, Any?>
) : TextCell, TextSchema by column {
    override var value: String?
        get() = wrapped[column.id].toNonNullableString()
        set(value) {
            wrapped[column.id] = value
        }
}