package joyfill.table.internal.column

import joyfill.components.Component
import joyfill.components.ComponentSchema

@PublishedApi
internal abstract class AbstractValueBasedColumn<V>(
    wrapped: MutableMap<String, Any?>
) : AbstractColumn(wrapped), ComponentSchema {
    override var value: V?
        get() = wrapped[Component::value.name] as? V
        set(value) {
            wrapped[Component::value.name] = value
        }
}