package joyfill.table.internal.column

import joyfill.Mappable
import joyfill.components.Component
import joyfill.utils.JsonList
import joyfill.value.ListValue

@PublishedApi
internal abstract class AbstractListBasedColumn<V : Mappable>(
    wrapped: MutableMap<String, Any?>,
) : AbstractColumn(wrapped), ListValue<V> {
    abstract fun factory(map: MutableMap<String, Any?>): V
    override val value: MutableList<V> by lazy {
        JsonList(
            factory = { factory(it) },
            parent = wrapped,
            key = Component::value.name,
        )
    }
}