package joyfill.table.internal.column

import joyfill.Field
import joyfill.Type
import joyfill.schemas.internal.AbstractSchema
import joyfill.table.Column
import joyfill.type
import joyfill.utils.ID
import joyfill.utils.joyobject.JoyMap
import joyfill.utils.joyobject.JoyObject
import joyfill.utils.toNonNullableString

abstract class AbstractColumn(
    wrapped: MutableMap<String, Any?>
) : AbstractSchema(wrapped), Column {

    override var id: String
        get() = wrapped[ID].toNonNullableString()
        set(value) {
            wrapped[ID] = value
        }

    override var title: String
        get() = wrapped[Column::title.name].toNonNullableString()
        set(value) {
            wrapped[Column::title.name] = value
        }

    override var type: Type
        get() = wrapped.type()
        set(value) {
            wrapped[Column::type.name] = value
        }

    override var required: Boolean
        get() = wrapped[Column::required.name]?.toString()?.lowercase()?.toBooleanStrictOrNull() == true
        set(value) {
            wrapped[Column::required.name] = value
        }

    override var hidden: Boolean
        get() = wrapped[Field::hidden.name]?.toString()?.toBoolean() == true
        set(value) {
            wrapped[Field::hidden.name] = value
        }

    override val metadata: JoyMap by lazy {
        val key = Column::metadata.name
        val map = wrapped[key] as? MutableMap<String, Any?>
        if(map==null) {
            wrapped[key] = mutableMapOf<String,Any?>()
        }
        JoyObject(wrapped[key] as MutableMap<String, Any?>)
    }
}