package joyfill.table.internal

import joyfill.Field
import joyfill.conditions.internal.table.TableLogicImpl
import joyfill.conditions.table.TableLogic
import joyfill.internal.AbstractListBasedField
import joyfill.table.Column
import joyfill.table.Row
import joyfill.table.TableField
import joyfill.table.TableSchema
import joyfill.table.toColumn
import joyfill.utils.COLUMNS
import joyfill.utils.COLUMN_ORDER
import joyfill.utils.JsonList

@PublishedApi
internal open class TableFieldImpl(
    wrapped: MutableMap<String, Any?>,
) : AbstractListBasedField<Row>(wrapped), TableField {

    override fun factory(map: MutableMap<String, Any?>) = RowImpl(columns, map)

    override val columns: MutableList<Column> by lazy {
        JsonList(
            parent = wrapped,
            key = COLUMNS,
            factory = { it.toColumn() },
        )
    }

    override val columnsOrder by lazy {
        if (wrapped[COLUMN_ORDER] !is MutableList<*>) {
            wrapped[COLUMN_ORDER] = mutableListOf<String>()
        }
        wrapped[COLUMN_ORDER] as MutableList<String>
    }

    override val rowOrder by lazy {
        if (wrapped[TableField::rowOrder.name] !is MutableList<*>) {
            wrapped[TableField::rowOrder.name] = mutableListOf<String>()
        }
        wrapped[TableField::rowOrder.name] as MutableList<String>
    }

    override var root: Boolean
        get() = wrapped[TableField::root.name]?.toString()?.toBoolean() == true
        set(value) {
            wrapped[TableField::root.name] = value
        }

    override val tableLogic: TableLogic? get() = wrapped[Field::logic.name]?.let { TableLogicImpl(it as MutableMap<String, Any?>) }

    override val children: MutableList<String> by lazy {
        if (wrapped[TableSchema::children.name] !is MutableList<*>) {
            wrapped[TableSchema::children.name] = mutableListOf<String>()
        }
        wrapped[TableSchema::children.name] as MutableList<String>
    }
}