package joyfill.table.internal

import joyfill.table.Row
import joyfill.table.TableComponent
import joyfill.table.TableSchema
import joyfill.value.ListValue

class TableComponentImpl(
    private val container: ListValue<Row>,
    private val schema: TableSchema,
) : TableComponent, TableSchema by schema {
    override var identifier = schema.id
    override val columnsOrder get() = schema.columns.map { it.id }.toMutableList()
    override val rowOrder get() = value.map { it.id }.toMutableList()
    override val value by lazy { container.value }
}