package joyfill.table.internal

import joyfill.barcode.BarcodeCell
import joyfill.block.BlockCell
import joyfill.date.DateCell
import joyfill.dropdown.DropdownCell
import joyfill.file.FileCell
import joyfill.image.ImageCell
import joyfill.internal.AbstractMappable
import joyfill.multi_select.MultiSelectCell
import joyfill.number.NumberCell
import joyfill.signature.SignatureCell
import joyfill.table.Cell
import joyfill.table.Cells
import joyfill.table.Column
import joyfill.table.toCell
import joyfill.text.TextCell
import joyfill.text_area.TextAreaCell

@PublishedApi
internal class CellsImpl(
    private val columns: List<Column>,
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), Cells {

    private val cached by lazy { mutableMapOf<String, Cell>() }

    private fun look(key: String?): Column? = columns.find { it.id == key || it.title.equals(key, ignoreCase = true) }

    private val cells by lazy { columns.mapNotNull { find(it.id) } }

    override fun find(key: String?): Cell? {
        if (key == null) return null
        return cached.getOrPut(key) {
            val column = look(key) ?: return null
            wrapped.toCell(column)
        }
    }

    override fun text(key: String?): TextCell? = find(key) as? TextCell

    override fun signature(key: String?): SignatureCell? = find(key) as? SignatureCell

    override fun block(key: String?): BlockCell? = find(key) as? BlockCell

    override fun dropdown(key: String?): DropdownCell? = find(key) as? DropdownCell

    override fun barcode(key: String?): BarcodeCell? = find(key) as? BarcodeCell

    override fun multiSelect(key: String?): MultiSelectCell? = find(key) as? MultiSelectCell

    override fun textArea(key: String?): TextAreaCell? = find(key) as? TextAreaCell

    override fun number(key: String?): NumberCell? = find(key) as? NumberCell

    override fun date(key: String?): DateCell? = find(key) as? DateCell

    override fun image(key: String?): ImageCell? = find(key) as? ImageCell

    override fun file(key: String?): FileCell? = find(key) as? FileCell

    override fun all(): List<Cell> = cells
}

