package joyfill.table

import joyfill.Type
import joyfill.barcode.BarcodeColumn
import joyfill.barcode.internal.BarcodeCellImpl
import joyfill.barcode.internal.BarcodeColumnImpl
import joyfill.block.BlockColumn
import joyfill.block.internal.BlockCellImpl
import joyfill.block.internal.BlockColumnImpl
import joyfill.collection.TableSchemas
import joyfill.collection.internal.TableSchemasImpl
import joyfill.date.DateColumn
import joyfill.date.internal.DateCellImpl
import joyfill.date.internal.DateColumnImpl
import joyfill.dropdown.DropdownColumn
import joyfill.dropdown.internal.DropdownCellImpl
import joyfill.dropdown.internal.DropdownColumnImpl
import joyfill.file.FileColumn
import joyfill.file.internal.FileCellImpl
import joyfill.file.internal.FileColumnImpl
import joyfill.image.ImageColumn
import joyfill.image.internal.ImageCellImpl
import joyfill.image.internal.ImageColumnImpl
import joyfill.multi_select.MultiSelectColumn
import joyfill.multi_select.internal.MultiSelectCellImpl
import joyfill.multi_select.internal.MultiSelectColumnImpl
import joyfill.number.NumberColumn
import joyfill.number.internal.NumberCellImpl
import joyfill.number.internal.NumberColumnImpl
import joyfill.signature.SignatureColumn
import joyfill.signature.internal.SignatureCellImpl
import joyfill.signature.internal.SignatureColumnImpl
import joyfill.table.internal.CellsImpl
import joyfill.table.internal.RowImpl
import joyfill.table.internal.TableFieldImpl
import joyfill.table.internal.column.ColumnVisualPropertiesImpl
import joyfill.table.internal.table.ColumnVisualProperties
import joyfill.text.TextColumn
import joyfill.text.internal.TextCellImpl
import joyfill.text.internal.TextColumnImpl
import joyfill.text_area.TextAreaColumn
import joyfill.text_area.internal.TextAreaCellImpl
import joyfill.text_area.internal.TextAreaColumnImpl
import joyfill.type
import joyfill.unknown.UnknownColumn
import joyfill.unknown.internal.UnknownCellImpl
import joyfill.unknown.internal.UnknownColumnImpl

inline fun MutableMap<String, Any?>.toTableField(): TableField = TableFieldImpl(this)

inline fun MutableMap<String, Any?>.toTableSchemas(): TableSchemas = TableSchemasImpl(this)

inline fun List<Column>.toCells(wrapped: MutableMap<String, Any?>): Cells = CellsImpl(
    columns = this,
    wrapped = wrapped
)

inline fun MutableMap<String, Any?>.toTableRow(columns: List<Column>): Row = RowImpl(columns, this)

inline fun MutableMap<String, Any?>.toColumnVisualProperties(): ColumnVisualProperties = ColumnVisualPropertiesImpl(this)

inline fun MutableMap<String, Any?>.toColumn(): Column = when (type()) {
    Type.text -> TextColumnImpl(this)
    Type.block -> BlockColumnImpl(this)
    Type.textarea -> TextAreaColumnImpl(this)
    Type.dropdown -> DropdownColumnImpl(this)
    Type.barcode -> BarcodeColumnImpl(this)
    Type.number -> NumberColumnImpl(this)
    Type.image -> ImageColumnImpl(this)
    Type.file -> FileColumnImpl(this)
    Type.multiSelect -> MultiSelectColumnImpl(this)
    Type.date -> DateColumnImpl(this)
    Type.signature -> SignatureColumnImpl(this)
    else -> UnknownColumnImpl(this)
}

// Cell
inline fun MutableMap<String, Any?>.toCell(column: Column): Cell = when (column) {
    is TextColumn -> TextCellImpl(column, this)
    is BlockColumn -> BlockCellImpl(column, this)
    is TextAreaColumn -> TextAreaCellImpl(column, this)
    is DropdownColumn -> DropdownCellImpl(column, this)
    is BarcodeColumn -> BarcodeCellImpl(column, this)
    is NumberColumn -> NumberCellImpl(column, this)
    is ImageColumn -> ImageCellImpl(column, this)
    is FileColumn -> FileCellImpl(column, this)
    is SignatureColumn -> SignatureCellImpl(column, this)
    is MultiSelectColumn -> MultiSelectCellImpl(column, this)
    is DateColumn -> DateCellImpl(column, this)
    is UnknownColumn -> UnknownCellImpl(column)
    else -> UnknownCellImpl(column)
}