package joyfill.multi_select.internal

import joyfill.multi_select.MultiSelectColumn
import joyfill.multi_select.MultiSelectField
import joyfill.table.internal.column.AbstractColumn
import joyfill.utils.JsonList
import joyfill.utils.Option
import joyfill.utils.toOption

@PublishedApi
internal class MultiSelectColumnImpl(
    wrapped: MutableMap<String, Any?>,
) : AbstractColumn(wrapped), MultiSelectColumn {
    override val multi: Boolean by lazy {
        wrapped[MultiSelectField::multi.name]?.toString()?.toBooleanStrict() ?: true
    }

    override val options: List<Option> by lazy {
        JsonList(
            parent = wrapped,
            key = MultiSelectColumn::options.name,
            factory = { it.toOption() },
        )
    }

    override val value: MutableList<String> = run {
        val key = MultiSelectField::value.name
        val v = wrapped[key] as? MutableList<String>
        if (v == null) {
            wrapped[key] = mutableListOf<String>()
        }
        wrapped[key] as MutableList<String>
    }
}