package joyfill.internal

import joyfill.Field
import joyfill.FieldPosition
import joyfill.Page
import joyfill.conditions.field.FieldLogic
import joyfill.conditions.internal.field.FieldLogicImpl
import joyfill.table.Column
import joyfill.toPosition
import joyfill.utils.ID
import joyfill.utils.JsonList
import joyfill.utils.POSITIONS
import joyfill.utils.joyobject.JoyMap
import joyfill.utils.joyobject.JoyObject
import joyfill.utils.toNonNullableString
import joyfill.utils.toNullableDouble

@PublishedApi
internal class PageImpl(
    wrapped: MutableMap<String, Any?>,
) : AbstractMappable(wrapped), Page {
    override var id: String
        get() = wrapped[ID].toNonNullableString()
        set(value) {
            wrapped[ID] = value
        }
    override var name: String
        get() = wrapped[Page::name.name].toNonNullableString()
        set(value) {
            wrapped[Page::name.name] = value
        }

    override var identifier: String
        get() = wrapped[Field::identifier.name]?.toString() ?: ""
        set(value) {
            wrapped[Field::identifier.name] = value
        }

    override val positions: MutableList<FieldPosition> by lazy {
        JsonList(
            parent = wrapped,
            key = POSITIONS,
            factory = { it.toPosition() },
        )
    }


    override var logic: FieldLogic?
        get() = wrapped[Page::logic.name]?.let { FieldLogicImpl(it as MutableMap<String, Any?>) }
        set(value) {
            wrapped[Page::logic.name] = value
        }
    override val width: Double get() = wrapped[Page::width.name].toNullableDouble() ?: 0.0

    override val height: Double get() = wrapped[Page::height.name].toNullableDouble() ?: 0.0

    override val rowHeight: Double get() = wrapped[Page::rowHeight.name].toNullableDouble() ?: 0.0

    override val layout: String get() = wrapped[Page::layout.name]?.toString() ?: "default"

    override val presentation: String get() = wrapped[Page::presentation.name]?.toString() ?: "default"

    override val cols: Double get() = wrapped[Page::cols.name].toNullableDouble() ?: 0.0

    override var hidden: Boolean
        get() = wrapped[Page::hidden.name]?.toString()?.toBoolean() == true
        set(value) {
            wrapped[Page::hidden.name] = value
        }

    override val initialHiddenState: Boolean = wrapped[Page::hidden.name]?.toString()?.toBoolean() == true

    override val metadata: JoyMap by lazy {
        val key = Column::metadata.name
        val map = wrapped[key] as? MutableMap<String, Any?>
        if (map == null) {
            wrapped[key] = mutableMapOf<String, Any?>()
        }
        JoyObject(wrapped[key] as MutableMap<String, Any?>)
    }

    override fun toString(): String = "Page(name = $name, hidden = $hidden)"
}