package joyfill.internal

import joyfill.FormulaDefinition
import joyfill.FormulaScope
import joyfill.utils.ID

@PublishedApi
internal class FormularDefinitionImpl(wrapped: MutableMap<String, Any?>) : AbstractMappable(wrapped), FormulaDefinition {
    override val id: String by lazy { wrapped[ID].toString() }

    override val desc: String by lazy { wrapped[FormulaDefinition::desc.name].toString() }

    override val type: String by lazy { wrapped[FormulaDefinition::type.name].toString() }

    override val scope: FormulaScope by lazy {
        try {
            FormulaScope.valueOf(wrapped[FormulaDefinition::scope.name] as String)
        } catch (_: Throwable) {
            FormulaScope.Global
        }
    }

    override val expression: String by lazy { wrapped[FormulaDefinition::expression.name].toString() }
}