package joyfill.internal

import joyfill.File
import joyfill.Page
import joyfill.View
import joyfill.utils.ID
import joyfill.utils.JsonList
import joyfill.utils.toNonNullableString

@PublishedApi
internal class FileImpl(
    wrapped: MutableMap<String, Any?>,
) : AbstractMappable(wrapped), File {

    override var id: String
        get() = wrapped[ID].toNonNullableString()
        set(value) {
            wrapped[ID] = value
        }

    override var identifier: String
        get() = wrapped[File::identifier.name].toNonNullableString()
        set(value) {
            wrapped[File::identifier.name] = value
        }

    override var name: String
        get() = wrapped[File::name.name].toNonNullableString()
        set(value) {
            wrapped[File::name.name] = value
        }

    override val pages: MutableList<Page> by lazy {
        JsonList(
            parent = wrapped,
            key = File::pages.name,
            factory = { PageImpl(it) },
        )
    }

    override val pageOrder: MutableList<String> =
        (wrapped[File::pageOrder.name] as? MutableList<String>) ?: mutableListOf()

    override val views: MutableList<View> by lazy {
        JsonList(
            parent = wrapped,
            key = File::views.name,
            factory = { ViewImpl(it) },
        )
    }
}